/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib.state;

import com.yahoo.text.StringUtilities;
import com.yahoo.vdslib.state.State;
import java.text.ParseException;
import java.util.StringTokenizer;

public class DiskState
implements Cloneable {
    private State state = State.UP;
    private String description = "";
    private double capacity = 1.0;

    public DiskState() {
    }

    public DiskState(State s) {
        this.setState(s);
    }

    public DiskState(State s, String description, double capacity) {
        this.setState(s);
        this.setCapacity(capacity);
        this.setDescription(description);
    }

    public DiskState clone() {
        try {
            return (DiskState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    public DiskState(String serialized) throws ParseException {
        StringTokenizer st = new StringTokenizer(serialized, " \t\f\r\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int index = token.indexOf(58);
            if (index < 0) {
                throw new ParseException("Token " + token + " does not contain ':': " + serialized, 0);
            }
            String key = token.substring(0, index);
            String value = token.substring(index + 1);
            if (key.length() > 0) {
                switch (key.charAt(0)) {
                    case 's': {
                        if (key.length() > 1) break;
                        this.setState(State.get(value));
                        break;
                    }
                    case 'c': {
                        if (key.length() > 1) break;
                        try {
                            this.setCapacity(Double.valueOf(value));
                            break;
                        }
                        catch (Exception e) {
                            throw new ParseException("Illegal disk capacity '" + value + "'. Capacity must be a positive floating point number", 0);
                        }
                    }
                    case 'm': {
                        if (key.length() > 1) break;
                        this.description = StringUtilities.unescape((String)value);
                        break;
                    }
                }
            }
        }
    }

    public String serialize(String prefix, boolean includeDescription) {
        boolean empty = true;
        StringBuilder sb = new StringBuilder();
        if (!this.state.equals((Object)State.UP) || prefix.length() < 2) {
            sb.append(prefix).append("s:").append(this.state.serialize());
            empty = false;
        }
        if (Math.abs(this.capacity - 1.0) > 1.0E-9) {
            if (empty) {
                empty = false;
            } else {
                sb.append(' ');
            }
            sb.append(prefix).append("c:").append(this.capacity);
        }
        if (includeDescription && this.description.length() > 0) {
            if (!empty) {
                sb.append(' ');
            }
            sb.append(prefix).append("m:").append(StringUtilities.escape((String)this.description, (char)' '));
        }
        return sb.toString();
    }

    public State getState() {
        return this.state;
    }

    public double getCapacity() {
        return this.capacity;
    }

    public String getDescription() {
        return this.description;
    }

    public void setState(State s) {
        if (!s.validDiskState()) {
            throw new IllegalArgumentException("State " + s + " is not a valid disk state.");
        }
        this.state = s;
    }

    public void setCapacity(double capacity) {
        if (capacity < 0.0) {
            throw new IllegalArgumentException("Negative capacity makes no sense.");
        }
        this.capacity = capacity;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DiskState(").append(this.state.serialize());
        if (Math.abs(this.capacity - 1.0) > 1.0E-8) {
            sb.append(", capacity ").append(this.capacity);
        }
        if (this.description.length() > 0) {
            sb.append(": ").append(this.description);
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DiskState)) {
            return false;
        }
        DiskState other = (DiskState)o;
        return this.state.equals((Object)other.state) && Math.abs(this.capacity - other.capacity) < 1.0E-8;
    }

    public int hashCode() {
        return this.state.hashCode();
    }
}

