/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib.state;

import com.yahoo.text.StringUtilities;
import com.yahoo.vdslib.state.Diff;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;

public class ClusterState
implements Cloneable {
    private static final NodeState DEFAULT_STORAGE_UP_NODE_STATE = new NodeState(NodeType.STORAGE, State.UP);
    private static final NodeState DEFAULT_DISTRIBUTOR_UP_NODE_STATE = new NodeState(NodeType.DISTRIBUTOR, State.UP);
    private int version = 0;
    private State state = State.DOWN;
    private Map<Node, NodeState> nodeStates = new TreeMap<Node, NodeState>();
    private ArrayList<Integer> nodeCount = new ArrayList(2);
    private String description = "";
    private int distributionBits = 16;
    private boolean official = false;

    public ClusterState(String serialized) throws ParseException {
        this.nodeCount.add(0);
        this.nodeCount.add(0);
        this.deserialize(serialized);
    }

    public static ClusterState stateFromString(String stateStr) {
        try {
            return new ClusterState(stateStr);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ClusterState emptyState() {
        return ClusterState.stateFromString("");
    }

    public ClusterState clone() {
        try {
            ClusterState state = (ClusterState)super.clone();
            state.nodeStates = new TreeMap<Node, NodeState>();
            for (Map.Entry<Node, NodeState> entry : this.nodeStates.entrySet()) {
                state.nodeStates.put(entry.getKey(), entry.getValue().clone());
            }
            state.nodeCount = new ArrayList(2);
            state.nodeCount.add(this.nodeCount.get(0));
            state.nodeCount.add(this.nodeCount.get(1));
            return state;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClusterState)) {
            return false;
        }
        ClusterState other = (ClusterState)o;
        return this.version == other.version && this.state.equals((Object)other.state) && this.distributionBits == other.distributionBits && this.nodeCount.equals(other.nodeCount) && this.nodeStates.equals(other.nodeStates);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.state, this.distributionBits, this.nodeCount, this.nodeStates});
    }

    public boolean similarTo(Object o) {
        if (!(o instanceof ClusterState)) {
            return false;
        }
        ClusterState other = (ClusterState)o;
        return this.similarToImpl(other, this::normalizedNodeStateSimilarTo);
    }

    public boolean similarToIgnoringInitProgress(ClusterState other) {
        return this.similarToImpl(other, this::normalizedNodeStateSimilarToIgnoringInitProgress);
    }

    private boolean similarToImpl(ClusterState other, NodeStateCmp nodeStateCmp) {
        if (other == this) {
            return true;
        }
        if (this.state.equals((Object)State.DOWN) && other.state.equals((Object)State.DOWN)) {
            return true;
        }
        if (!this.metaInformationSimilarTo(other)) {
            return false;
        }
        for (Node node : this.unionNodeSetWith(other.nodeStates.keySet())) {
            NodeState lhs = this.nodeStates.get(node);
            NodeState rhs = other.nodeStates.get(node);
            if (nodeStateCmp.similar(node.getType(), lhs, rhs)) continue;
            return false;
        }
        return true;
    }

    private Set<Node> unionNodeSetWith(Set<Node> otherNodes) {
        TreeSet<Node> unionNodeSet = new TreeSet<Node>(this.nodeStates.keySet());
        unionNodeSet.addAll(otherNodes);
        return unionNodeSet;
    }

    private boolean metaInformationSimilarTo(ClusterState other) {
        if (this.version != other.version || !this.state.equals((Object)other.state)) {
            return false;
        }
        if (this.distributionBits != other.distributionBits) {
            return false;
        }
        return this.nodeCount.equals(other.nodeCount);
    }

    private boolean normalizedNodeStateSimilarTo(NodeType nodeType, NodeState lhs, NodeState rhs) {
        NodeState lhsNormalized = lhs != null ? lhs : ClusterState.defaultUpNodeState(nodeType);
        NodeState rhsNormalized = rhs != null ? rhs : ClusterState.defaultUpNodeState(nodeType);
        return lhsNormalized.similarTo(rhsNormalized);
    }

    private boolean normalizedNodeStateSimilarToIgnoringInitProgress(NodeType nodeType, NodeState lhs, NodeState rhs) {
        NodeState lhsNormalized = lhs != null ? lhs : ClusterState.defaultUpNodeState(nodeType);
        NodeState rhsNormalized = rhs != null ? rhs : ClusterState.defaultUpNodeState(nodeType);
        return lhsNormalized.similarToIgnoringInitProgress(rhsNormalized);
    }

    private static NodeState defaultUpNodeState(NodeType nodeType) {
        return nodeType == NodeType.STORAGE ? DEFAULT_STORAGE_UP_NODE_STATE : DEFAULT_DISTRIBUTOR_UP_NODE_STATE;
    }

    public void setOfficial(boolean official) {
        this.official = official;
    }

    public boolean isOfficial() {
        return this.official;
    }

    private void deserialize(String serialized) throws ParseException {
        this.official = false;
        StringTokenizer st = new StringTokenizer(serialized, " \t\n\f\r", false);
        NodeData nodeData = new NodeData();
        String lastAbsolutePath = "";
        this.state = State.UP;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int index = token.indexOf(58);
            if (index < 0) {
                throw new ParseException("Token " + token + " does not contain ':': " + serialized, 0);
            }
            Object key = token.substring(0, index);
            String value = token.substring(index + 1);
            if (((String)key).length() > 0 && ((String)key).charAt(0) == '.') {
                if (lastAbsolutePath.equals("")) {
                    throw new ParseException("The first path in system state string needs to be absolute, in state: " + serialized, 0);
                }
                key = lastAbsolutePath + (String)key;
            } else {
                lastAbsolutePath = key;
            }
            if (((String)key).length() > 0) {
                switch (((String)key).charAt(0)) {
                    case 'c': {
                        if (!((String)key).equals("cluster")) break;
                        this.setClusterState(State.get(value));
                        break;
                    }
                    case 'b': {
                        if (!((String)key).equals("bits")) break;
                        this.distributionBits = Integer.parseInt(value);
                        break;
                    }
                    case 'v': {
                        if (!((String)key).equals("version")) break;
                        try {
                            this.setVersion(Integer.valueOf(value));
                            break;
                        }
                        catch (Exception e) {
                            throw new ParseException("Illegal version '" + value + "'. Must be an integer, in state: " + serialized, 0);
                        }
                    }
                    case 'm': {
                        if (((String)key).length() > 1) break;
                        this.setDescription(StringUtilities.unescape((String)value));
                        break;
                    }
                    case 'd': 
                    case 's': {
                        Object type;
                        NodeType nodeType = null;
                        int dot = ((String)key).indexOf(46);
                        Object object = type = dot < 0 ? key : ((String)key).substring(0, dot);
                        if (((String)type).equals("storage")) {
                            nodeType = NodeType.STORAGE;
                        } else if (((String)type).equals("distributor")) {
                            nodeType = NodeType.DISTRIBUTOR;
                        }
                        if (nodeType == null) break;
                        if (dot < 0) {
                            int nodeCount;
                            try {
                                nodeCount = Integer.valueOf(value);
                            }
                            catch (Exception e) {
                                throw new ParseException("Illegal node count '" + value + "' in state: " + serialized, 0);
                            }
                            if (nodeCount <= this.nodeCount.get(nodeType.ordinal())) break;
                            this.nodeCount.set(nodeType.ordinal(), nodeCount);
                            break;
                        }
                        int dot2 = ((String)key).indexOf(46, dot + 1);
                        Node node = dot2 < 0 ? new Node(nodeType, Integer.valueOf(((String)key).substring(dot + 1))) : new Node(nodeType, Integer.valueOf(((String)key).substring(dot + 1, dot2)));
                        if (node.getIndex() >= this.nodeCount.get(nodeType.ordinal())) {
                            throw new ParseException("Cannot index " + nodeType + " node " + node.getIndex() + " of " + this.nodeCount.get(nodeType.ordinal()) + " in state: " + serialized, 0);
                        }
                        if (!nodeData.node.equals(node)) {
                            nodeData.addNodeState();
                        }
                        if (dot2 < 0) break;
                        nodeData.sb.append(' ').append(((String)key).substring(dot2 + 1)).append(':').append(value);
                        nodeData.node = node;
                        nodeData.empty = false;
                        break;
                    }
                }
            }
        }
        nodeData.addNodeState();
        this.removeLastNodesDownWithoutReason();
    }

    public String getTextualDifference(ClusterState other) {
        return this.getDiff(other).toString();
    }

    public String getHtmlDifference(ClusterState other) {
        return this.getDiff(other).toHtml();
    }

    private Diff getDiff(ClusterState other) {
        Diff diff = new Diff();
        if (this.version != other.version) {
            diff.add(new Diff.Entry("version", this.version, other.version));
        }
        if (!this.state.equals((Object)other.state)) {
            diff.add(new Diff.Entry("cluster", (Object)this.state, (Object)other.state));
        }
        if (this.distributionBits != other.distributionBits) {
            diff.add(new Diff.Entry("bits", this.distributionBits, other.distributionBits));
        }
        if (this.official != other.official) {
            diff.add(new Diff.Entry("official", this.official, other.official));
        }
        for (NodeType type : NodeType.getTypes()) {
            Diff typeDiff = new Diff();
            int maxCount = Math.max(this.getNodeCount(type), other.getNodeCount(type));
            for (int i = 0; i < maxCount; ++i) {
                Node n = new Node(type, i);
                Diff d = this.getNodeState(n).getDiff(other.getNodeState(n));
                if (!d.differs()) continue;
                typeDiff.add(new Diff.Entry(i, d));
            }
            if (!typeDiff.differs()) continue;
            diff.add(new Diff.Entry((Object)type, typeDiff).splitLine());
        }
        return diff;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.official = false;
        this.version = version;
    }

    public int getDistributionBitCount() {
        return this.distributionBits;
    }

    public void setDistributionBits(int bits) {
        this.distributionBits = bits;
    }

    public State getClusterState() {
        return this.state;
    }

    public void setClusterState(State s) {
        if (!s.validClusterState()) {
            throw new IllegalArgumentException("Illegal cluster state " + s);
        }
        this.state = s;
    }

    public int getNodeCount(NodeType type) {
        return this.nodeCount.get(type.ordinal());
    }

    public NodeState getNodeState(Node node) {
        if (node.getIndex() >= this.nodeCount.get(node.getType().ordinal())) {
            return new NodeState(node.getType(), State.DOWN);
        }
        return this.nodeStates.getOrDefault(node, new NodeState(node.getType(), State.UP));
    }

    public void setNodeState(Node node, NodeState newState) {
        newState.verifyValidInSystemState(node.getType());
        if (node.getIndex() >= this.nodeCount.get(node.getType().ordinal())) {
            for (int i = this.nodeCount.get(node.getType().ordinal()).intValue(); i < node.getIndex(); ++i) {
                this.nodeStates.put(new Node(node.getType(), i), new NodeState(node.getType(), State.DOWN));
            }
            this.nodeCount.set(node.getType().ordinal(), node.getIndex() + 1);
        }
        if (newState.equals(new NodeState(node.getType(), State.UP))) {
            this.nodeStates.remove(node);
        } else {
            this.nodeStates.put(node, newState);
        }
        if (newState.getState().equals((Object)State.DOWN)) {
            this.removeLastNodesDownWithoutReason();
        }
    }

    private void removeLastNodesDownWithoutReason() {
        for (NodeType nodeType : NodeType.values()) {
            Node node;
            NodeState nodeState;
            for (int index = this.nodeCount.get(nodeType.ordinal()) - 1; index >= 0 && (nodeState = this.nodeStates.get(node = new Node(nodeType, index))) != null && nodeState.getState().equals((Object)State.DOWN) && !nodeState.hasDescription(); --index) {
                this.nodeStates.remove(node);
                this.nodeCount.set(nodeType.ordinal(), node.getIndex());
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        String nodeState;
        int distributorNodeCount;
        StringBuilder sb = new StringBuilder();
        if (this.version != 0) {
            sb.append(" version:").append(this.version);
        }
        if (!this.state.equals((Object)State.UP)) {
            sb.append(" cluster:").append(this.state.serialize());
        }
        if (this.distributionBits != 16) {
            sb.append(" bits:").append(this.distributionBits);
        }
        int storageNodeCount = this.getNodeCount(NodeType.STORAGE);
        if (!verbose) {
            for (distributorNodeCount = this.getNodeCount(NodeType.DISTRIBUTOR); distributorNodeCount > 0 && this.getNodeState(new Node(NodeType.DISTRIBUTOR, distributorNodeCount - 1)).getState().equals((Object)State.DOWN); --distributorNodeCount) {
            }
            while (storageNodeCount > 0 && this.getNodeState(new Node(NodeType.STORAGE, storageNodeCount - 1)).getState().equals((Object)State.DOWN)) {
                --storageNodeCount;
            }
        }
        if (distributorNodeCount > 0) {
            sb.append(" distributor:").append(distributorNodeCount);
            for (Map.Entry<Node, NodeState> entry : this.nodeStates.entrySet()) {
                if (!entry.getKey().getType().equals((Object)NodeType.DISTRIBUTOR) || entry.getKey().getIndex() >= distributorNodeCount || (nodeState = entry.getValue().serialize(entry.getKey().getIndex(), verbose)).isEmpty()) continue;
                sb.append(' ').append(nodeState);
            }
        }
        if (storageNodeCount > 0) {
            sb.append(" storage:").append(storageNodeCount);
            for (Map.Entry<Node, NodeState> entry : this.nodeStates.entrySet()) {
                if (!entry.getKey().getType().equals((Object)NodeType.STORAGE) || entry.getKey().getIndex() >= storageNodeCount || (nodeState = entry.getValue().serialize(entry.getKey().getIndex(), verbose)).isEmpty()) continue;
                sb.append(' ').append(nodeState);
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    private class NodeData {
        boolean empty = true;
        Node node = new Node(NodeType.STORAGE, 0);
        StringBuilder sb = new StringBuilder();

        private NodeData() {
        }

        void addNodeState() throws ParseException {
            if (!this.empty) {
                NodeState ns = NodeState.deserialize(this.node.getType(), this.sb.toString());
                if (!ns.equals(ClusterState.defaultUpNodeState(this.node.getType()))) {
                    ClusterState.this.nodeStates.put(this.node, ns);
                }
                if (ClusterState.this.nodeCount.get(this.node.getType().ordinal()) <= this.node.getIndex()) {
                    ClusterState.this.nodeCount.set(this.node.getType().ordinal(), this.node.getIndex() + 1);
                }
            }
            this.empty = true;
            this.sb = new StringBuilder();
        }
    }

    @FunctionalInterface
    private static interface NodeStateCmp {
        public boolean similar(NodeType var1, NodeState var2, NodeState var3);
    }
}

