/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib.distribution;

import com.yahoo.vdslib.distribution.ConfiguredNode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class Group
implements Comparable<Group> {
    private String name;
    private Group parent = null;
    private int index;
    private int distributionHash;
    private Distribution distribution = null;
    private double capacity;
    private Map<Integer, Group> subgroups;
    private List<ConfiguredNode> nodes;

    public Group(int index, String name) {
        this.name = name;
        this.index = index;
        this.distributionHash = 0;
        this.distribution = null;
        this.capacity = 1.0;
        this.nodes = new ArrayList<ConfiguredNode>();
        this.subgroups = null;
    }

    public Group(int index, String name, Distribution d) {
        this.name = name;
        this.index = index;
        this.distributionHash = 0;
        this.distribution = d;
        this.capacity = 1.0;
        this.nodes = null;
        this.subgroups = new TreeMap<Integer, Group>();
    }

    private String getPathWithSeparator(String separator) {
        if (this.parent != null) {
            String prefix = this.parent.getPathWithSeparator(separator);
            return prefix.isEmpty() ? this.name : prefix + separator + this.name;
        }
        return "";
    }

    public String getPath() {
        return this.getPathWithSeparator(".");
    }

    public String getUnixStylePath() {
        return "/" + this.getPathWithSeparator("/");
    }

    @Override
    public int compareTo(Group o) {
        return Integer.valueOf(this.index).compareTo(o.getIndex());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group other = (Group)o;
        return !(!this.name.equals(other.name) || this.index != other.index || this.distribution == null ^ other.distribution == null || this.distribution != null && !this.distribution.equals(other.distribution) || Math.abs(this.capacity - other.capacity) > 1.0E-7 || this.subgroups == null ^ other.subgroups == null || this.subgroups != null && !this.subgroups.equals(other.subgroups)) && !(this.nodes == null ^ other.nodes == null) && (this.nodes == null || this.nodes.equals(other.nodes));
    }

    public int hashCode() {
        return this.name.hashCode() + 17 * this.index + 23 * this.distribution.hashCode() + 43 * this.subgroups.hashCode() + 47 * this.nodes.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append("Group(name: ").append(this.name).append(", index: ").append(this.index);
        if (this.distribution != null) {
            sb.append(", distribution: ").append(this.distribution);
        }
        if (Math.abs(this.capacity - 1.0) > 1.0E-7) {
            sb.append(", capacity: ").append(this.capacity);
        }
        if (this.nodes != null) {
            sb.append(", nodes( ");
            for (ConfiguredNode node : this.nodes) {
                sb.append(node.index()).append(' ');
            }
            sb.append(")");
        }
        if (this.subgroups != null) {
            sb.append(", subgroups: ").append(this.subgroups.size());
        }
        sb.append(") {");
        if (this.subgroups != null && this.subgroups.size() > 0) {
            for (Group g : this.subgroups.values()) {
                sb.append("\n").append(indent).append("  ");
                sb.append(g.toString(indent + "  "));
            }
        }
        sb.append("\n").append(indent).append("}");
        return sb.toString();
    }

    public void addSubGroup(Group g) {
        if (this.distribution == null) {
            throw new IllegalStateException("Cannot add sub groups to a node without distribution set.");
        }
        if (this.subgroups.containsKey(g.getIndex())) {
            throw new IllegalStateException("A subgroup with index " + g.getIndex() + " already exist.");
        }
        if (this.nodes != null) {
            throw new IllegalStateException("Cannot add subgroup to leaf group with nodes");
        }
        g.parent = this;
        this.subgroups.put(g.getIndex(), g);
    }

    public void setCapacity(double c) {
        this.capacity = c;
    }

    public void setNodes(List<ConfiguredNode> nodes) {
        if (this.distribution != null) {
            throw new IllegalStateException("Cannot add nodes to non-leaf group with distribution set");
        }
        if (this.subgroups != null) {
            throw new IllegalStateException("Cannot add nodes to group with children");
        }
        this.nodes = new ArrayList<ConfiguredNode>(nodes);
        Collections.sort(this.nodes);
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public List<ConfiguredNode> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public Map<Integer, Group> getSubgroups() {
        return Collections.unmodifiableMap(this.subgroups);
    }

    public double getCapacity() {
        return this.capacity;
    }

    public int getDistributionHash() {
        return this.distributionHash;
    }

    public boolean isLeafGroup() {
        return this.distribution == null;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    void calculateDistributionHashValues() {
        this.calculateDistributionHashValues(-1951535091);
    }

    private void calculateDistributionHashValues(int parentHash) {
        this.distributionHash = parentHash ^ 1664525 * this.index + 1013904223;
        if (this.subgroups == null) {
            return;
        }
        for (Map.Entry<Integer, Group> entry : this.subgroups.entrySet()) {
            entry.getValue().calculateDistributionHashValues(this.distributionHash);
        }
    }

    public Group getGroupForNode(int index) {
        if (this.nodes != null) {
            for (ConfiguredNode node : this.nodes) {
                if (node.index() != index) continue;
                return this;
            }
        }
        if (this.subgroups != null) {
            for (Group group : this.subgroups.values()) {
                Group retVal = group.getGroupForNode(index);
                if (retVal == null) continue;
                return retVal;
            }
        }
        return null;
    }

    public static class Distribution {
        private final int[] distributionSpec;
        private final int[][] preCalculatedResults;

        public Distribution(String serialized, int maxRedundancy) throws ParseException {
            StringTokenizer st = new StringTokenizer(serialized, "|");
            int[] distributionSpec = new int[st.countTokens()];
            for (int i = 0; i < distributionSpec.length; ++i) {
                String token = st.nextToken();
                try {
                    distributionSpec[i] = token.equals("*") ? 0 : Integer.valueOf(token);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("Illegal distribution spec \"" + serialized + "\". Copy counts must be integer values in the range 1-255.", i);
                }
                if (token.equals("*") || distributionSpec[i] != 0) continue;
                throw new ParseException("Illegal distribution spec \"" + serialized + "\". Copy counts must be in the range 1-255.", i);
            }
            int firstAsterix = distributionSpec.length;
            for (int i = 0; i < distributionSpec.length; ++i) {
                if (i > firstAsterix) {
                    if (distributionSpec[i] == 0) continue;
                    throw new ParseException("Illegal distribution spec \"" + serialized + "\". Asterix specification must be tailing the specification.", i);
                }
                if (i < firstAsterix && distributionSpec[i] == 0) {
                    firstAsterix = i;
                    continue;
                }
                if (distributionSpec[i] > 0 && distributionSpec[i] < 256) continue;
                throw new ParseException("Illegal distribution spec \"" + serialized + "\". Copy counts must be in the range 1-255.", i);
            }
            this.distributionSpec = distributionSpec;
            if (maxRedundancy <= 0 || maxRedundancy > 255) {
                throw new IllegalArgumentException("The max redundancy (" + maxRedundancy + ") must be a positive number in the range 1-255.");
            }
            int asterixCount = distributionSpec.length - firstAsterix;
            int[][] preCalculations = new int[maxRedundancy + 1][];
            for (int i = 1; i <= maxRedundancy; ++i) {
                int j;
                ArrayList<Integer> spec = new ArrayList<Integer>();
                for (int j2 = 0; j2 < distributionSpec.length; ++j2) {
                    spec.add(distributionSpec[j2]);
                }
                int remainingRedundancy = i;
                for (int j3 = 0; j3 < firstAsterix; ++j3) {
                    spec.set(j3, Math.min(remainingRedundancy, (Integer)spec.get(j3)));
                    remainingRedundancy -= ((Integer)spec.get(j3)).intValue();
                }
                int divided = remainingRedundancy / asterixCount;
                remainingRedundancy %= asterixCount;
                for (j = firstAsterix; j < spec.size(); ++j) {
                    spec.set(j, divided + (j - firstAsterix < remainingRedundancy ? 1 : 0));
                }
                while ((Integer)spec.get(spec.size() - 1) == 0) {
                    spec.remove(spec.size() - 1);
                }
                preCalculations[i] = new int[spec.size()];
                Collections.sort(spec);
                for (j = 0; j < spec.size(); ++j) {
                    preCalculations[i][j] = (Integer)spec.get(spec.size() - 1 - j);
                }
            }
            this.preCalculatedResults = preCalculations;
        }

        public int[] getRedundancyArray(int redundancy) {
            if (redundancy == 0 || redundancy >= this.preCalculatedResults.length) {
                throw new IllegalArgumentException("Can only retrieve redundancy arrays in the inclusive range 1-" + (this.preCalculatedResults.length - 1) + ".");
            }
            return this.preCalculatedResults[redundancy];
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Distribution)) {
                return false;
            }
            Distribution other = (Distribution)o;
            return this.distributionSpec == other.distributionSpec && this.preCalculatedResults.length == other.preCalculatedResults.length;
        }

        public int hashCode() {
            return Arrays.hashCode(this.distributionSpec) + 13 * this.preCalculatedResults.length;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.distributionSpec.length; ++i) {
                if (i != 0) {
                    sb.append('|');
                }
                if (this.distributionSpec[i] == 0) {
                    sb.append('*');
                    continue;
                }
                sb.append(this.distributionSpec[i]);
            }
            return sb.toString();
        }
    }
}

