/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vdslib.distribution;

import com.yahoo.collections.BobHash;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.document.BucketId;
import com.yahoo.vdslib.distribution.ConfiguredNode;
import com.yahoo.vdslib.distribution.Group;
import com.yahoo.vdslib.distribution.GroupVisitor;
import com.yahoo.vdslib.distribution.RandomGen;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.DiskState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.config.content.StorDistributionConfig;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;

public class Distribution {
    private final int[] distributionBitMasks = new int[65];
    private ConfigSubscriber configSub;
    private final AtomicReference<Config> config = new AtomicReference<Config>(new Config(null, 1, false));
    private ConfigSubscriber.SingleSubscriber<StorDistributionConfig> configSubscriber = new ConfigSubscriber.SingleSubscriber<StorDistributionConfig>(){

        private int[] getGroupPath(String path) {
            if (path.equals("invalid")) {
                return new int[0];
            }
            StringTokenizer st = new StringTokenizer(path, ".");
            int[] p = new int[st.countTokens()];
            for (int i = 0; i < p.length; ++i) {
                p[i] = Integer.valueOf(st.nextToken());
            }
            return p;
        }

        public void configure(StorDistributionConfig config) {
            try {
                Group root = null;
                for (int i = 0; i < config.group().size(); ++i) {
                    Group group;
                    int index;
                    StorDistributionConfig.Group cg = (StorDistributionConfig.Group)config.group().get(i);
                    int[] path = new int[]{};
                    if (root != null) {
                        path = this.getGroupPath(cg.index());
                    }
                    boolean isLeafGroup = cg.nodes().size() > 0;
                    int n = index = path.length == 0 ? 0 : path[path.length - 1];
                    if (isLeafGroup) {
                        group = new Group(index, cg.name());
                        ArrayList<ConfiguredNode> nodes = new ArrayList<ConfiguredNode>();
                        for (StorDistributionConfig.Group.Nodes node : cg.nodes()) {
                            nodes.add(new ConfiguredNode(node.index(), node.retired()));
                        }
                        group.setNodes(nodes);
                    } else {
                        group = new Group(index, cg.name(), new Group.Distribution(cg.partitions(), config.redundancy()));
                    }
                    group.setCapacity(cg.capacity());
                    if (path.length == 0) {
                        root = group;
                        continue;
                    }
                    Group parent = root;
                    for (int j = 0; j < path.length - 1; ++j) {
                        parent = parent.getSubgroups().get(path[j]);
                    }
                    parent.addSubGroup(group);
                }
                if (root == null) {
                    throw new IllegalStateException("Got config that did not specify even a root group. Need a root group at\nminimum:\n" + config.toString());
                }
                root.calculateDistributionHashValues();
                Distribution.this.config.setRelease(new Config(root, config.redundancy(), config.distributor_auto_ownership_transfer_on_whole_group_down()));
            }
            catch (ParseException e) {
                throw new IllegalStateException("Failed to parse config", e);
            }
        }
    };

    public Group getRootGroup() {
        return this.config.getAcquire().nodeGraph;
    }

    public int getRedundancy() {
        return this.config.getAcquire().redundancy;
    }

    public Distribution(String configId) {
        int mask = 0;
        for (int i = 0; i <= 64; ++i) {
            this.distributionBitMasks[i] = mask;
            mask = mask << 1 | 1;
        }
        try {
            this.configSub = new ConfigSubscriber();
            this.configSub.subscribe(this.configSubscriber, StorDistributionConfig.class, configId);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    public Distribution(StorDistributionConfig config) {
        int mask = 0;
        for (int i = 0; i <= 64; ++i) {
            this.distributionBitMasks[i] = mask;
            mask = mask << 1 | 1;
        }
        this.configSubscriber.configure((ConfigInstance)config);
    }

    public void close() {
        if (this.configSub != null) {
            this.configSub.close();
            this.configSub = null;
        }
        this.configSubscriber = null;
    }

    private int getGroupSeed(BucketId bucket, ClusterState state, Group group) {
        int seed = (int)bucket.getRawId() & this.distributionBitMasks[state.getDistributionBitCount()];
        return seed ^= group.getDistributionHash();
    }

    private int getDistributorSeed(BucketId bucket, ClusterState state) {
        return (int)bucket.getRawId() & this.distributionBitMasks[state.getDistributionBitCount()];
    }

    private int getStorageSeed(BucketId bucket, ClusterState state) {
        int seed = (int)bucket.getRawId() & this.distributionBitMasks[state.getDistributionBitCount()];
        if (bucket.getUsedBits() > 33) {
            int usedBits = bucket.getUsedBits() - 1;
            seed = (int)((long)seed ^ ((long)this.distributionBitMasks[usedBits - 32] & bucket.getRawId() >> 32) << 6);
        }
        return seed;
    }

    private static boolean allDistributorsDown(Group g, ClusterState clusterState) {
        if (g.isLeafGroup()) {
            for (ConfiguredNode node : g.getNodes()) {
                NodeState ns = clusterState.getNodeState(new Node(NodeType.DISTRIBUTOR, node.index()));
                if (!ns.getState().oneOf("ui")) continue;
                return false;
            }
        } else {
            for (Group childGroup : g.getSubgroups().values()) {
                if (Distribution.allDistributorsDown(childGroup, clusterState)) continue;
                return false;
            }
        }
        return true;
    }

    private Group getIdealDistributorGroup(boolean distributorAutoOwnershipTransferOnWholeGroupDown, BucketId bucket, ClusterState clusterState, Group parent, int redundancy) {
        if (parent.isLeafGroup()) {
            return parent;
        }
        int[] redundancyArray = parent.getDistribution().getRedundancyArray(redundancy);
        TreeSet<ScoredGroup> results = new TreeSet<ScoredGroup>();
        int seed = this.getGroupSeed(bucket, clusterState, parent);
        RandomGen random = new RandomGen(seed);
        int currentIndex = 0;
        for (Group g : parent.getSubgroups().values()) {
            while (g.getIndex() < currentIndex++) {
                random.nextDouble();
            }
            double score = random.nextDouble();
            if (Math.abs(g.getCapacity() - 1.0) > 1.0E-7) {
                score = Math.pow(score, 1.0 / g.getCapacity());
            }
            results.add(new ScoredGroup(g, score));
        }
        if (distributorAutoOwnershipTransferOnWholeGroupDown) {
            while (!results.isEmpty() && Distribution.allDistributorsDown(((ScoredGroup)results.first()).group, clusterState)) {
                results.remove(results.first());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return this.getIdealDistributorGroup(distributorAutoOwnershipTransferOnWholeGroupDown, bucket, clusterState, ((ScoredGroup)results.first()).group, redundancyArray[0]);
    }

    private void getIdealGroups(BucketId bucketId, ClusterState clusterState, Group parent, int redundancy, List<ResultGroup> results) {
        if (parent.isLeafGroup()) {
            results.add(new ResultGroup(parent, redundancy));
            return;
        }
        int[] redundancyArray = parent.getDistribution().getRedundancyArray(redundancy);
        ArrayList<ScoredGroup> tmpResults = new ArrayList<ScoredGroup>();
        for (int i = 0; i < redundancyArray.length; ++i) {
            tmpResults.add(new ScoredGroup(null, 0.0));
        }
        int seed = this.getGroupSeed(bucketId, clusterState, parent);
        RandomGen random = new RandomGen(seed);
        int currentIndex = 0;
        Map<Integer, Group> subGroups = parent.getSubgroups();
        for (Map.Entry<Integer, Group> entry : subGroups.entrySet()) {
            while (entry.getKey() < currentIndex++) {
                random.nextDouble();
            }
            double score = random.nextDouble();
            if (entry.getValue().getCapacity() != 1.0) {
                score = Math.pow(score, 1.0 / entry.getValue().getCapacity());
            }
            if (!(score > ((ScoredGroup)tmpResults.get((int)(tmpResults.size() - 1))).score)) continue;
            tmpResults.add(new ScoredGroup(entry.getValue(), score));
            Collections.sort(tmpResults);
            tmpResults.remove(tmpResults.size() - 1);
        }
        for (int i = 0; i < tmpResults.size(); ++i) {
            Group group = ((ScoredGroup)tmpResults.get((int)i)).group;
            if (group == null) continue;
            this.getIdealGroups(bucketId, clusterState, group, redundancyArray[i], results);
        }
    }

    private int getDiskSeed(BucketId bucket, int nodeIndex) {
        long currentid = bucket.withoutCountBits();
        byte[] ordered = new byte[]{(byte)(currentid >> 0), (byte)(currentid >> 8), (byte)(currentid >> 16), (byte)(currentid >> 24), (byte)(currentid >> 32), (byte)(currentid >> 40), (byte)(currentid >> 48), (byte)(currentid >> 56)};
        int initval = 1664525 * nodeIndex + -559038737;
        return BobHash.hash((byte[])ordered, (int)initval);
    }

    int getIdealDisk(NodeState nodeState, int nodeIndex, BucketId bucket) {
        if (nodeState.getDiskCount() < 2) {
            if (nodeState.getDiskCount() == 1) {
                return 0;
            }
            throw new IllegalArgumentException("Cannot pick ideal disk without knowing disk count.");
        }
        RandomGen randomizer = new RandomGen(this.getDiskSeed(bucket, nodeIndex));
        double maxScore = 0.0;
        int idealDisk = 65535;
        int n = nodeState.getDiskCount();
        for (int i = 0; i < n; ++i) {
            double score = randomizer.nextDouble();
            DiskState diskState = nodeState.getDiskState(i);
            if (diskState.getCapacity() != 1.0) {
                score = Math.pow(score, 1.0 / diskState.getCapacity());
            }
            if (!(score > maxScore)) continue;
            maxScore = score;
            idealDisk = i;
        }
        return idealDisk;
    }

    List<Integer> getIdealStorageNodes(ClusterState clusterState, BucketId bucket, String upStates) throws TooFewBucketBitsInUseException {
        ArrayList<Integer> resultNodes = new ArrayList<Integer>();
        if (bucket.getUsedBits() < clusterState.getDistributionBitCount()) {
            String msg = "Cannot get ideal state for bucket " + bucket + " using " + bucket.getUsedBits() + " bits when cluster uses " + clusterState.getDistributionBitCount() + " distribution bits.";
            throw new TooFewBucketBitsInUseException(msg);
        }
        ArrayList<ResultGroup> groupDistribution = new ArrayList<ResultGroup>();
        Config cfg = this.config.getAcquire();
        this.getIdealGroups(bucket, clusterState, cfg.nodeGraph, cfg.redundancy, groupDistribution);
        int seed = this.getStorageSeed(bucket, clusterState);
        RandomGen random = new RandomGen(seed);
        int randomIndex = 0;
        for (ResultGroup group : groupDistribution) {
            int redundancy = group.redundancy;
            List<ConfiguredNode> nodes = group.group.getNodes();
            LinkedList<ScoredNode> tmpResults = new LinkedList<ScoredNode>();
            for (int i = 0; i < redundancy; ++i) {
                tmpResults.add(new ScoredNode(0, 0, 0.0));
            }
            for (ConfiguredNode configuredNode : nodes) {
                int idealDiskIndex;
                NodeState nodeState = clusterState.getNodeState(new Node(NodeType.STORAGE, configuredNode.index()));
                if (!nodeState.getState().oneOf(upStates) || nodeState.isAnyDiskDown() && nodeState.getDiskState(idealDiskIndex = this.getIdealDisk(nodeState, configuredNode.index(), bucket)).getState() != State.UP) continue;
                if (configuredNode.index() != randomIndex) {
                    if (configuredNode.index() < randomIndex) {
                        random.setSeed(seed);
                        randomIndex = 0;
                    }
                    for (int k = randomIndex; k < configuredNode.index(); ++k) {
                        random.nextDouble();
                    }
                    randomIndex = configuredNode.index();
                }
                double score = random.nextDouble();
                ++randomIndex;
                if (nodeState.getCapacity() != 1.0) {
                    score = Math.pow(score, 1.0 / nodeState.getCapacity());
                }
                if (!(score > ((ScoredNode)tmpResults.getLast()).score)) continue;
                for (int i = 0; i < tmpResults.size(); ++i) {
                    if (!(score > ((ScoredNode)tmpResults.get((int)i)).score)) continue;
                    tmpResults.add(i, new ScoredNode(configuredNode.index(), nodeState.getReliability(), score));
                    break;
                }
                tmpResults.removeLast();
            }
            for (ScoredNode node : tmpResults) {
                resultNodes.add(node.index);
            }
        }
        return resultNodes;
    }

    public int getIdealDistributorNode(ClusterState state, BucketId bucket, String upStates) throws TooFewBucketBitsInUseException, NoDistributorsAvailableException {
        if (bucket.getUsedBits() < state.getDistributionBitCount()) {
            throw new TooFewBucketBitsInUseException("Cannot get ideal state for bucket " + bucket + " using " + bucket.getUsedBits() + " bits when cluster uses " + state.getDistributionBitCount() + " distribution bits.");
        }
        Config cfg = this.config.getAcquire();
        Group idealGroup = this.getIdealDistributorGroup(cfg.distributorAutoOwnershipTransferOnWholeGroupDown, bucket, state, cfg.nodeGraph, cfg.redundancy);
        if (idealGroup == null) {
            throw new NoDistributorsAvailableException("No distributors available in cluster state version " + state.getVersion());
        }
        int seed = this.getDistributorSeed(bucket, state);
        RandomGen random = new RandomGen(seed);
        int randomIndex = 0;
        List<ConfiguredNode> configuredNodes = idealGroup.getNodes();
        ScoredNode node = new ScoredNode(0, 0, 0.0);
        for (ConfiguredNode configuredNode : configuredNodes) {
            NodeState nodeState = state.getNodeState(new Node(NodeType.DISTRIBUTOR, configuredNode.index()));
            if (!nodeState.getState().oneOf(upStates)) continue;
            if (configuredNode.index() != randomIndex) {
                if (configuredNode.index() < randomIndex) {
                    random.setSeed(seed);
                    randomIndex = 0;
                }
                for (int k = randomIndex; k < configuredNode.index(); ++k) {
                    random.nextDouble();
                }
                randomIndex = configuredNode.index();
            }
            double score = random.nextDouble();
            ++randomIndex;
            if (Math.abs(nodeState.getCapacity() - 1.0) > 1.0E-7) {
                score = Math.pow(score, 1.0 / nodeState.getCapacity());
            }
            if (!(score > node.score)) continue;
            node = new ScoredNode(configuredNode.index(), 1, score);
        }
        if (node.reliability == 0) {
            throw new NoDistributorsAvailableException("No available distributors in any of the given upstates '" + upStates + "'.");
        }
        return node.index;
    }

    private boolean visitGroups(GroupVisitor visitor, Map<Integer, Group> groups) {
        for (Group g : groups.values()) {
            if (!visitor.visitGroup(g)) {
                return false;
            }
            if (g.isLeafGroup() || this.visitGroups(visitor, g.getSubgroups())) continue;
            return false;
        }
        return true;
    }

    public void visitGroups(GroupVisitor visitor) {
        TreeMap<Integer, Group> groups = new TreeMap<Integer, Group>();
        Group nodeGraph = this.config.getAcquire().nodeGraph;
        groups.put(nodeGraph.getIndex(), nodeGraph);
        this.visitGroups(visitor, groups);
    }

    public Set<ConfiguredNode> getNodes() {
        final HashSet<ConfiguredNode> nodes = new HashSet<ConfiguredNode>();
        GroupVisitor visitor = new GroupVisitor(){

            @Override
            public boolean visitGroup(Group g) {
                if (g.isLeafGroup()) {
                    nodes.addAll(g.getNodes());
                }
                return true;
            }
        };
        this.visitGroups(visitor);
        return nodes;
    }

    public static String getDefaultDistributionConfig(int redundancy, int nodeCount) {
        return Distribution.getDefaultDistributionConfig(redundancy, nodeCount, StorDistributionConfig.Disk_distribution.MODULO_BID);
    }

    public static String getDefaultDistributionConfig(int redundancy, int nodeCount, StorDistributionConfig.Disk_distribution.Enum diskDistribution) {
        StringBuilder sb = new StringBuilder();
        sb.append("raw:redundancy ").append(redundancy).append("\n").append("group[1]\n").append("group[0].index \"invalid\"\n").append("group[0].name \"invalid\"\n").append("group[0].partitions \"*\"\n").append("group[0].nodes[").append(nodeCount).append("]\n");
        for (int i = 0; i < nodeCount; ++i) {
            sb.append("group[0].nodes[").append(i).append("].index ").append(i).append("\n");
        }
        sb.append("disk_distribution ").append(diskDistribution.toString()).append("\n");
        return sb.toString();
    }

    public static String getSimpleGroupConfig(int redundancy, int nodeCount) {
        return Distribution.getSimpleGroupConfig(redundancy, nodeCount, StorDistributionConfig.Disk_distribution.Enum.MODULO_BID);
    }

    private static String getSimpleGroupConfig(int redundancy, int nodeCount, StorDistributionConfig.Disk_distribution.Enum diskDistribution) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("raw:redundancy ").append(redundancy).append("\n").append("group[4]\n");
        int group = 0;
        sb.append("group[" + group + "].index \"invalid\"\n").append("group[" + group + "].name \"invalid\"\n").append("group[" + group + "].partitions \"1|*\"\n");
        sb.append("group[" + ++group + "].index \"0\"\n").append("group[" + group + "].name \"east\"\n").append("group[" + group + "].partitions \"*\"\n");
        sb.append("group[" + ++group + "].index \"0.0\"\n").append("group[" + group + "].name \"g1\"\n").append("group[" + group + "].partitions \"*\"\n").append("group[" + group + "].nodes[").append((nodeCount + 1) / 2).append("]\n");
        for (i = 0; i < nodeCount; i += 2) {
            sb.append("group[" + group + "].nodes[").append(i / 2).append("].index ").append(i).append("\n");
        }
        sb.append("group[" + ++group + "].index \"0.1\"\n").append("group[" + group + "].name \"g2\"\n").append("group[" + group + "].partitions \"*\"\n").append("group[" + group + "].nodes[").append(nodeCount / 2).append("]\n");
        for (i = 1; i < nodeCount; i += 2) {
            sb.append("group[" + group + "].nodes[").append(i / 2).append("].index ").append(i).append("\n");
        }
        sb.append("disk_distribution ").append(diskDistribution.toString()).append("\n");
        return sb.toString();
    }

    public static class NoDistributorsAvailableException
    extends Exception {
        NoDistributorsAvailableException(String message) {
            super(message);
        }
    }

    public static class TooFewBucketBitsInUseException
    extends Exception {
        TooFewBucketBitsInUseException(String message) {
            super(message);
        }
    }

    private static class ResultGroup
    implements Comparable<ResultGroup> {
        Group group;
        int redundancy;

        ResultGroup(Group group, int redundancy) {
            this.group = group;
            this.redundancy = redundancy;
        }

        @Override
        public int compareTo(ResultGroup o) {
            return this.group.compareTo(o.group);
        }
    }

    private static class ScoredNode {
        int index;
        int reliability;
        double score;

        ScoredNode(int index, int reliability, double score) {
            this.index = index;
            this.reliability = reliability;
            this.score = score;
        }
    }

    private static class ScoredGroup
    implements Comparable<ScoredGroup> {
        Group group;
        double score;

        ScoredGroup(Group g, double score) {
            this.group = g;
            this.score = score;
        }

        @Override
        public int compareTo(ScoredGroup o) {
            return Double.compare(o.score, this.score);
        }
    }

    private static class Config {
        private final Group nodeGraph;
        private final int redundancy;
        private final boolean distributorAutoOwnershipTransferOnWholeGroupDown;

        Config(Group nodeGraph, int redundancy, boolean distributorAutoOwnershipTransferOnWholeGroupDown) {
            this.nodeGraph = nodeGraph;
            this.redundancy = redundancy;
            this.distributorAutoOwnershipTransferOnWholeGroupDown = distributorAutoOwnershipTransferOnWholeGroupDown;
        }
    }
}

