/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.test.file;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.jimfs.AttributeProvider;
import com.google.common.jimfs.File;
import com.google.common.jimfs.FileLookup;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class UnixUidGidAttributeProvider
extends AttributeProvider {
    private static final ImmutableSet<String> ATTRIBUTES = ImmutableSet.of((Object)"uid", (Object)"ino", (Object)"dev", (Object)"nlink", (Object)"rdev", (Object)"ctime", (Object[])new String[]{"mode", "gid"});
    private static final ImmutableSet<String> INHERITED_VIEWS = ImmutableSet.of((Object)"basic", (Object)"owner", (Object)"posix");
    private final AtomicInteger uidGenerator = new AtomicInteger();
    private final ConcurrentMap<UserPrincipal, Integer> idCache = new ConcurrentHashMap<UserPrincipal, Integer>();

    public String name() {
        return "unix";
    }

    public ImmutableSet<String> inherits() {
        return INHERITED_VIEWS;
    }

    public ImmutableSet<String> fixedAttributes() {
        return ATTRIBUTES;
    }

    public Class<UnixFileAttributeView> viewType() {
        return UnixFileAttributeView.class;
    }

    public UnixFileAttributeView view(FileLookup lookup, ImmutableMap<String, FileAttributeView> inheritedViews) {
        throw new UnsupportedOperationException();
    }

    private int getUniqueId(UserPrincipal user) {
        return UnixUidGidAttributeProvider.maybeNumber(user.getName()).orElseGet(() -> this.idCache.computeIfAbsent(user, id -> this.uidGenerator.incrementAndGet()));
    }

    public Object get(File file, String attribute) {
        switch (attribute) {
            case "uid": {
                UserPrincipal user = (UserPrincipal)file.getAttribute("owner", "owner");
                return this.getUniqueId(user);
            }
            case "gid": {
                GroupPrincipal group = (GroupPrincipal)file.getAttribute("posix", "group");
                return this.getUniqueId(group);
            }
            case "mode": {
                Set permissions = (Set)file.getAttribute("posix", "permissions");
                return UnixUidGidAttributeProvider.toMode(permissions);
            }
            case "ctime": {
                return FileTime.fromMillis(file.getCreationTime());
            }
            case "rdev": {
                return 0L;
            }
            case "dev": {
                return 1L;
            }
            case "ino": {
                return file.id();
            }
            case "nlink": {
                return file.links();
            }
        }
        return null;
    }

    public void set(File file, String view, String attribute, Object value, boolean create) {
        switch (attribute) {
            case "uid": {
                file.setAttribute("owner", "owner", (Object)new BasicUserPrincipal(String.valueOf(value)));
                return;
            }
            case "gid": {
                file.setAttribute("posix", "group", (Object)new BasicGroupPrincipal(String.valueOf(value)));
                return;
            }
        }
        throw UnixUidGidAttributeProvider.unsettable((String)view, (String)attribute, (boolean)create);
    }

    private static int toMode(Set<PosixFilePermission> permissions) {
        int result = 0;
        block11: for (PosixFilePermission permission : permissions) {
            Preconditions.checkNotNull((Object)((Object)permission));
            switch (permission) {
                case OWNER_READ: {
                    result |= 0x100;
                    continue block11;
                }
                case OWNER_WRITE: {
                    result |= 0x80;
                    continue block11;
                }
                case OWNER_EXECUTE: {
                    result |= 0x40;
                    continue block11;
                }
                case GROUP_READ: {
                    result |= 0x20;
                    continue block11;
                }
                case GROUP_WRITE: {
                    result |= 0x10;
                    continue block11;
                }
                case GROUP_EXECUTE: {
                    result |= 8;
                    continue block11;
                }
                case OTHERS_READ: {
                    result |= 4;
                    continue block11;
                }
                case OTHERS_WRITE: {
                    result |= 2;
                    continue block11;
                }
                case OTHERS_EXECUTE: {
                    result |= 1;
                    continue block11;
                }
            }
            throw new AssertionError();
        }
        return result;
    }

    private static Optional<Integer> maybeNumber(String str) {
        try {
            return Optional.of(Integer.parseInt(str));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    static interface UnixFileAttributeView
    extends FileAttributeView {
    }

    private static class BasicUserPrincipal
    implements UserPrincipal {
        private final String name;

        private BasicUserPrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private static class BasicGroupPrincipal
    extends BasicUserPrincipal
    implements GroupPrincipal {
        private BasicGroupPrincipal(String name) {
            super(name);
        }
    }
}

