/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.cd;

import ai.vespa.hosted.cd.DisabledInRegions;
import ai.vespa.hosted.cd.TestRuntime;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

class DisabledInRegionsCondition
implements ExecutionCondition {
    DisabledInRegionsCondition() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional annotation = AnnotationUtils.findAnnotation((Optional)context.getElement(), DisabledInRegions.class);
        if (annotation.isEmpty()) {
            return ConditionEvaluationResult.enabled((String)(DisabledInRegions.class.getSimpleName() + " is not present"));
        }
        List<String> disablingRegions = List.of(((DisabledInRegions)annotation.get()).value());
        String thisRegion = TestRuntime.get().application().instance();
        String reason = "Disabled in: %s. Current region: %s.".formatted(disablingRegions.isEmpty() ? "no regions" : "regions " + String.join((CharSequence)", ", disablingRegions), thisRegion);
        return disablingRegions.contains(thisRegion) ? ConditionEvaluationResult.disabled((String)reason) : ConditionEvaluationResult.enabled((String)reason);
    }
}

