/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.cd;

import ai.vespa.hosted.cd.EnabledInRegions;
import ai.vespa.hosted.cd.TestRuntime;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

class EnabledInRegionsCondition
implements ExecutionCondition {
    EnabledInRegionsCondition() {
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional annotation = AnnotationUtils.findAnnotation((Optional)context.getElement(), EnabledInRegions.class);
        if (annotation.isEmpty()) {
            return ConditionEvaluationResult.enabled((String)(EnabledInRegions.class.getSimpleName() + " is not present"));
        }
        List<String> enablingRegions = List.of(((EnabledInRegions)annotation.get()).value());
        String thisRegion = TestRuntime.get().application().instance();
        String reason = "Enabled in: %s. Current region: %s.".formatted(enablingRegions.isEmpty() ? "no regions" : "regions " + String.join((CharSequence)", ", enablingRegions), thisRegion);
        return enablingRegions.contains(thisRegion) ? ConditionEvaluationResult.enabled((String)reason) : ConditionEvaluationResult.disabled((String)reason);
    }
}

