/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content.core;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.Node;
import java.util.HashSet;
import java.util.Set;

public final class StorBucketmoverConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "252d8bb21eebd503d1f152176dc12b07";
    public static final String CONFIG_DEF_NAME = "stor-bucketmover";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content.core", "minimum_recheck_interval_in_seconds int default=60 restart", "maximum_recheck_interval_in_seconds int default=3600 restart", "bucket_iteration_chunk int default=1000 restart", "max_target_fill_rate_above_average double default=0.01 restart", "max_history_size int default=10 restart", "max_pending int default=5 restart", "operation_delay int default=0 restart"};
    private final IntegerNode minimum_recheck_interval_in_seconds;
    private final IntegerNode maximum_recheck_interval_in_seconds;
    private final IntegerNode bucket_iteration_chunk;
    private final DoubleNode max_target_fill_rate_above_average;
    private final IntegerNode max_history_size;
    private final IntegerNode max_pending;
    private final IntegerNode operation_delay;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public StorBucketmoverConfig(Builder builder) {
        this(builder, true);
    }

    private StorBucketmoverConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for stor-bucketmover must be initialized: " + builder.__uninitialized);
        }
        this.minimum_recheck_interval_in_seconds = builder.minimum_recheck_interval_in_seconds == null ? new IntegerNode(60) : new IntegerNode(builder.minimum_recheck_interval_in_seconds.intValue());
        this.maximum_recheck_interval_in_seconds = builder.maximum_recheck_interval_in_seconds == null ? new IntegerNode(3600) : new IntegerNode(builder.maximum_recheck_interval_in_seconds.intValue());
        this.bucket_iteration_chunk = builder.bucket_iteration_chunk == null ? new IntegerNode(1000) : new IntegerNode(builder.bucket_iteration_chunk.intValue());
        this.max_target_fill_rate_above_average = builder.max_target_fill_rate_above_average == null ? new DoubleNode(0.01) : new DoubleNode(builder.max_target_fill_rate_above_average.doubleValue());
        this.max_history_size = builder.max_history_size == null ? new IntegerNode(10) : new IntegerNode(builder.max_history_size.intValue());
        this.max_pending = builder.max_pending == null ? new IntegerNode(5) : new IntegerNode(builder.max_pending.intValue());
        this.operation_delay = builder.operation_delay == null ? new IntegerNode(0) : new IntegerNode(builder.operation_delay.intValue());
    }

    public int minimum_recheck_interval_in_seconds() {
        return this.minimum_recheck_interval_in_seconds.value();
    }

    public int maximum_recheck_interval_in_seconds() {
        return this.maximum_recheck_interval_in_seconds.value();
    }

    public int bucket_iteration_chunk() {
        return this.bucket_iteration_chunk.value();
    }

    public double max_target_fill_rate_above_average() {
        return this.max_target_fill_rate_above_average.value();
    }

    public int max_history_size() {
        return this.max_history_size.value();
    }

    public int max_pending() {
        return this.max_pending.value();
    }

    public int operation_delay() {
        return this.operation_delay.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(StorBucketmoverConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.minimum_recheck_interval_in_seconds, (Node)newConfig.minimum_recheck_interval_in_seconds, "minimum_recheck_interval_in_seconds", "Minimum time between bucket database iterations in the bucket mover. The\nminumum time is used when disks starts to get pretty full and we have plenty\nstuff we can move.\nrestart flag was added automatically and needs to be verified.");
        changes.compare((Node)this.maximum_recheck_interval_in_seconds, (Node)newConfig.maximum_recheck_interval_in_seconds, "maximum_recheck_interval_in_seconds", "Maximum time between bucket database iterations in the bucket mover. The\nmaximum time is used when disks have plenty free space, so moving data is\nnot critical.\nrestart flag was added automatically and needs to be verified.");
        changes.compare((Node)this.bucket_iteration_chunk, (Node)newConfig.bucket_iteration_chunk, "bucket_iteration_chunk", "Number of buckets to cache at a time when reading the bucket database\nrestart flag was added automatically and needs to be verified.");
        changes.compare((Node)this.max_target_fill_rate_above_average, (Node)newConfig.max_target_fill_rate_above_average, "max_target_fill_rate_above_average", "Maximum fill rate above average fill rate for a target disk to be eligible\nas a target for a bucket move operation.\nrestart flag was added automatically and needs to be verified.");
        changes.compare((Node)this.max_history_size, (Node)newConfig.max_history_size, "max_history_size", "Number of bucket mover runs to keep in history vector\nrestart flag was added automatically and needs to be verified.");
        changes.compare((Node)this.max_pending, (Node)newConfig.max_pending, "max_pending", "Max concurrent pending bucket move operations scheduled in total.\nrestart flag was added automatically and needs to be verified.");
        changes.compare((Node)this.operation_delay, (Node)newConfig.operation_delay, "operation_delay", "Operation delay. If set, the bucket mover will wait for this amount of\nmilliseconds between each operation. Useful in testing to make move run go\nslow enough to view without that much data.\nrestart flag was added automatically and needs to be verified.");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer minimum_recheck_interval_in_seconds = null;
        private Integer maximum_recheck_interval_in_seconds = null;
        private Integer bucket_iteration_chunk = null;
        private Double max_target_fill_rate_above_average = null;
        private Integer max_history_size = null;
        private Integer max_pending = null;
        private Integer operation_delay = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(StorBucketmoverConfig config) {
            this.minimum_recheck_interval_in_seconds(config.minimum_recheck_interval_in_seconds());
            this.maximum_recheck_interval_in_seconds(config.maximum_recheck_interval_in_seconds());
            this.bucket_iteration_chunk(config.bucket_iteration_chunk());
            this.max_target_fill_rate_above_average(config.max_target_fill_rate_above_average());
            this.max_history_size(config.max_history_size());
            this.max_pending(config.max_pending());
            this.operation_delay(config.operation_delay());
        }

        private Builder override(Builder __superior) {
            if (__superior.minimum_recheck_interval_in_seconds != null) {
                this.minimum_recheck_interval_in_seconds(__superior.minimum_recheck_interval_in_seconds);
            }
            if (__superior.maximum_recheck_interval_in_seconds != null) {
                this.maximum_recheck_interval_in_seconds(__superior.maximum_recheck_interval_in_seconds);
            }
            if (__superior.bucket_iteration_chunk != null) {
                this.bucket_iteration_chunk(__superior.bucket_iteration_chunk);
            }
            if (__superior.max_target_fill_rate_above_average != null) {
                this.max_target_fill_rate_above_average(__superior.max_target_fill_rate_above_average);
            }
            if (__superior.max_history_size != null) {
                this.max_history_size(__superior.max_history_size);
            }
            if (__superior.max_pending != null) {
                this.max_pending(__superior.max_pending);
            }
            if (__superior.operation_delay != null) {
                this.operation_delay(__superior.operation_delay);
            }
            return this;
        }

        public Builder minimum_recheck_interval_in_seconds(int __value) {
            this.minimum_recheck_interval_in_seconds = __value;
            return this;
        }

        private Builder minimum_recheck_interval_in_seconds(String __value) {
            return this.minimum_recheck_interval_in_seconds(Integer.valueOf(__value));
        }

        public Builder maximum_recheck_interval_in_seconds(int __value) {
            this.maximum_recheck_interval_in_seconds = __value;
            return this;
        }

        private Builder maximum_recheck_interval_in_seconds(String __value) {
            return this.maximum_recheck_interval_in_seconds(Integer.valueOf(__value));
        }

        public Builder bucket_iteration_chunk(int __value) {
            this.bucket_iteration_chunk = __value;
            return this;
        }

        private Builder bucket_iteration_chunk(String __value) {
            return this.bucket_iteration_chunk(Integer.valueOf(__value));
        }

        public Builder max_target_fill_rate_above_average(double __value) {
            this.max_target_fill_rate_above_average = __value;
            return this;
        }

        private Builder max_target_fill_rate_above_average(String __value) {
            return this.max_target_fill_rate_above_average(Double.valueOf(__value));
        }

        public Builder max_history_size(int __value) {
            this.max_history_size = __value;
            return this;
        }

        private Builder max_history_size(String __value) {
            return this.max_history_size(Integer.valueOf(__value));
        }

        public Builder max_pending(int __value) {
            this.max_pending = __value;
            return this;
        }

        private Builder max_pending(String __value) {
            return this.max_pending(Integer.valueOf(__value));
        }

        public Builder operation_delay(int __value) {
            this.operation_delay = __value;
            return this;
        }

        private Builder operation_delay(String __value) {
            return this.operation_delay(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return StorBucketmoverConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return StorBucketmoverConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return StorBucketmoverConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public StorBucketmoverConfig build() {
            return new StorBucketmoverConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

