/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content.core;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.Node;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public final class StorDistributormanagerConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "98fa0e3c0f00d5b35842b1c6f611f485";
    public static final String CONFIG_DEF_NAME = "stor-distributormanager";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content.core", "splitsize int default=16772216", "splitcount int default=1024", "joinsize int default=16000000", "joincount int default=512", "minsplitcount int default=16", "garbagecollection.selectiontoremove string default=\"\"", "garbagecollection.interval int default=0", "inlinebucketsplitting bool default=true", "maximum_nodes_per_merge int default=16", "start_distributor_thread bool default=true restart", "enable_join_for_sibling_less_buckets bool default=false", "enable_inconsistent_join bool default=false", "minimum_replica_counting_mode enum { TRUSTED, ANY } default=TRUSTED", "disable_bucket_activation bool default=false", "max_cluster_clock_skew_sec int default=1", "inhibit_merge_sending_on_busy_node_duration_sec int default=1", "allow_stale_reads_during_cluster_state_transitions bool default=false", "simulated_db_pruning_latency_msec int default=0", "simulated_db_merging_latency_msec int default=0", "merge_operations_disabled bool default=false", "use_weak_internal_read_consistency_for_client_gets bool default=false", "max_consecutively_inhibited_maintenance_ticks int default=20", "max_activation_inhibited_out_of_sync_groups int default=0", "num_distributor_stripes int default=0 restart", "enable_operation_cancellation bool default=false", "symmetric_put_and_activate_replica_selection bool default=false", "priority_merge_out_of_sync_copies int default=120", "use_btree_database bool default=true"};
    private final IntegerNode splitsize;
    private final IntegerNode splitcount;
    private final IntegerNode joinsize;
    private final IntegerNode joincount;
    private final IntegerNode minsplitcount;
    private final Garbagecollection garbagecollection;
    private final BooleanNode inlinebucketsplitting;
    private final IntegerNode maximum_nodes_per_merge;
    private final BooleanNode start_distributor_thread;
    private final BooleanNode enable_join_for_sibling_less_buckets;
    private final BooleanNode enable_inconsistent_join;
    private final Minimum_replica_counting_mode minimum_replica_counting_mode;
    private final BooleanNode disable_bucket_activation;
    private final IntegerNode max_cluster_clock_skew_sec;
    private final IntegerNode inhibit_merge_sending_on_busy_node_duration_sec;
    private final BooleanNode allow_stale_reads_during_cluster_state_transitions;
    private final IntegerNode simulated_db_pruning_latency_msec;
    private final IntegerNode simulated_db_merging_latency_msec;
    private final BooleanNode merge_operations_disabled;
    private final BooleanNode use_weak_internal_read_consistency_for_client_gets;
    private final IntegerNode max_consecutively_inhibited_maintenance_ticks;
    private final IntegerNode max_activation_inhibited_out_of_sync_groups;
    private final IntegerNode num_distributor_stripes;
    private final BooleanNode enable_operation_cancellation;
    private final BooleanNode symmetric_put_and_activate_replica_selection;
    private final IntegerNode priority_merge_out_of_sync_copies;
    private final BooleanNode use_btree_database;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public StorDistributormanagerConfig(Builder builder) {
        this(builder, true);
    }

    private StorDistributormanagerConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for stor-distributormanager must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.splitsize = builder.splitsize == null ? new IntegerNode(16772216) : new IntegerNode(builder.splitsize.intValue());
        this.splitcount = builder.splitcount == null ? new IntegerNode(1024) : new IntegerNode(builder.splitcount.intValue());
        this.joinsize = builder.joinsize == null ? new IntegerNode(16000000) : new IntegerNode(builder.joinsize.intValue());
        this.joincount = builder.joincount == null ? new IntegerNode(512) : new IntegerNode(builder.joincount.intValue());
        this.minsplitcount = builder.minsplitcount == null ? new IntegerNode(16) : new IntegerNode(builder.minsplitcount.intValue());
        this.garbagecollection = new Garbagecollection(builder.garbagecollection, throwIfUninitialized);
        this.inlinebucketsplitting = builder.inlinebucketsplitting == null ? new BooleanNode(true) : new BooleanNode(builder.inlinebucketsplitting.booleanValue());
        this.maximum_nodes_per_merge = builder.maximum_nodes_per_merge == null ? new IntegerNode(16) : new IntegerNode(builder.maximum_nodes_per_merge.intValue());
        this.start_distributor_thread = builder.start_distributor_thread == null ? new BooleanNode(true) : new BooleanNode(builder.start_distributor_thread.booleanValue());
        this.enable_join_for_sibling_less_buckets = builder.enable_join_for_sibling_less_buckets == null ? new BooleanNode(false) : new BooleanNode(builder.enable_join_for_sibling_less_buckets.booleanValue());
        this.enable_inconsistent_join = builder.enable_inconsistent_join == null ? new BooleanNode(false) : new BooleanNode(builder.enable_inconsistent_join.booleanValue());
        this.minimum_replica_counting_mode = builder.minimum_replica_counting_mode == null ? new Minimum_replica_counting_mode(Minimum_replica_counting_mode.TRUSTED) : new Minimum_replica_counting_mode(builder.minimum_replica_counting_mode);
        this.disable_bucket_activation = builder.disable_bucket_activation == null ? new BooleanNode(false) : new BooleanNode(builder.disable_bucket_activation.booleanValue());
        this.max_cluster_clock_skew_sec = builder.max_cluster_clock_skew_sec == null ? new IntegerNode(1) : new IntegerNode(builder.max_cluster_clock_skew_sec.intValue());
        this.inhibit_merge_sending_on_busy_node_duration_sec = builder.inhibit_merge_sending_on_busy_node_duration_sec == null ? new IntegerNode(1) : new IntegerNode(builder.inhibit_merge_sending_on_busy_node_duration_sec.intValue());
        this.allow_stale_reads_during_cluster_state_transitions = builder.allow_stale_reads_during_cluster_state_transitions == null ? new BooleanNode(false) : new BooleanNode(builder.allow_stale_reads_during_cluster_state_transitions.booleanValue());
        this.simulated_db_pruning_latency_msec = builder.simulated_db_pruning_latency_msec == null ? new IntegerNode(0) : new IntegerNode(builder.simulated_db_pruning_latency_msec.intValue());
        this.simulated_db_merging_latency_msec = builder.simulated_db_merging_latency_msec == null ? new IntegerNode(0) : new IntegerNode(builder.simulated_db_merging_latency_msec.intValue());
        this.merge_operations_disabled = builder.merge_operations_disabled == null ? new BooleanNode(false) : new BooleanNode(builder.merge_operations_disabled.booleanValue());
        this.use_weak_internal_read_consistency_for_client_gets = builder.use_weak_internal_read_consistency_for_client_gets == null ? new BooleanNode(false) : new BooleanNode(builder.use_weak_internal_read_consistency_for_client_gets.booleanValue());
        this.max_consecutively_inhibited_maintenance_ticks = builder.max_consecutively_inhibited_maintenance_ticks == null ? new IntegerNode(20) : new IntegerNode(builder.max_consecutively_inhibited_maintenance_ticks.intValue());
        this.max_activation_inhibited_out_of_sync_groups = builder.max_activation_inhibited_out_of_sync_groups == null ? new IntegerNode(0) : new IntegerNode(builder.max_activation_inhibited_out_of_sync_groups.intValue());
        this.num_distributor_stripes = builder.num_distributor_stripes == null ? new IntegerNode(0) : new IntegerNode(builder.num_distributor_stripes.intValue());
        this.enable_operation_cancellation = builder.enable_operation_cancellation == null ? new BooleanNode(false) : new BooleanNode(builder.enable_operation_cancellation.booleanValue());
        this.symmetric_put_and_activate_replica_selection = builder.symmetric_put_and_activate_replica_selection == null ? new BooleanNode(false) : new BooleanNode(builder.symmetric_put_and_activate_replica_selection.booleanValue());
        this.priority_merge_out_of_sync_copies = builder.priority_merge_out_of_sync_copies == null ? new IntegerNode(120) : new IntegerNode(builder.priority_merge_out_of_sync_copies.intValue());
        this.use_btree_database = builder.use_btree_database == null ? new BooleanNode(true) : new BooleanNode(builder.use_btree_database.booleanValue());
    }

    public int splitsize() {
        return this.splitsize.value();
    }

    public int splitcount() {
        return this.splitcount.value();
    }

    public int joinsize() {
        return this.joinsize.value();
    }

    public int joincount() {
        return this.joincount.value();
    }

    public int minsplitcount() {
        return this.minsplitcount.value();
    }

    public Garbagecollection garbagecollection() {
        return this.garbagecollection;
    }

    public boolean inlinebucketsplitting() {
        return this.inlinebucketsplitting.value();
    }

    public int maximum_nodes_per_merge() {
        return this.maximum_nodes_per_merge.value();
    }

    public boolean start_distributor_thread() {
        return this.start_distributor_thread.value();
    }

    public boolean enable_join_for_sibling_less_buckets() {
        return this.enable_join_for_sibling_less_buckets.value();
    }

    public boolean enable_inconsistent_join() {
        return this.enable_inconsistent_join.value();
    }

    public Minimum_replica_counting_mode.Enum minimum_replica_counting_mode() {
        return (Minimum_replica_counting_mode.Enum)((Object)this.minimum_replica_counting_mode.value());
    }

    public boolean disable_bucket_activation() {
        return this.disable_bucket_activation.value();
    }

    public int max_cluster_clock_skew_sec() {
        return this.max_cluster_clock_skew_sec.value();
    }

    public int inhibit_merge_sending_on_busy_node_duration_sec() {
        return this.inhibit_merge_sending_on_busy_node_duration_sec.value();
    }

    public boolean allow_stale_reads_during_cluster_state_transitions() {
        return this.allow_stale_reads_during_cluster_state_transitions.value();
    }

    public int simulated_db_pruning_latency_msec() {
        return this.simulated_db_pruning_latency_msec.value();
    }

    public int simulated_db_merging_latency_msec() {
        return this.simulated_db_merging_latency_msec.value();
    }

    public boolean merge_operations_disabled() {
        return this.merge_operations_disabled.value();
    }

    public boolean use_weak_internal_read_consistency_for_client_gets() {
        return this.use_weak_internal_read_consistency_for_client_gets.value();
    }

    public int max_consecutively_inhibited_maintenance_ticks() {
        return this.max_consecutively_inhibited_maintenance_ticks.value();
    }

    public int max_activation_inhibited_out_of_sync_groups() {
        return this.max_activation_inhibited_out_of_sync_groups.value();
    }

    public int num_distributor_stripes() {
        return this.num_distributor_stripes.value();
    }

    public boolean enable_operation_cancellation() {
        return this.enable_operation_cancellation.value();
    }

    public boolean symmetric_put_and_activate_replica_selection() {
        return this.symmetric_put_and_activate_replica_selection.value();
    }

    public int priority_merge_out_of_sync_copies() {
        return this.priority_merge_out_of_sync_copies.value();
    }

    public boolean use_btree_database() {
        return this.use_btree_database.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(StorDistributormanagerConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.start_distributor_thread, (Node)newConfig.start_distributor_thread, "start_distributor_thread", "For internal in process debugging, it may be useful to not start the\ndistributor thread to be able to call tick() manually and run single threaded");
        changes.compare((Node)this.num_distributor_stripes, (Node)newConfig.num_distributor_stripes, "num_distributor_stripes", "Specifies the number of stripes over which a distributor internally distributes\nits buckets and operation processing. Every stripe receives its own thread.\nIf <= 0, the number of stripes is inferred automatically based on the number of\nCPU cores available. If > 0, the number of stripes is explicitly overridden.\nStripe counts must be a power of two.");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer splitsize = null;
        private Integer splitcount = null;
        private Integer joinsize = null;
        private Integer joincount = null;
        private Integer minsplitcount = null;
        public Garbagecollection.Builder garbagecollection = new Garbagecollection.Builder();
        private Boolean inlinebucketsplitting = null;
        private Integer maximum_nodes_per_merge = null;
        private Boolean start_distributor_thread = null;
        private Boolean enable_join_for_sibling_less_buckets = null;
        private Boolean enable_inconsistent_join = null;
        private Minimum_replica_counting_mode.Enum minimum_replica_counting_mode = null;
        private Boolean disable_bucket_activation = null;
        private Integer max_cluster_clock_skew_sec = null;
        private Integer inhibit_merge_sending_on_busy_node_duration_sec = null;
        private Boolean allow_stale_reads_during_cluster_state_transitions = null;
        private Integer simulated_db_pruning_latency_msec = null;
        private Integer simulated_db_merging_latency_msec = null;
        private Boolean merge_operations_disabled = null;
        private Boolean use_weak_internal_read_consistency_for_client_gets = null;
        private Integer max_consecutively_inhibited_maintenance_ticks = null;
        private Integer max_activation_inhibited_out_of_sync_groups = null;
        private Integer num_distributor_stripes = null;
        private Boolean enable_operation_cancellation = null;
        private Boolean symmetric_put_and_activate_replica_selection = null;
        private Integer priority_merge_out_of_sync_copies = null;
        private Boolean use_btree_database = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(StorDistributormanagerConfig config) {
            this.splitsize(config.splitsize());
            this.splitcount(config.splitcount());
            this.joinsize(config.joinsize());
            this.joincount(config.joincount());
            this.minsplitcount(config.minsplitcount());
            this.garbagecollection(new Garbagecollection.Builder(config.garbagecollection()));
            this.inlinebucketsplitting(config.inlinebucketsplitting());
            this.maximum_nodes_per_merge(config.maximum_nodes_per_merge());
            this.start_distributor_thread(config.start_distributor_thread());
            this.enable_join_for_sibling_less_buckets(config.enable_join_for_sibling_less_buckets());
            this.enable_inconsistent_join(config.enable_inconsistent_join());
            this.minimum_replica_counting_mode(config.minimum_replica_counting_mode());
            this.disable_bucket_activation(config.disable_bucket_activation());
            this.max_cluster_clock_skew_sec(config.max_cluster_clock_skew_sec());
            this.inhibit_merge_sending_on_busy_node_duration_sec(config.inhibit_merge_sending_on_busy_node_duration_sec());
            this.allow_stale_reads_during_cluster_state_transitions(config.allow_stale_reads_during_cluster_state_transitions());
            this.simulated_db_pruning_latency_msec(config.simulated_db_pruning_latency_msec());
            this.simulated_db_merging_latency_msec(config.simulated_db_merging_latency_msec());
            this.merge_operations_disabled(config.merge_operations_disabled());
            this.use_weak_internal_read_consistency_for_client_gets(config.use_weak_internal_read_consistency_for_client_gets());
            this.max_consecutively_inhibited_maintenance_ticks(config.max_consecutively_inhibited_maintenance_ticks());
            this.max_activation_inhibited_out_of_sync_groups(config.max_activation_inhibited_out_of_sync_groups());
            this.num_distributor_stripes(config.num_distributor_stripes());
            this.enable_operation_cancellation(config.enable_operation_cancellation());
            this.symmetric_put_and_activate_replica_selection(config.symmetric_put_and_activate_replica_selection());
            this.priority_merge_out_of_sync_copies(config.priority_merge_out_of_sync_copies());
            this.use_btree_database(config.use_btree_database());
        }

        private Builder override(Builder __superior) {
            if (__superior.splitsize != null) {
                this.splitsize(__superior.splitsize);
            }
            if (__superior.splitcount != null) {
                this.splitcount(__superior.splitcount);
            }
            if (__superior.joinsize != null) {
                this.joinsize(__superior.joinsize);
            }
            if (__superior.joincount != null) {
                this.joincount(__superior.joincount);
            }
            if (__superior.minsplitcount != null) {
                this.minsplitcount(__superior.minsplitcount);
            }
            this.garbagecollection(this.garbagecollection.override(__superior.garbagecollection));
            if (__superior.inlinebucketsplitting != null) {
                this.inlinebucketsplitting(__superior.inlinebucketsplitting);
            }
            if (__superior.maximum_nodes_per_merge != null) {
                this.maximum_nodes_per_merge(__superior.maximum_nodes_per_merge);
            }
            if (__superior.start_distributor_thread != null) {
                this.start_distributor_thread(__superior.start_distributor_thread);
            }
            if (__superior.enable_join_for_sibling_less_buckets != null) {
                this.enable_join_for_sibling_less_buckets(__superior.enable_join_for_sibling_less_buckets);
            }
            if (__superior.enable_inconsistent_join != null) {
                this.enable_inconsistent_join(__superior.enable_inconsistent_join);
            }
            if (__superior.minimum_replica_counting_mode != null) {
                this.minimum_replica_counting_mode(__superior.minimum_replica_counting_mode);
            }
            if (__superior.disable_bucket_activation != null) {
                this.disable_bucket_activation(__superior.disable_bucket_activation);
            }
            if (__superior.max_cluster_clock_skew_sec != null) {
                this.max_cluster_clock_skew_sec(__superior.max_cluster_clock_skew_sec);
            }
            if (__superior.inhibit_merge_sending_on_busy_node_duration_sec != null) {
                this.inhibit_merge_sending_on_busy_node_duration_sec(__superior.inhibit_merge_sending_on_busy_node_duration_sec);
            }
            if (__superior.allow_stale_reads_during_cluster_state_transitions != null) {
                this.allow_stale_reads_during_cluster_state_transitions(__superior.allow_stale_reads_during_cluster_state_transitions);
            }
            if (__superior.simulated_db_pruning_latency_msec != null) {
                this.simulated_db_pruning_latency_msec(__superior.simulated_db_pruning_latency_msec);
            }
            if (__superior.simulated_db_merging_latency_msec != null) {
                this.simulated_db_merging_latency_msec(__superior.simulated_db_merging_latency_msec);
            }
            if (__superior.merge_operations_disabled != null) {
                this.merge_operations_disabled(__superior.merge_operations_disabled);
            }
            if (__superior.use_weak_internal_read_consistency_for_client_gets != null) {
                this.use_weak_internal_read_consistency_for_client_gets(__superior.use_weak_internal_read_consistency_for_client_gets);
            }
            if (__superior.max_consecutively_inhibited_maintenance_ticks != null) {
                this.max_consecutively_inhibited_maintenance_ticks(__superior.max_consecutively_inhibited_maintenance_ticks);
            }
            if (__superior.max_activation_inhibited_out_of_sync_groups != null) {
                this.max_activation_inhibited_out_of_sync_groups(__superior.max_activation_inhibited_out_of_sync_groups);
            }
            if (__superior.num_distributor_stripes != null) {
                this.num_distributor_stripes(__superior.num_distributor_stripes);
            }
            if (__superior.enable_operation_cancellation != null) {
                this.enable_operation_cancellation(__superior.enable_operation_cancellation);
            }
            if (__superior.symmetric_put_and_activate_replica_selection != null) {
                this.symmetric_put_and_activate_replica_selection(__superior.symmetric_put_and_activate_replica_selection);
            }
            if (__superior.priority_merge_out_of_sync_copies != null) {
                this.priority_merge_out_of_sync_copies(__superior.priority_merge_out_of_sync_copies);
            }
            if (__superior.use_btree_database != null) {
                this.use_btree_database(__superior.use_btree_database);
            }
            return this;
        }

        public Builder splitsize(int __value) {
            this.splitsize = __value;
            return this;
        }

        private Builder splitsize(String __value) {
            return this.splitsize(Integer.valueOf(__value));
        }

        public Builder splitcount(int __value) {
            this.splitcount = __value;
            return this;
        }

        private Builder splitcount(String __value) {
            return this.splitcount(Integer.valueOf(__value));
        }

        public Builder joinsize(int __value) {
            this.joinsize = __value;
            return this;
        }

        private Builder joinsize(String __value) {
            return this.joinsize(Integer.valueOf(__value));
        }

        public Builder joincount(int __value) {
            this.joincount = __value;
            return this;
        }

        private Builder joincount(String __value) {
            return this.joincount(Integer.valueOf(__value));
        }

        public Builder minsplitcount(int __value) {
            this.minsplitcount = __value;
            return this;
        }

        private Builder minsplitcount(String __value) {
            return this.minsplitcount(Integer.valueOf(__value));
        }

        public Builder garbagecollection(Garbagecollection.Builder __builder) {
            this.garbagecollection = __builder;
            return this;
        }

        public Builder garbagecollection(Consumer<Garbagecollection.Builder> __func) {
            Garbagecollection.Builder __inner = new Garbagecollection.Builder();
            __func.accept(__inner);
            this.garbagecollection = __inner;
            return this;
        }

        public Builder inlinebucketsplitting(boolean __value) {
            this.inlinebucketsplitting = __value;
            return this;
        }

        private Builder inlinebucketsplitting(String __value) {
            return this.inlinebucketsplitting(Boolean.valueOf(__value));
        }

        public Builder maximum_nodes_per_merge(int __value) {
            this.maximum_nodes_per_merge = __value;
            return this;
        }

        private Builder maximum_nodes_per_merge(String __value) {
            return this.maximum_nodes_per_merge(Integer.valueOf(__value));
        }

        public Builder start_distributor_thread(boolean __value) {
            this.start_distributor_thread = __value;
            return this;
        }

        private Builder start_distributor_thread(String __value) {
            return this.start_distributor_thread(Boolean.valueOf(__value));
        }

        public Builder enable_join_for_sibling_less_buckets(boolean __value) {
            this.enable_join_for_sibling_less_buckets = __value;
            return this;
        }

        private Builder enable_join_for_sibling_less_buckets(String __value) {
            return this.enable_join_for_sibling_less_buckets(Boolean.valueOf(__value));
        }

        public Builder enable_inconsistent_join(boolean __value) {
            this.enable_inconsistent_join = __value;
            return this;
        }

        private Builder enable_inconsistent_join(String __value) {
            return this.enable_inconsistent_join(Boolean.valueOf(__value));
        }

        public Builder minimum_replica_counting_mode(Minimum_replica_counting_mode.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.minimum_replica_counting_mode = __value;
            return this;
        }

        private Builder minimum_replica_counting_mode(String __value) {
            return this.minimum_replica_counting_mode(Minimum_replica_counting_mode.Enum.valueOf(__value));
        }

        public Builder disable_bucket_activation(boolean __value) {
            this.disable_bucket_activation = __value;
            return this;
        }

        private Builder disable_bucket_activation(String __value) {
            return this.disable_bucket_activation(Boolean.valueOf(__value));
        }

        public Builder max_cluster_clock_skew_sec(int __value) {
            this.max_cluster_clock_skew_sec = __value;
            return this;
        }

        private Builder max_cluster_clock_skew_sec(String __value) {
            return this.max_cluster_clock_skew_sec(Integer.valueOf(__value));
        }

        public Builder inhibit_merge_sending_on_busy_node_duration_sec(int __value) {
            this.inhibit_merge_sending_on_busy_node_duration_sec = __value;
            return this;
        }

        private Builder inhibit_merge_sending_on_busy_node_duration_sec(String __value) {
            return this.inhibit_merge_sending_on_busy_node_duration_sec(Integer.valueOf(__value));
        }

        public Builder allow_stale_reads_during_cluster_state_transitions(boolean __value) {
            this.allow_stale_reads_during_cluster_state_transitions = __value;
            return this;
        }

        private Builder allow_stale_reads_during_cluster_state_transitions(String __value) {
            return this.allow_stale_reads_during_cluster_state_transitions(Boolean.valueOf(__value));
        }

        public Builder simulated_db_pruning_latency_msec(int __value) {
            this.simulated_db_pruning_latency_msec = __value;
            return this;
        }

        private Builder simulated_db_pruning_latency_msec(String __value) {
            return this.simulated_db_pruning_latency_msec(Integer.valueOf(__value));
        }

        public Builder simulated_db_merging_latency_msec(int __value) {
            this.simulated_db_merging_latency_msec = __value;
            return this;
        }

        private Builder simulated_db_merging_latency_msec(String __value) {
            return this.simulated_db_merging_latency_msec(Integer.valueOf(__value));
        }

        public Builder merge_operations_disabled(boolean __value) {
            this.merge_operations_disabled = __value;
            return this;
        }

        private Builder merge_operations_disabled(String __value) {
            return this.merge_operations_disabled(Boolean.valueOf(__value));
        }

        public Builder use_weak_internal_read_consistency_for_client_gets(boolean __value) {
            this.use_weak_internal_read_consistency_for_client_gets = __value;
            return this;
        }

        private Builder use_weak_internal_read_consistency_for_client_gets(String __value) {
            return this.use_weak_internal_read_consistency_for_client_gets(Boolean.valueOf(__value));
        }

        public Builder max_consecutively_inhibited_maintenance_ticks(int __value) {
            this.max_consecutively_inhibited_maintenance_ticks = __value;
            return this;
        }

        private Builder max_consecutively_inhibited_maintenance_ticks(String __value) {
            return this.max_consecutively_inhibited_maintenance_ticks(Integer.valueOf(__value));
        }

        public Builder max_activation_inhibited_out_of_sync_groups(int __value) {
            this.max_activation_inhibited_out_of_sync_groups = __value;
            return this;
        }

        private Builder max_activation_inhibited_out_of_sync_groups(String __value) {
            return this.max_activation_inhibited_out_of_sync_groups(Integer.valueOf(__value));
        }

        public Builder num_distributor_stripes(int __value) {
            this.num_distributor_stripes = __value;
            return this;
        }

        private Builder num_distributor_stripes(String __value) {
            return this.num_distributor_stripes(Integer.valueOf(__value));
        }

        public Builder enable_operation_cancellation(boolean __value) {
            this.enable_operation_cancellation = __value;
            return this;
        }

        private Builder enable_operation_cancellation(String __value) {
            return this.enable_operation_cancellation(Boolean.valueOf(__value));
        }

        public Builder symmetric_put_and_activate_replica_selection(boolean __value) {
            this.symmetric_put_and_activate_replica_selection = __value;
            return this;
        }

        private Builder symmetric_put_and_activate_replica_selection(String __value) {
            return this.symmetric_put_and_activate_replica_selection(Boolean.valueOf(__value));
        }

        public Builder priority_merge_out_of_sync_copies(int __value) {
            this.priority_merge_out_of_sync_copies = __value;
            return this;
        }

        private Builder priority_merge_out_of_sync_copies(String __value) {
            return this.priority_merge_out_of_sync_copies(Integer.valueOf(__value));
        }

        public Builder use_btree_database(boolean __value) {
            this.use_btree_database = __value;
            return this;
        }

        private Builder use_btree_database(String __value) {
            return this.use_btree_database(Boolean.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return StorDistributormanagerConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return StorDistributormanagerConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return StorDistributormanagerConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public StorDistributormanagerConfig build() {
            return new StorDistributormanagerConfig(this);
        }
    }

    public static final class Garbagecollection
    extends InnerNode {
        private final StringNode selectiontoremove;
        private final IntegerNode interval;

        public Garbagecollection(Builder builder) {
            this(builder, true);
        }

        private Garbagecollection(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for stor-distributormanager.garbagecollection must be initialized: " + String.valueOf(builder.__uninitialized));
            }
            this.selectiontoremove = builder.selectiontoremove == null ? new StringNode("") : new StringNode(builder.selectiontoremove);
            this.interval = builder.interval == null ? new IntegerNode(0) : new IntegerNode(builder.interval.intValue());
        }

        public String selectiontoremove() {
            return this.selectiontoremove.value();
        }

        public int interval() {
            return this.interval.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Garbagecollection newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("garbagecollection");
            return changes;
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private String selectiontoremove = null;
            private Integer interval = null;

            public Builder() {
            }

            public Builder(Garbagecollection config) {
                this.selectiontoremove(config.selectiontoremove());
                this.interval(config.interval());
            }

            private Builder override(Builder __superior) {
                if (__superior.selectiontoremove != null) {
                    this.selectiontoremove(__superior.selectiontoremove);
                }
                if (__superior.interval != null) {
                    this.interval(__superior.interval);
                }
                return this;
            }

            public Builder selectiontoremove(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.selectiontoremove = __value;
                return this;
            }

            public Builder interval(int __value) {
                this.interval = __value;
                return this;
            }

            private Builder interval(String __value) {
                return this.interval(Integer.valueOf(__value));
            }

            public Garbagecollection build() {
                return new Garbagecollection(this);
            }
        }
    }

    public static final class Minimum_replica_counting_mode
    extends EnumNode<Enum> {
        public static final Enum TRUSTED = Enum.TRUSTED;
        public static final Enum ANY = Enum.ANY;

        public Minimum_replica_counting_mode() {
            this.value = null;
        }

        public Minimum_replica_counting_mode(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            TRUSTED,
            ANY;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

