/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content.core;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.Node;
import java.util.HashSet;
import java.util.Set;

public final class StorBucketInitConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "3de1a33d466367525bc76392338593e2";
    public static final String CONFIG_DEF_NAME = "stor-bucket-init";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content.core", "max_alien_files_logged int default=10 restart", "max_pending_info_reads_per_disk int default=20 restart", "min_pending_info_reads_per_disk int default=4 restart", "info_read_priority int default=185 restart", "list_priority int default=100 restart", "complete_list_before_starting_read bool default=false restart"};
    private final IntegerNode max_alien_files_logged;
    private final IntegerNode max_pending_info_reads_per_disk;
    private final IntegerNode min_pending_info_reads_per_disk;
    private final IntegerNode info_read_priority;
    private final IntegerNode list_priority;
    private final BooleanNode complete_list_before_starting_read;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public StorBucketInitConfig(Builder builder) {
        this(builder, true);
    }

    private StorBucketInitConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for stor-bucket-init must be initialized: " + builder.__uninitialized);
        }
        this.max_alien_files_logged = builder.max_alien_files_logged == null ? new IntegerNode(10) : new IntegerNode(builder.max_alien_files_logged.intValue());
        this.max_pending_info_reads_per_disk = builder.max_pending_info_reads_per_disk == null ? new IntegerNode(20) : new IntegerNode(builder.max_pending_info_reads_per_disk.intValue());
        this.min_pending_info_reads_per_disk = builder.min_pending_info_reads_per_disk == null ? new IntegerNode(4) : new IntegerNode(builder.min_pending_info_reads_per_disk.intValue());
        this.info_read_priority = builder.info_read_priority == null ? new IntegerNode(185) : new IntegerNode(builder.info_read_priority.intValue());
        this.list_priority = builder.list_priority == null ? new IntegerNode(100) : new IntegerNode(builder.list_priority.intValue());
        this.complete_list_before_starting_read = builder.complete_list_before_starting_read == null ? new BooleanNode(false) : new BooleanNode(builder.complete_list_before_starting_read.booleanValue());
    }

    public int max_alien_files_logged() {
        return this.max_alien_files_logged.value();
    }

    public int max_pending_info_reads_per_disk() {
        return this.max_pending_info_reads_per_disk.value();
    }

    public int min_pending_info_reads_per_disk() {
        return this.min_pending_info_reads_per_disk.value();
    }

    public int info_read_priority() {
        return this.info_read_priority.value();
    }

    public int list_priority() {
        return this.list_priority.value();
    }

    public boolean complete_list_before_starting_read() {
        return this.complete_list_before_starting_read.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(StorBucketInitConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.max_alien_files_logged, (Node)newConfig.max_alien_files_logged, "max_alien_files_logged", "The maximum number of alien files found during init that should be stored in\nmemory so they can be viewed on status page.");
        changes.compare((Node)this.max_pending_info_reads_per_disk, (Node)newConfig.max_pending_info_reads_per_disk, "max_pending_info_reads_per_disk", "The maximum number of pending info reads to each disk during initialization.");
        changes.compare((Node)this.min_pending_info_reads_per_disk, (Node)newConfig.min_pending_info_reads_per_disk, "min_pending_info_reads_per_disk", "The minimum number of pending info reads to each disk during initialization.\nWhen pending falls below this, we will resume database scan to add more\npending up to the maximum setting.");
        changes.compare((Node)this.info_read_priority, (Node)newConfig.info_read_priority, "info_read_priority", "The priority of the read bucket info requests the initializer sends to the\npersistence layer. Currently chosen so that such operations will not pre-\nempt any regular external load or ideal state operations, but they will block\nvery low priority background operations such as periodic GC (default pri of\n200). A tradeoff must be made between fast initialization and the availability\nof data on the initializing node.");
        changes.compare((Node)this.list_priority, (Node)newConfig.list_priority, "list_priority", "The priority of the list bucket requests the initializer sends to the\npersistence layer. Should always be lower than the read priority to ensure\nstarting to read wont make listing wait. However, listing is currently pretty\nmuch required to be done before starting anyhow, so this option does little\nunless your directories are not hardware independent.");
        changes.compare((Node)this.complete_list_before_starting_read, (Node)newConfig.complete_list_before_starting_read, "complete_list_before_starting_read", "Whether the initializer should complete listing before starting to read\nbucket information. Shouldnt matter much performance wise so always set to\ntrue as it is now. Setting it false, disks done listing first will start\nto process info requests a bit earlier than otherwise.");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer max_alien_files_logged = null;
        private Integer max_pending_info_reads_per_disk = null;
        private Integer min_pending_info_reads_per_disk = null;
        private Integer info_read_priority = null;
        private Integer list_priority = null;
        private Boolean complete_list_before_starting_read = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(StorBucketInitConfig config) {
            this.max_alien_files_logged(config.max_alien_files_logged());
            this.max_pending_info_reads_per_disk(config.max_pending_info_reads_per_disk());
            this.min_pending_info_reads_per_disk(config.min_pending_info_reads_per_disk());
            this.info_read_priority(config.info_read_priority());
            this.list_priority(config.list_priority());
            this.complete_list_before_starting_read(config.complete_list_before_starting_read());
        }

        private Builder override(Builder __superior) {
            if (__superior.max_alien_files_logged != null) {
                this.max_alien_files_logged(__superior.max_alien_files_logged);
            }
            if (__superior.max_pending_info_reads_per_disk != null) {
                this.max_pending_info_reads_per_disk(__superior.max_pending_info_reads_per_disk);
            }
            if (__superior.min_pending_info_reads_per_disk != null) {
                this.min_pending_info_reads_per_disk(__superior.min_pending_info_reads_per_disk);
            }
            if (__superior.info_read_priority != null) {
                this.info_read_priority(__superior.info_read_priority);
            }
            if (__superior.list_priority != null) {
                this.list_priority(__superior.list_priority);
            }
            if (__superior.complete_list_before_starting_read != null) {
                this.complete_list_before_starting_read(__superior.complete_list_before_starting_read);
            }
            return this;
        }

        public Builder max_alien_files_logged(int __value) {
            this.max_alien_files_logged = __value;
            return this;
        }

        private Builder max_alien_files_logged(String __value) {
            return this.max_alien_files_logged(Integer.valueOf(__value));
        }

        public Builder max_pending_info_reads_per_disk(int __value) {
            this.max_pending_info_reads_per_disk = __value;
            return this;
        }

        private Builder max_pending_info_reads_per_disk(String __value) {
            return this.max_pending_info_reads_per_disk(Integer.valueOf(__value));
        }

        public Builder min_pending_info_reads_per_disk(int __value) {
            this.min_pending_info_reads_per_disk = __value;
            return this;
        }

        private Builder min_pending_info_reads_per_disk(String __value) {
            return this.min_pending_info_reads_per_disk(Integer.valueOf(__value));
        }

        public Builder info_read_priority(int __value) {
            this.info_read_priority = __value;
            return this;
        }

        private Builder info_read_priority(String __value) {
            return this.info_read_priority(Integer.valueOf(__value));
        }

        public Builder list_priority(int __value) {
            this.list_priority = __value;
            return this;
        }

        private Builder list_priority(String __value) {
            return this.list_priority(Integer.valueOf(__value));
        }

        public Builder complete_list_before_starting_read(boolean __value) {
            this.complete_list_before_starting_read = __value;
            return this;
        }

        private Builder complete_list_before_starting_read(String __value) {
            return this.complete_list_before_starting_read(Boolean.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return StorBucketInitConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return StorBucketInitConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return StorBucketInitConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public StorBucketInitConfig build() {
            return new StorBucketInitConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

