/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content.core;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.Node;
import java.util.HashSet;
import java.util.Set;

public final class StorCommunicationmanagerConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "85e60bee5eaf802cc1da46597c163312";
    public static final String CONFIG_DEF_NAME = "stor-communicationmanager";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content.core", "mbusport int default=-1 restart", "rpcport int default=6000 restart", "mbus_distributor_node_max_pending_count int default=5000", "mbus_content_node_max_pending_count int default=0", "mbus_distributor_node_max_pending_size int default=0", "mbus_content_node_max_pending_size int default=0", "mbus.compress.limit int default=1024", "mbus.compress.level int default=3", "mbus.compress.type enum {NONE, LZ4, ZSTD} default=LZ4", "mbus.rpctargetcache.ttl double default = 600", "mbus.num_threads int default=4", "mbus.optimize_for enum {LATENCY, THROUGHPUT, ADAPTIVE} default = LATENCY", "mbus.dispatch_on_encode bool default=true", "mbus.dispatch_on_decode bool default=false", "mbus.skip_reply_thread bool default=false", "mbus.skip_request_thread bool default=false", "skip_thread bool default=false", "use_direct_storageapi_rpc bool default=false", "rpc.num_network_threads int default=1", "rpc.num_targets_per_node int default=1", "rpc.compress.limit int default=1024", "rpc.compress.level int default=3", "rpc.compress.type enum {NONE, LZ4, ZSTD} default=LZ4"};
    private final IntegerNode mbusport;
    private final IntegerNode rpcport;
    private final IntegerNode mbus_distributor_node_max_pending_count;
    private final IntegerNode mbus_content_node_max_pending_count;
    private final IntegerNode mbus_distributor_node_max_pending_size;
    private final IntegerNode mbus_content_node_max_pending_size;
    private final Mbus mbus;
    private final BooleanNode skip_thread;
    private final BooleanNode use_direct_storageapi_rpc;
    private final Rpc rpc;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public StorCommunicationmanagerConfig(Builder builder) {
        this(builder, true);
    }

    private StorCommunicationmanagerConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for stor-communicationmanager must be initialized: " + builder.__uninitialized);
        }
        this.mbusport = builder.mbusport == null ? new IntegerNode(-1) : new IntegerNode(builder.mbusport.intValue());
        this.rpcport = builder.rpcport == null ? new IntegerNode(6000) : new IntegerNode(builder.rpcport.intValue());
        this.mbus_distributor_node_max_pending_count = builder.mbus_distributor_node_max_pending_count == null ? new IntegerNode(5000) : new IntegerNode(builder.mbus_distributor_node_max_pending_count.intValue());
        this.mbus_content_node_max_pending_count = builder.mbus_content_node_max_pending_count == null ? new IntegerNode(0) : new IntegerNode(builder.mbus_content_node_max_pending_count.intValue());
        this.mbus_distributor_node_max_pending_size = builder.mbus_distributor_node_max_pending_size == null ? new IntegerNode(0) : new IntegerNode(builder.mbus_distributor_node_max_pending_size.intValue());
        this.mbus_content_node_max_pending_size = builder.mbus_content_node_max_pending_size == null ? new IntegerNode(0) : new IntegerNode(builder.mbus_content_node_max_pending_size.intValue());
        this.mbus = new Mbus(builder.mbus, throwIfUninitialized);
        this.skip_thread = builder.skip_thread == null ? new BooleanNode(false) : new BooleanNode(builder.skip_thread.booleanValue());
        this.use_direct_storageapi_rpc = builder.use_direct_storageapi_rpc == null ? new BooleanNode(false) : new BooleanNode(builder.use_direct_storageapi_rpc.booleanValue());
        this.rpc = new Rpc(builder.rpc, throwIfUninitialized);
    }

    public int mbusport() {
        return this.mbusport.value();
    }

    public int rpcport() {
        return this.rpcport.value();
    }

    public int mbus_distributor_node_max_pending_count() {
        return this.mbus_distributor_node_max_pending_count.value();
    }

    public int mbus_content_node_max_pending_count() {
        return this.mbus_content_node_max_pending_count.value();
    }

    public int mbus_distributor_node_max_pending_size() {
        return this.mbus_distributor_node_max_pending_size.value();
    }

    public int mbus_content_node_max_pending_size() {
        return this.mbus_content_node_max_pending_size.value();
    }

    public Mbus mbus() {
        return this.mbus;
    }

    public boolean skip_thread() {
        return this.skip_thread.value();
    }

    public boolean use_direct_storageapi_rpc() {
        return this.use_direct_storageapi_rpc.value();
    }

    public Rpc rpc() {
        return this.rpc;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(StorCommunicationmanagerConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.mbusport, (Node)newConfig.mbusport, "mbusport", CONFIG_DEF_VERSION);
        changes.compare((Node)this.rpcport, (Node)newConfig.rpcport, "rpcport", CONFIG_DEF_VERSION);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Rpc
    extends InnerNode {
        private final IntegerNode num_network_threads;
        private final IntegerNode num_targets_per_node;
        private final Compress compress;

        public Rpc(Builder builder) {
            this(builder, true);
        }

        private Rpc(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for stor-communicationmanager.rpc must be initialized: " + builder.__uninitialized);
            }
            this.num_network_threads = builder.num_network_threads == null ? new IntegerNode(1) : new IntegerNode(builder.num_network_threads.intValue());
            this.num_targets_per_node = builder.num_targets_per_node == null ? new IntegerNode(1) : new IntegerNode(builder.num_targets_per_node.intValue());
            this.compress = new Compress(builder.compress, throwIfUninitialized);
        }

        public int num_network_threads() {
            return this.num_network_threads.value();
        }

        public int num_targets_per_node() {
            return this.num_targets_per_node.value();
        }

        public Compress compress() {
            return this.compress;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Rpc newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("rpc");
            return changes;
        }

        public static final class Compress
        extends InnerNode {
            private final IntegerNode limit;
            private final IntegerNode level;
            private final Type type;

            public Compress(Builder builder) {
                this(builder, true);
            }

            private Compress(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for stor-communicationmanager.rpc.compress must be initialized: " + builder.__uninitialized);
                }
                this.limit = builder.limit == null ? new IntegerNode(1024) : new IntegerNode(builder.limit.intValue());
                this.level = builder.level == null ? new IntegerNode(3) : new IntegerNode(builder.level.intValue());
                this.type = builder.type == null ? new Type(Type.LZ4) : new Type(builder.type);
            }

            public int limit() {
                return this.limit.value();
            }

            public int level() {
                return this.level.value();
            }

            public Type.Enum type() {
                return (Type.Enum)((Object)this.type.value());
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Compress newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("compress");
                return changes;
            }

            public static final class Type
            extends EnumNode<Enum> {
                public static final Enum NONE = Enum.NONE;
                public static final Enum LZ4 = Enum.LZ4;
                public static final Enum ZSTD = Enum.ZSTD;

                public Type() {
                    this.value = null;
                }

                public Type(Enum enumValue) {
                    super(enumValue != null);
                    this.value = enumValue;
                }

                protected boolean doSetValue(String name) {
                    try {
                        this.value = Enum.valueOf(name);
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }

                public static enum Enum {
                    NONE,
                    LZ4,
                    ZSTD;

                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Integer limit = null;
                private Integer level = null;
                private Type.Enum type = null;

                public Builder() {
                }

                public Builder(Compress config) {
                    this.limit(config.limit());
                    this.level(config.level());
                    this.type(config.type());
                }

                private Builder override(Builder __superior) {
                    if (__superior.limit != null) {
                        this.limit(__superior.limit);
                    }
                    if (__superior.level != null) {
                        this.level(__superior.level);
                    }
                    if (__superior.type != null) {
                        this.type(__superior.type);
                    }
                    return this;
                }

                public Builder limit(int __value) {
                    this.limit = __value;
                    return this;
                }

                private Builder limit(String __value) {
                    return this.limit(Integer.valueOf(__value));
                }

                public Builder level(int __value) {
                    this.level = __value;
                    return this;
                }

                private Builder level(String __value) {
                    return this.level(Integer.valueOf(__value));
                }

                public Builder type(Type.Enum __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.type = __value;
                    return this;
                }

                private Builder type(String __value) {
                    return this.type(Type.Enum.valueOf(__value));
                }

                public Compress build() {
                    return new Compress(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Integer num_network_threads = null;
            private Integer num_targets_per_node = null;
            public Compress.Builder compress = new Compress.Builder();

            public Builder() {
            }

            public Builder(Rpc config) {
                this.num_network_threads(config.num_network_threads());
                this.num_targets_per_node(config.num_targets_per_node());
                this.compress(new Compress.Builder(config.compress()));
            }

            private Builder override(Builder __superior) {
                if (__superior.num_network_threads != null) {
                    this.num_network_threads(__superior.num_network_threads);
                }
                if (__superior.num_targets_per_node != null) {
                    this.num_targets_per_node(__superior.num_targets_per_node);
                }
                this.compress(this.compress.override(__superior.compress));
                return this;
            }

            public Builder num_network_threads(int __value) {
                this.num_network_threads = __value;
                return this;
            }

            private Builder num_network_threads(String __value) {
                return this.num_network_threads(Integer.valueOf(__value));
            }

            public Builder num_targets_per_node(int __value) {
                this.num_targets_per_node = __value;
                return this;
            }

            private Builder num_targets_per_node(String __value) {
                return this.num_targets_per_node(Integer.valueOf(__value));
            }

            public Builder compress(Compress.Builder __builder) {
                this.compress = __builder;
                return this;
            }

            public Rpc build() {
                return new Rpc(this);
            }
        }
    }

    public static final class Mbus
    extends InnerNode {
        private final Compress compress;
        private final Rpctargetcache rpctargetcache;
        private final IntegerNode num_threads;
        private final Optimize_for optimize_for;
        private final BooleanNode dispatch_on_encode;
        private final BooleanNode dispatch_on_decode;
        private final BooleanNode skip_reply_thread;
        private final BooleanNode skip_request_thread;

        public Mbus(Builder builder) {
            this(builder, true);
        }

        private Mbus(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for stor-communicationmanager.mbus must be initialized: " + builder.__uninitialized);
            }
            this.compress = new Compress(builder.compress, throwIfUninitialized);
            this.rpctargetcache = new Rpctargetcache(builder.rpctargetcache, throwIfUninitialized);
            this.num_threads = builder.num_threads == null ? new IntegerNode(4) : new IntegerNode(builder.num_threads.intValue());
            this.optimize_for = builder.optimize_for == null ? new Optimize_for(Optimize_for.LATENCY) : new Optimize_for(builder.optimize_for);
            this.dispatch_on_encode = builder.dispatch_on_encode == null ? new BooleanNode(true) : new BooleanNode(builder.dispatch_on_encode.booleanValue());
            this.dispatch_on_decode = builder.dispatch_on_decode == null ? new BooleanNode(false) : new BooleanNode(builder.dispatch_on_decode.booleanValue());
            this.skip_reply_thread = builder.skip_reply_thread == null ? new BooleanNode(false) : new BooleanNode(builder.skip_reply_thread.booleanValue());
            this.skip_request_thread = builder.skip_request_thread == null ? new BooleanNode(false) : new BooleanNode(builder.skip_request_thread.booleanValue());
        }

        public Compress compress() {
            return this.compress;
        }

        public Rpctargetcache rpctargetcache() {
            return this.rpctargetcache;
        }

        public int num_threads() {
            return this.num_threads.value();
        }

        public Optimize_for.Enum optimize_for() {
            return (Optimize_for.Enum)((Object)this.optimize_for.value());
        }

        public boolean dispatch_on_encode() {
            return this.dispatch_on_encode.value();
        }

        public boolean dispatch_on_decode() {
            return this.dispatch_on_decode.value();
        }

        public boolean skip_reply_thread() {
            return this.skip_reply_thread.value();
        }

        public boolean skip_request_thread() {
            return this.skip_request_thread.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Mbus newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("mbus");
            return changes;
        }

        public static final class Optimize_for
        extends EnumNode<Enum> {
            public static final Enum LATENCY = Enum.LATENCY;
            public static final Enum THROUGHPUT = Enum.THROUGHPUT;
            public static final Enum ADAPTIVE = Enum.ADAPTIVE;

            public Optimize_for() {
                this.value = null;
            }

            public Optimize_for(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                LATENCY,
                THROUGHPUT,
                ADAPTIVE;

            }
        }

        public static final class Rpctargetcache
        extends InnerNode {
            private final DoubleNode ttl;

            public Rpctargetcache(Builder builder) {
                this(builder, true);
            }

            private Rpctargetcache(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for stor-communicationmanager.mbus.rpctargetcache must be initialized: " + builder.__uninitialized);
                }
                this.ttl = builder.ttl == null ? new DoubleNode(600.0) : new DoubleNode(builder.ttl.doubleValue());
            }

            public double ttl() {
                return this.ttl.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Rpctargetcache newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("rpctargetcache");
                return changes;
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Double ttl = null;

                public Builder() {
                }

                public Builder(Rpctargetcache config) {
                    this.ttl(config.ttl());
                }

                private Builder override(Builder __superior) {
                    if (__superior.ttl != null) {
                        this.ttl(__superior.ttl);
                    }
                    return this;
                }

                public Builder ttl(double __value) {
                    this.ttl = __value;
                    return this;
                }

                private Builder ttl(String __value) {
                    return this.ttl(Double.valueOf(__value));
                }

                public Rpctargetcache build() {
                    return new Rpctargetcache(this);
                }
            }
        }

        public static final class Compress
        extends InnerNode {
            private final IntegerNode limit;
            private final IntegerNode level;
            private final Type type;

            public Compress(Builder builder) {
                this(builder, true);
            }

            private Compress(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for stor-communicationmanager.mbus.compress must be initialized: " + builder.__uninitialized);
                }
                this.limit = builder.limit == null ? new IntegerNode(1024) : new IntegerNode(builder.limit.intValue());
                this.level = builder.level == null ? new IntegerNode(3) : new IntegerNode(builder.level.intValue());
                this.type = builder.type == null ? new Type(Type.LZ4) : new Type(builder.type);
            }

            public int limit() {
                return this.limit.value();
            }

            public int level() {
                return this.level.value();
            }

            public Type.Enum type() {
                return (Type.Enum)((Object)this.type.value());
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Compress newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("compress");
                return changes;
            }

            public static final class Type
            extends EnumNode<Enum> {
                public static final Enum NONE = Enum.NONE;
                public static final Enum LZ4 = Enum.LZ4;
                public static final Enum ZSTD = Enum.ZSTD;

                public Type() {
                    this.value = null;
                }

                public Type(Enum enumValue) {
                    super(enumValue != null);
                    this.value = enumValue;
                }

                protected boolean doSetValue(String name) {
                    try {
                        this.value = Enum.valueOf(name);
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }

                public static enum Enum {
                    NONE,
                    LZ4,
                    ZSTD;

                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Integer limit = null;
                private Integer level = null;
                private Type.Enum type = null;

                public Builder() {
                }

                public Builder(Compress config) {
                    this.limit(config.limit());
                    this.level(config.level());
                    this.type(config.type());
                }

                private Builder override(Builder __superior) {
                    if (__superior.limit != null) {
                        this.limit(__superior.limit);
                    }
                    if (__superior.level != null) {
                        this.level(__superior.level);
                    }
                    if (__superior.type != null) {
                        this.type(__superior.type);
                    }
                    return this;
                }

                public Builder limit(int __value) {
                    this.limit = __value;
                    return this;
                }

                private Builder limit(String __value) {
                    return this.limit(Integer.valueOf(__value));
                }

                public Builder level(int __value) {
                    this.level = __value;
                    return this;
                }

                private Builder level(String __value) {
                    return this.level(Integer.valueOf(__value));
                }

                public Builder type(Type.Enum __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.type = __value;
                    return this;
                }

                private Builder type(String __value) {
                    return this.type(Type.Enum.valueOf(__value));
                }

                public Compress build() {
                    return new Compress(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public Compress.Builder compress = new Compress.Builder();
            public Rpctargetcache.Builder rpctargetcache = new Rpctargetcache.Builder();
            private Integer num_threads = null;
            private Optimize_for.Enum optimize_for = null;
            private Boolean dispatch_on_encode = null;
            private Boolean dispatch_on_decode = null;
            private Boolean skip_reply_thread = null;
            private Boolean skip_request_thread = null;

            public Builder() {
            }

            public Builder(Mbus config) {
                this.compress(new Compress.Builder(config.compress()));
                this.rpctargetcache(new Rpctargetcache.Builder(config.rpctargetcache()));
                this.num_threads(config.num_threads());
                this.optimize_for(config.optimize_for());
                this.dispatch_on_encode(config.dispatch_on_encode());
                this.dispatch_on_decode(config.dispatch_on_decode());
                this.skip_reply_thread(config.skip_reply_thread());
                this.skip_request_thread(config.skip_request_thread());
            }

            private Builder override(Builder __superior) {
                this.compress(this.compress.override(__superior.compress));
                this.rpctargetcache(this.rpctargetcache.override(__superior.rpctargetcache));
                if (__superior.num_threads != null) {
                    this.num_threads(__superior.num_threads);
                }
                if (__superior.optimize_for != null) {
                    this.optimize_for(__superior.optimize_for);
                }
                if (__superior.dispatch_on_encode != null) {
                    this.dispatch_on_encode(__superior.dispatch_on_encode);
                }
                if (__superior.dispatch_on_decode != null) {
                    this.dispatch_on_decode(__superior.dispatch_on_decode);
                }
                if (__superior.skip_reply_thread != null) {
                    this.skip_reply_thread(__superior.skip_reply_thread);
                }
                if (__superior.skip_request_thread != null) {
                    this.skip_request_thread(__superior.skip_request_thread);
                }
                return this;
            }

            public Builder compress(Compress.Builder __builder) {
                this.compress = __builder;
                return this;
            }

            public Builder rpctargetcache(Rpctargetcache.Builder __builder) {
                this.rpctargetcache = __builder;
                return this;
            }

            public Builder num_threads(int __value) {
                this.num_threads = __value;
                return this;
            }

            private Builder num_threads(String __value) {
                return this.num_threads(Integer.valueOf(__value));
            }

            public Builder optimize_for(Optimize_for.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.optimize_for = __value;
                return this;
            }

            private Builder optimize_for(String __value) {
                return this.optimize_for(Optimize_for.Enum.valueOf(__value));
            }

            public Builder dispatch_on_encode(boolean __value) {
                this.dispatch_on_encode = __value;
                return this;
            }

            private Builder dispatch_on_encode(String __value) {
                return this.dispatch_on_encode(Boolean.valueOf(__value));
            }

            public Builder dispatch_on_decode(boolean __value) {
                this.dispatch_on_decode = __value;
                return this;
            }

            private Builder dispatch_on_decode(String __value) {
                return this.dispatch_on_decode(Boolean.valueOf(__value));
            }

            public Builder skip_reply_thread(boolean __value) {
                this.skip_reply_thread = __value;
                return this;
            }

            private Builder skip_reply_thread(String __value) {
                return this.skip_reply_thread(Boolean.valueOf(__value));
            }

            public Builder skip_request_thread(boolean __value) {
                this.skip_request_thread = __value;
                return this;
            }

            private Builder skip_request_thread(String __value) {
                return this.skip_request_thread(Boolean.valueOf(__value));
            }

            public Mbus build() {
                return new Mbus(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer mbusport = null;
        private Integer rpcport = null;
        private Integer mbus_distributor_node_max_pending_count = null;
        private Integer mbus_content_node_max_pending_count = null;
        private Integer mbus_distributor_node_max_pending_size = null;
        private Integer mbus_content_node_max_pending_size = null;
        public Mbus.Builder mbus = new Mbus.Builder();
        private Boolean skip_thread = null;
        private Boolean use_direct_storageapi_rpc = null;
        public Rpc.Builder rpc = new Rpc.Builder();

        public Builder() {
        }

        public Builder(StorCommunicationmanagerConfig config) {
            this.mbusport(config.mbusport());
            this.rpcport(config.rpcport());
            this.mbus_distributor_node_max_pending_count(config.mbus_distributor_node_max_pending_count());
            this.mbus_content_node_max_pending_count(config.mbus_content_node_max_pending_count());
            this.mbus_distributor_node_max_pending_size(config.mbus_distributor_node_max_pending_size());
            this.mbus_content_node_max_pending_size(config.mbus_content_node_max_pending_size());
            this.mbus(new Mbus.Builder(config.mbus()));
            this.skip_thread(config.skip_thread());
            this.use_direct_storageapi_rpc(config.use_direct_storageapi_rpc());
            this.rpc(new Rpc.Builder(config.rpc()));
        }

        private Builder override(Builder __superior) {
            if (__superior.mbusport != null) {
                this.mbusport(__superior.mbusport);
            }
            if (__superior.rpcport != null) {
                this.rpcport(__superior.rpcport);
            }
            if (__superior.mbus_distributor_node_max_pending_count != null) {
                this.mbus_distributor_node_max_pending_count(__superior.mbus_distributor_node_max_pending_count);
            }
            if (__superior.mbus_content_node_max_pending_count != null) {
                this.mbus_content_node_max_pending_count(__superior.mbus_content_node_max_pending_count);
            }
            if (__superior.mbus_distributor_node_max_pending_size != null) {
                this.mbus_distributor_node_max_pending_size(__superior.mbus_distributor_node_max_pending_size);
            }
            if (__superior.mbus_content_node_max_pending_size != null) {
                this.mbus_content_node_max_pending_size(__superior.mbus_content_node_max_pending_size);
            }
            this.mbus(this.mbus.override(__superior.mbus));
            if (__superior.skip_thread != null) {
                this.skip_thread(__superior.skip_thread);
            }
            if (__superior.use_direct_storageapi_rpc != null) {
                this.use_direct_storageapi_rpc(__superior.use_direct_storageapi_rpc);
            }
            this.rpc(this.rpc.override(__superior.rpc));
            return this;
        }

        public Builder mbusport(int __value) {
            this.mbusport = __value;
            return this;
        }

        private Builder mbusport(String __value) {
            return this.mbusport(Integer.valueOf(__value));
        }

        public Builder rpcport(int __value) {
            this.rpcport = __value;
            return this;
        }

        private Builder rpcport(String __value) {
            return this.rpcport(Integer.valueOf(__value));
        }

        public Builder mbus_distributor_node_max_pending_count(int __value) {
            this.mbus_distributor_node_max_pending_count = __value;
            return this;
        }

        private Builder mbus_distributor_node_max_pending_count(String __value) {
            return this.mbus_distributor_node_max_pending_count(Integer.valueOf(__value));
        }

        public Builder mbus_content_node_max_pending_count(int __value) {
            this.mbus_content_node_max_pending_count = __value;
            return this;
        }

        private Builder mbus_content_node_max_pending_count(String __value) {
            return this.mbus_content_node_max_pending_count(Integer.valueOf(__value));
        }

        public Builder mbus_distributor_node_max_pending_size(int __value) {
            this.mbus_distributor_node_max_pending_size = __value;
            return this;
        }

        private Builder mbus_distributor_node_max_pending_size(String __value) {
            return this.mbus_distributor_node_max_pending_size(Integer.valueOf(__value));
        }

        public Builder mbus_content_node_max_pending_size(int __value) {
            this.mbus_content_node_max_pending_size = __value;
            return this;
        }

        private Builder mbus_content_node_max_pending_size(String __value) {
            return this.mbus_content_node_max_pending_size(Integer.valueOf(__value));
        }

        public Builder mbus(Mbus.Builder __builder) {
            this.mbus = __builder;
            return this;
        }

        public Builder skip_thread(boolean __value) {
            this.skip_thread = __value;
            return this;
        }

        private Builder skip_thread(String __value) {
            return this.skip_thread(Boolean.valueOf(__value));
        }

        public Builder use_direct_storageapi_rpc(boolean __value) {
            this.use_direct_storageapi_rpc = __value;
            return this;
        }

        private Builder use_direct_storageapi_rpc(String __value) {
            return this.use_direct_storageapi_rpc(Boolean.valueOf(__value));
        }

        public Builder rpc(Rpc.Builder __builder) {
            this.rpc = __builder;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return StorCommunicationmanagerConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return StorCommunicationmanagerConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return StorCommunicationmanagerConfig.CONFIG_DEF_NAMESPACE;
        }

        public StorCommunicationmanagerConfig build() {
            return new StorCommunicationmanagerConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

