/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content.core;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.Node;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class StorServerConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "74a130680a029543bc3e16d73022194c";
    public static final String CONFIG_DEF_NAME = "stor-server";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content.core", "root_folder string restart", "cluster_name string default=\"storage\" restart", "node_index int default=0 restart", "is_distributor bool restart", "node_capacity double default=1.0 restart", "disk_capacity[] double restart", "node_reliability int default=1 restart", "max_merges_per_node int default=16", "max_merge_queue_size int default=1024", "resource_exhaustion_merge_back_pressure_duration_secs double default=30.0", "enable_dead_lock_detector bool default=false restart", "enable_dead_lock_detector_warnings bool default=true restart", "dead_lock_detector_timeout_slack double default=240 restart", "disk_count int default=0 restart", "persistence_provider.type enum {STORAGE, DUMMY, RPC } default=STORAGE restart", "persistence_provider.rpc.connectspec string default=\"tcp/localhost:27777\" restart", "switch_new_meta_data_flow bool default=false restart", "bucket_rechecking_chunk_size int default=100", "simulated_bucket_request_latency_msec int default=0"};
    private final StringNode root_folder;
    private final StringNode cluster_name;
    private final IntegerNode node_index;
    private final BooleanNode is_distributor;
    private final DoubleNode node_capacity;
    private final LeafNodeVector<Double, DoubleNode> disk_capacity;
    private final IntegerNode node_reliability;
    private final IntegerNode max_merges_per_node;
    private final IntegerNode max_merge_queue_size;
    private final DoubleNode resource_exhaustion_merge_back_pressure_duration_secs;
    private final BooleanNode enable_dead_lock_detector;
    private final BooleanNode enable_dead_lock_detector_warnings;
    private final DoubleNode dead_lock_detector_timeout_slack;
    private final IntegerNode disk_count;
    private final Persistence_provider persistence_provider;
    private final BooleanNode switch_new_meta_data_flow;
    private final IntegerNode bucket_rechecking_chunk_size;
    private final IntegerNode simulated_bucket_request_latency_msec;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public StorServerConfig(Builder builder) {
        this(builder, true);
    }

    private StorServerConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for stor-server must be initialized: " + builder.__uninitialized);
        }
        this.root_folder = builder.root_folder == null ? new StringNode() : new StringNode(builder.root_folder);
        this.cluster_name = builder.cluster_name == null ? new StringNode("storage") : new StringNode(builder.cluster_name);
        this.node_index = builder.node_index == null ? new IntegerNode(0) : new IntegerNode(builder.node_index.intValue());
        this.is_distributor = builder.is_distributor == null ? new BooleanNode() : new BooleanNode(builder.is_distributor.booleanValue());
        this.node_capacity = builder.node_capacity == null ? new DoubleNode(1.0) : new DoubleNode(builder.node_capacity.doubleValue());
        this.disk_capacity = new LeafNodeVector(builder.disk_capacity, (LeafNode)new DoubleNode());
        this.node_reliability = builder.node_reliability == null ? new IntegerNode(1) : new IntegerNode(builder.node_reliability.intValue());
        this.max_merges_per_node = builder.max_merges_per_node == null ? new IntegerNode(16) : new IntegerNode(builder.max_merges_per_node.intValue());
        this.max_merge_queue_size = builder.max_merge_queue_size == null ? new IntegerNode(1024) : new IntegerNode(builder.max_merge_queue_size.intValue());
        this.resource_exhaustion_merge_back_pressure_duration_secs = builder.resource_exhaustion_merge_back_pressure_duration_secs == null ? new DoubleNode(30.0) : new DoubleNode(builder.resource_exhaustion_merge_back_pressure_duration_secs.doubleValue());
        this.enable_dead_lock_detector = builder.enable_dead_lock_detector == null ? new BooleanNode(false) : new BooleanNode(builder.enable_dead_lock_detector.booleanValue());
        this.enable_dead_lock_detector_warnings = builder.enable_dead_lock_detector_warnings == null ? new BooleanNode(true) : new BooleanNode(builder.enable_dead_lock_detector_warnings.booleanValue());
        this.dead_lock_detector_timeout_slack = builder.dead_lock_detector_timeout_slack == null ? new DoubleNode(240.0) : new DoubleNode(builder.dead_lock_detector_timeout_slack.doubleValue());
        this.disk_count = builder.disk_count == null ? new IntegerNode(0) : new IntegerNode(builder.disk_count.intValue());
        this.persistence_provider = new Persistence_provider(builder.persistence_provider, throwIfUninitialized);
        this.switch_new_meta_data_flow = builder.switch_new_meta_data_flow == null ? new BooleanNode(false) : new BooleanNode(builder.switch_new_meta_data_flow.booleanValue());
        this.bucket_rechecking_chunk_size = builder.bucket_rechecking_chunk_size == null ? new IntegerNode(100) : new IntegerNode(builder.bucket_rechecking_chunk_size.intValue());
        this.simulated_bucket_request_latency_msec = builder.simulated_bucket_request_latency_msec == null ? new IntegerNode(0) : new IntegerNode(builder.simulated_bucket_request_latency_msec.intValue());
    }

    public String root_folder() {
        return this.root_folder.value();
    }

    public String cluster_name() {
        return this.cluster_name.value();
    }

    public int node_index() {
        return this.node_index.value();
    }

    public boolean is_distributor() {
        return this.is_distributor.value();
    }

    public double node_capacity() {
        return this.node_capacity.value();
    }

    public List<Double> disk_capacity() {
        return this.disk_capacity.asList();
    }

    public double disk_capacity(int i) {
        return ((DoubleNode)this.disk_capacity.get(i)).value();
    }

    public int node_reliability() {
        return this.node_reliability.value();
    }

    public int max_merges_per_node() {
        return this.max_merges_per_node.value();
    }

    public int max_merge_queue_size() {
        return this.max_merge_queue_size.value();
    }

    public double resource_exhaustion_merge_back_pressure_duration_secs() {
        return this.resource_exhaustion_merge_back_pressure_duration_secs.value();
    }

    public boolean enable_dead_lock_detector() {
        return this.enable_dead_lock_detector.value();
    }

    public boolean enable_dead_lock_detector_warnings() {
        return this.enable_dead_lock_detector_warnings.value();
    }

    public double dead_lock_detector_timeout_slack() {
        return this.dead_lock_detector_timeout_slack.value();
    }

    public int disk_count() {
        return this.disk_count.value();
    }

    public Persistence_provider persistence_provider() {
        return this.persistence_provider;
    }

    public boolean switch_new_meta_data_flow() {
        return this.switch_new_meta_data_flow.value();
    }

    public int bucket_rechecking_chunk_size() {
        return this.bucket_rechecking_chunk_size.value();
    }

    public int simulated_bucket_request_latency_msec() {
        return this.simulated_bucket_request_latency_msec.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(StorServerConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.root_folder, (Node)newConfig.root_folder, "root_folder", "Root directory for all files related to this storage node.\nWill typically be \"$VESPA_HOME/var/db/vespa/vds/<cluster>/<nodetype>/<index>");
        changes.compare((Node)this.cluster_name, (Node)newConfig.cluster_name, "cluster_name", "VDS cluster");
        changes.compare((Node)this.node_index, (Node)newConfig.node_index, "node_index", "The index of this node. Each node of the same type in the same cluster need\nto have unique indexes. This should not be changed, as this is what we use\nto identify the node, and to decide what data should be on it.");
        changes.compare((Node)this.is_distributor, (Node)newConfig.is_distributor, "is_distributor", "Set whether this is a distributor or a storage node. This will decide what\nstorage links are set up.");
        changes.compare((Node)this.node_capacity, (Node)newConfig.node_capacity, "node_capacity", "Capacity of the node. How much data and load this node will get relative to\nother nodes.");
        changes.compareArray(this.disk_capacity, newConfig.disk_capacity, "disk_capacity", "Capacity of the disks on this node. How much data and load will each disk\nget relative to the other disks on this node.", (a, b) -> new ChangesRequiringRestart("disk_capacity").compare(a, b, CONFIG_DEF_VERSION, "Capacity of the disks on this node. How much data and load will each disk\nget relative to the other disks on this node."));
        changes.compare((Node)this.node_reliability, (Node)newConfig.node_reliability, "node_reliability", "Reliability of this node. How much of the cluster redundancy factor can this\nnode make up for.");
        changes.compare((Node)this.enable_dead_lock_detector, (Node)newConfig.enable_dead_lock_detector, "enable_dead_lock_detector", "Whether the deadlock detector should be enabled or not. If disabled, it will\nstill run, but it will never actually abort the process it is running in.");
        changes.compare((Node)this.enable_dead_lock_detector_warnings, (Node)newConfig.enable_dead_lock_detector_warnings, "enable_dead_lock_detector_warnings", "Whether to enable deadlock detector warnings in log or not. If enabled,\nwarnings will be written even if dead lock detecting is not enabled.");
        changes.compare((Node)this.dead_lock_detector_timeout_slack, (Node)newConfig.dead_lock_detector_timeout_slack, "dead_lock_detector_timeout_slack", "Each thread registers how often it will at minimum register ticks (given that\nthe system is not overloaded. If you are running Vespa on overloaded nodes,\nyou can use this slack timeout to add to the thread timeouts in order to\nallow for more slack before dead lock detector kicks in. The value is in seconds.");
        changes.compare((Node)this.disk_count, (Node)newConfig.disk_count, "disk_count", "If set to 0, storage will attempt to auto-detect the number of VDS mount\npoints to use. If set to a number, force this number. This number only makes\nsense on a storage node of course");
        changes.mergeChanges("persistence_provider", this.persistence_provider.getChangesRequiringRestart(newConfig.persistence_provider));
        changes.compare((Node)this.switch_new_meta_data_flow, (Node)newConfig.switch_new_meta_data_flow, "switch_new_meta_data_flow", "Whether or not to use the new metadata flow implementation. Default to not\nas it is currently in development and not even functional");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Persistence_provider
    extends InnerNode {
        private final Type type;
        private final Rpc rpc;

        public Persistence_provider(Builder builder) {
            this(builder, true);
        }

        private Persistence_provider(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for stor-server.persistence_provider must be initialized: " + builder.__uninitialized);
            }
            this.type = builder.type == null ? new Type(Type.STORAGE) : new Type(builder.type);
            this.rpc = new Rpc(builder.rpc, throwIfUninitialized);
        }

        public Type.Enum type() {
            return (Type.Enum)((Object)this.type.value());
        }

        public Rpc rpc() {
            return this.rpc;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Persistence_provider newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("persistence_provider");
            changes.compare((Node)this.type, (Node)newConfig.type, "type", "Configure persistence provider. Temporary here to test.");
            changes.mergeChanges("rpc", this.rpc.getChangesRequiringRestart(newConfig.rpc));
            return changes;
        }

        public static final class Rpc
        extends InnerNode {
            private final StringNode connectspec;

            public Rpc(Builder builder) {
                this(builder, true);
            }

            private Rpc(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for stor-server.persistence_provider.rpc must be initialized: " + builder.__uninitialized);
                }
                this.connectspec = builder.connectspec == null ? new StringNode("tcp/localhost:27777") : new StringNode(builder.connectspec);
            }

            public String connectspec() {
                return this.connectspec.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Rpc newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("rpc");
                changes.compare((Node)this.connectspec, (Node)newConfig.connectspec, "connectspec", StorServerConfig.CONFIG_DEF_VERSION);
                return changes;
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private String connectspec = null;

                public Builder() {
                }

                public Builder(Rpc config) {
                    this.connectspec(config.connectspec());
                }

                private Builder override(Builder __superior) {
                    if (__superior.connectspec != null) {
                        this.connectspec(__superior.connectspec);
                    }
                    return this;
                }

                public Builder connectspec(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.connectspec = __value;
                    return this;
                }

                public Rpc build() {
                    return new Rpc(this);
                }
            }
        }

        public static final class Type
        extends EnumNode<Enum> {
            public static final Enum STORAGE = Enum.STORAGE;
            public static final Enum DUMMY = Enum.DUMMY;
            public static final Enum RPC = Enum.RPC;

            public Type() {
                this.value = null;
            }

            public Type(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                STORAGE,
                DUMMY,
                RPC;

            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Type.Enum type = null;
            public Rpc.Builder rpc = new Rpc.Builder();

            public Builder() {
            }

            public Builder(Persistence_provider config) {
                this.type(config.type());
                this.rpc(new Rpc.Builder(config.rpc()));
            }

            private Builder override(Builder __superior) {
                if (__superior.type != null) {
                    this.type(__superior.type);
                }
                this.rpc(this.rpc.override(__superior.rpc));
                return this;
            }

            public Builder type(Type.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.type = __value;
                return this;
            }

            private Builder type(String __value) {
                return this.type(Type.Enum.valueOf(__value));
            }

            public Builder rpc(Rpc.Builder __builder) {
                this.rpc = __builder;
                return this;
            }

            public Persistence_provider build() {
                return new Persistence_provider(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("root_folder", "is_distributor"));
        private String root_folder = null;
        private String cluster_name = null;
        private Integer node_index = null;
        private Boolean is_distributor = null;
        private Double node_capacity = null;
        public List<Double> disk_capacity = new ArrayList<Double>();
        private Integer node_reliability = null;
        private Integer max_merges_per_node = null;
        private Integer max_merge_queue_size = null;
        private Double resource_exhaustion_merge_back_pressure_duration_secs = null;
        private Boolean enable_dead_lock_detector = null;
        private Boolean enable_dead_lock_detector_warnings = null;
        private Double dead_lock_detector_timeout_slack = null;
        private Integer disk_count = null;
        public Persistence_provider.Builder persistence_provider = new Persistence_provider.Builder();
        private Boolean switch_new_meta_data_flow = null;
        private Integer bucket_rechecking_chunk_size = null;
        private Integer simulated_bucket_request_latency_msec = null;

        public Builder() {
        }

        public Builder(StorServerConfig config) {
            this.root_folder(config.root_folder());
            this.cluster_name(config.cluster_name());
            this.node_index(config.node_index());
            this.is_distributor(config.is_distributor());
            this.node_capacity(config.node_capacity());
            this.disk_capacity(config.disk_capacity());
            this.node_reliability(config.node_reliability());
            this.max_merges_per_node(config.max_merges_per_node());
            this.max_merge_queue_size(config.max_merge_queue_size());
            this.resource_exhaustion_merge_back_pressure_duration_secs(config.resource_exhaustion_merge_back_pressure_duration_secs());
            this.enable_dead_lock_detector(config.enable_dead_lock_detector());
            this.enable_dead_lock_detector_warnings(config.enable_dead_lock_detector_warnings());
            this.dead_lock_detector_timeout_slack(config.dead_lock_detector_timeout_slack());
            this.disk_count(config.disk_count());
            this.persistence_provider(new Persistence_provider.Builder(config.persistence_provider()));
            this.switch_new_meta_data_flow(config.switch_new_meta_data_flow());
            this.bucket_rechecking_chunk_size(config.bucket_rechecking_chunk_size());
            this.simulated_bucket_request_latency_msec(config.simulated_bucket_request_latency_msec());
        }

        private Builder override(Builder __superior) {
            if (__superior.root_folder != null) {
                this.root_folder(__superior.root_folder);
            }
            if (__superior.cluster_name != null) {
                this.cluster_name(__superior.cluster_name);
            }
            if (__superior.node_index != null) {
                this.node_index(__superior.node_index);
            }
            if (__superior.is_distributor != null) {
                this.is_distributor(__superior.is_distributor);
            }
            if (__superior.node_capacity != null) {
                this.node_capacity(__superior.node_capacity);
            }
            if (!__superior.disk_capacity.isEmpty()) {
                this.disk_capacity.addAll(__superior.disk_capacity);
            }
            if (__superior.node_reliability != null) {
                this.node_reliability(__superior.node_reliability);
            }
            if (__superior.max_merges_per_node != null) {
                this.max_merges_per_node(__superior.max_merges_per_node);
            }
            if (__superior.max_merge_queue_size != null) {
                this.max_merge_queue_size(__superior.max_merge_queue_size);
            }
            if (__superior.resource_exhaustion_merge_back_pressure_duration_secs != null) {
                this.resource_exhaustion_merge_back_pressure_duration_secs(__superior.resource_exhaustion_merge_back_pressure_duration_secs);
            }
            if (__superior.enable_dead_lock_detector != null) {
                this.enable_dead_lock_detector(__superior.enable_dead_lock_detector);
            }
            if (__superior.enable_dead_lock_detector_warnings != null) {
                this.enable_dead_lock_detector_warnings(__superior.enable_dead_lock_detector_warnings);
            }
            if (__superior.dead_lock_detector_timeout_slack != null) {
                this.dead_lock_detector_timeout_slack(__superior.dead_lock_detector_timeout_slack);
            }
            if (__superior.disk_count != null) {
                this.disk_count(__superior.disk_count);
            }
            this.persistence_provider(this.persistence_provider.override(__superior.persistence_provider));
            if (__superior.switch_new_meta_data_flow != null) {
                this.switch_new_meta_data_flow(__superior.switch_new_meta_data_flow);
            }
            if (__superior.bucket_rechecking_chunk_size != null) {
                this.bucket_rechecking_chunk_size(__superior.bucket_rechecking_chunk_size);
            }
            if (__superior.simulated_bucket_request_latency_msec != null) {
                this.simulated_bucket_request_latency_msec(__superior.simulated_bucket_request_latency_msec);
            }
            return this;
        }

        public Builder root_folder(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.root_folder = __value;
            this.__uninitialized.remove("root_folder");
            return this;
        }

        public Builder cluster_name(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.cluster_name = __value;
            return this;
        }

        public Builder node_index(int __value) {
            this.node_index = __value;
            return this;
        }

        private Builder node_index(String __value) {
            return this.node_index(Integer.valueOf(__value));
        }

        public Builder is_distributor(boolean __value) {
            this.is_distributor = __value;
            this.__uninitialized.remove("is_distributor");
            return this;
        }

        private Builder is_distributor(String __value) {
            return this.is_distributor(Boolean.valueOf(__value));
        }

        public Builder node_capacity(double __value) {
            this.node_capacity = __value;
            return this;
        }

        private Builder node_capacity(String __value) {
            return this.node_capacity(Double.valueOf(__value));
        }

        public Builder disk_capacity(Double __value) {
            this.disk_capacity.add(__value);
            return this;
        }

        public Builder disk_capacity(Collection<Double> __values) {
            this.disk_capacity.addAll(__values);
            return this;
        }

        private Builder disk_capacity(String __value) {
            return this.disk_capacity(Double.valueOf(__value));
        }

        public Builder node_reliability(int __value) {
            this.node_reliability = __value;
            return this;
        }

        private Builder node_reliability(String __value) {
            return this.node_reliability(Integer.valueOf(__value));
        }

        public Builder max_merges_per_node(int __value) {
            this.max_merges_per_node = __value;
            return this;
        }

        private Builder max_merges_per_node(String __value) {
            return this.max_merges_per_node(Integer.valueOf(__value));
        }

        public Builder max_merge_queue_size(int __value) {
            this.max_merge_queue_size = __value;
            return this;
        }

        private Builder max_merge_queue_size(String __value) {
            return this.max_merge_queue_size(Integer.valueOf(__value));
        }

        public Builder resource_exhaustion_merge_back_pressure_duration_secs(double __value) {
            this.resource_exhaustion_merge_back_pressure_duration_secs = __value;
            return this;
        }

        private Builder resource_exhaustion_merge_back_pressure_duration_secs(String __value) {
            return this.resource_exhaustion_merge_back_pressure_duration_secs(Double.valueOf(__value));
        }

        public Builder enable_dead_lock_detector(boolean __value) {
            this.enable_dead_lock_detector = __value;
            return this;
        }

        private Builder enable_dead_lock_detector(String __value) {
            return this.enable_dead_lock_detector(Boolean.valueOf(__value));
        }

        public Builder enable_dead_lock_detector_warnings(boolean __value) {
            this.enable_dead_lock_detector_warnings = __value;
            return this;
        }

        private Builder enable_dead_lock_detector_warnings(String __value) {
            return this.enable_dead_lock_detector_warnings(Boolean.valueOf(__value));
        }

        public Builder dead_lock_detector_timeout_slack(double __value) {
            this.dead_lock_detector_timeout_slack = __value;
            return this;
        }

        private Builder dead_lock_detector_timeout_slack(String __value) {
            return this.dead_lock_detector_timeout_slack(Double.valueOf(__value));
        }

        public Builder disk_count(int __value) {
            this.disk_count = __value;
            return this;
        }

        private Builder disk_count(String __value) {
            return this.disk_count(Integer.valueOf(__value));
        }

        public Builder persistence_provider(Persistence_provider.Builder __builder) {
            this.persistence_provider = __builder;
            return this;
        }

        public Builder switch_new_meta_data_flow(boolean __value) {
            this.switch_new_meta_data_flow = __value;
            return this;
        }

        private Builder switch_new_meta_data_flow(String __value) {
            return this.switch_new_meta_data_flow(Boolean.valueOf(__value));
        }

        public Builder bucket_rechecking_chunk_size(int __value) {
            this.bucket_rechecking_chunk_size = __value;
            return this;
        }

        private Builder bucket_rechecking_chunk_size(String __value) {
            return this.bucket_rechecking_chunk_size(Integer.valueOf(__value));
        }

        public Builder simulated_bucket_request_latency_msec(int __value) {
            this.simulated_bucket_request_latency_msec = __value;
            return this;
        }

        private Builder simulated_bucket_request_latency_msec(String __value) {
            return this.simulated_bucket_request_latency_msec(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return StorServerConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return StorServerConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return StorServerConfig.CONFIG_DEF_NAMESPACE;
        }

        public StorServerConfig build() {
            return new StorServerConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

