/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content.core;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.Node;
import java.util.HashSet;
import java.util.Set;

public final class StorVisitorConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "56890973111067932e837a9eb7a9ae6d";
    public static final String CONFIG_DEF_NAME = "stor-visitor";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content.core", "visitorthreads int default=16 restart", "disconnectedvisitortimeout int default=0 restart", "ignorenonexistingvisitortimelimit int default=300 restart", "defaultparalleliterators int default=8", "iterators_per_bucket int default=1", "defaultpendingmessages int default=32", "defaultdocblocksize int default=4190208", "defaultdocblocktimeout int default=180000", "defaultinfotimeout int default=60000", "maxconcurrentvisitors int default=64", "maxconcurrentvisitors_fixed int default=16", "maxconcurrentvisitors_variable int default=64", "maxvisitorqueuesize int default=1024", "visitor_memory_usage_limit int default=25165824"};
    private final IntegerNode visitorthreads;
    private final IntegerNode disconnectedvisitortimeout;
    private final IntegerNode ignorenonexistingvisitortimelimit;
    private final IntegerNode defaultparalleliterators;
    private final IntegerNode iterators_per_bucket;
    private final IntegerNode defaultpendingmessages;
    private final IntegerNode defaultdocblocksize;
    private final IntegerNode defaultdocblocktimeout;
    private final IntegerNode defaultinfotimeout;
    private final IntegerNode maxconcurrentvisitors;
    private final IntegerNode maxconcurrentvisitors_fixed;
    private final IntegerNode maxconcurrentvisitors_variable;
    private final IntegerNode maxvisitorqueuesize;
    private final IntegerNode visitor_memory_usage_limit;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public StorVisitorConfig(Builder builder) {
        this(builder, true);
    }

    private StorVisitorConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for stor-visitor must be initialized: " + builder.__uninitialized);
        }
        this.visitorthreads = builder.visitorthreads == null ? new IntegerNode(16) : new IntegerNode(builder.visitorthreads.intValue());
        this.disconnectedvisitortimeout = builder.disconnectedvisitortimeout == null ? new IntegerNode(0) : new IntegerNode(builder.disconnectedvisitortimeout.intValue());
        this.ignorenonexistingvisitortimelimit = builder.ignorenonexistingvisitortimelimit == null ? new IntegerNode(300) : new IntegerNode(builder.ignorenonexistingvisitortimelimit.intValue());
        this.defaultparalleliterators = builder.defaultparalleliterators == null ? new IntegerNode(8) : new IntegerNode(builder.defaultparalleliterators.intValue());
        this.iterators_per_bucket = builder.iterators_per_bucket == null ? new IntegerNode(1) : new IntegerNode(builder.iterators_per_bucket.intValue());
        this.defaultpendingmessages = builder.defaultpendingmessages == null ? new IntegerNode(32) : new IntegerNode(builder.defaultpendingmessages.intValue());
        this.defaultdocblocksize = builder.defaultdocblocksize == null ? new IntegerNode(0x3FF000) : new IntegerNode(builder.defaultdocblocksize.intValue());
        this.defaultdocblocktimeout = builder.defaultdocblocktimeout == null ? new IntegerNode(180000) : new IntegerNode(builder.defaultdocblocktimeout.intValue());
        this.defaultinfotimeout = builder.defaultinfotimeout == null ? new IntegerNode(60000) : new IntegerNode(builder.defaultinfotimeout.intValue());
        this.maxconcurrentvisitors = builder.maxconcurrentvisitors == null ? new IntegerNode(64) : new IntegerNode(builder.maxconcurrentvisitors.intValue());
        this.maxconcurrentvisitors_fixed = builder.maxconcurrentvisitors_fixed == null ? new IntegerNode(16) : new IntegerNode(builder.maxconcurrentvisitors_fixed.intValue());
        this.maxconcurrentvisitors_variable = builder.maxconcurrentvisitors_variable == null ? new IntegerNode(64) : new IntegerNode(builder.maxconcurrentvisitors_variable.intValue());
        this.maxvisitorqueuesize = builder.maxvisitorqueuesize == null ? new IntegerNode(1024) : new IntegerNode(builder.maxvisitorqueuesize.intValue());
        this.visitor_memory_usage_limit = builder.visitor_memory_usage_limit == null ? new IntegerNode(0x1800000) : new IntegerNode(builder.visitor_memory_usage_limit.intValue());
    }

    public int visitorthreads() {
        return this.visitorthreads.value();
    }

    public int disconnectedvisitortimeout() {
        return this.disconnectedvisitortimeout.value();
    }

    public int ignorenonexistingvisitortimelimit() {
        return this.ignorenonexistingvisitortimelimit.value();
    }

    public int defaultparalleliterators() {
        return this.defaultparalleliterators.value();
    }

    public int iterators_per_bucket() {
        return this.iterators_per_bucket.value();
    }

    public int defaultpendingmessages() {
        return this.defaultpendingmessages.value();
    }

    public int defaultdocblocksize() {
        return this.defaultdocblocksize.value();
    }

    public int defaultdocblocktimeout() {
        return this.defaultdocblocktimeout.value();
    }

    public int defaultinfotimeout() {
        return this.defaultinfotimeout.value();
    }

    public int maxconcurrentvisitors() {
        return this.maxconcurrentvisitors.value();
    }

    public int maxconcurrentvisitors_fixed() {
        return this.maxconcurrentvisitors_fixed.value();
    }

    public int maxconcurrentvisitors_variable() {
        return this.maxconcurrentvisitors_variable.value();
    }

    public int maxvisitorqueuesize() {
        return this.maxvisitorqueuesize.value();
    }

    public int visitor_memory_usage_limit() {
        return this.visitor_memory_usage_limit.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(StorVisitorConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.visitorthreads, (Node)newConfig.visitorthreads, "visitorthreads", "Number of separate threads that runs visitors.");
        changes.compare((Node)this.disconnectedvisitortimeout, (Node)newConfig.disconnectedvisitortimeout, "disconnectedvisitortimeout", "Default timeout of visitors that loses contact with client (in seconds)");
        changes.compare((Node)this.ignorenonexistingvisitortimelimit, (Node)newConfig.ignorenonexistingvisitortimelimit, "ignorenonexistingvisitortimelimit", "Time period (in seconds) in which to ignore requests to visitors that doesnt\nexist anymore. (Normal for visitors to get some messages right after\naborting, logging them as faults instead after this timeout has passed.)");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer visitorthreads = null;
        private Integer disconnectedvisitortimeout = null;
        private Integer ignorenonexistingvisitortimelimit = null;
        private Integer defaultparalleliterators = null;
        private Integer iterators_per_bucket = null;
        private Integer defaultpendingmessages = null;
        private Integer defaultdocblocksize = null;
        private Integer defaultdocblocktimeout = null;
        private Integer defaultinfotimeout = null;
        private Integer maxconcurrentvisitors = null;
        private Integer maxconcurrentvisitors_fixed = null;
        private Integer maxconcurrentvisitors_variable = null;
        private Integer maxvisitorqueuesize = null;
        private Integer visitor_memory_usage_limit = null;

        public Builder() {
        }

        public Builder(StorVisitorConfig config) {
            this.visitorthreads(config.visitorthreads());
            this.disconnectedvisitortimeout(config.disconnectedvisitortimeout());
            this.ignorenonexistingvisitortimelimit(config.ignorenonexistingvisitortimelimit());
            this.defaultparalleliterators(config.defaultparalleliterators());
            this.iterators_per_bucket(config.iterators_per_bucket());
            this.defaultpendingmessages(config.defaultpendingmessages());
            this.defaultdocblocksize(config.defaultdocblocksize());
            this.defaultdocblocktimeout(config.defaultdocblocktimeout());
            this.defaultinfotimeout(config.defaultinfotimeout());
            this.maxconcurrentvisitors(config.maxconcurrentvisitors());
            this.maxconcurrentvisitors_fixed(config.maxconcurrentvisitors_fixed());
            this.maxconcurrentvisitors_variable(config.maxconcurrentvisitors_variable());
            this.maxvisitorqueuesize(config.maxvisitorqueuesize());
            this.visitor_memory_usage_limit(config.visitor_memory_usage_limit());
        }

        private Builder override(Builder __superior) {
            if (__superior.visitorthreads != null) {
                this.visitorthreads(__superior.visitorthreads);
            }
            if (__superior.disconnectedvisitortimeout != null) {
                this.disconnectedvisitortimeout(__superior.disconnectedvisitortimeout);
            }
            if (__superior.ignorenonexistingvisitortimelimit != null) {
                this.ignorenonexistingvisitortimelimit(__superior.ignorenonexistingvisitortimelimit);
            }
            if (__superior.defaultparalleliterators != null) {
                this.defaultparalleliterators(__superior.defaultparalleliterators);
            }
            if (__superior.iterators_per_bucket != null) {
                this.iterators_per_bucket(__superior.iterators_per_bucket);
            }
            if (__superior.defaultpendingmessages != null) {
                this.defaultpendingmessages(__superior.defaultpendingmessages);
            }
            if (__superior.defaultdocblocksize != null) {
                this.defaultdocblocksize(__superior.defaultdocblocksize);
            }
            if (__superior.defaultdocblocktimeout != null) {
                this.defaultdocblocktimeout(__superior.defaultdocblocktimeout);
            }
            if (__superior.defaultinfotimeout != null) {
                this.defaultinfotimeout(__superior.defaultinfotimeout);
            }
            if (__superior.maxconcurrentvisitors != null) {
                this.maxconcurrentvisitors(__superior.maxconcurrentvisitors);
            }
            if (__superior.maxconcurrentvisitors_fixed != null) {
                this.maxconcurrentvisitors_fixed(__superior.maxconcurrentvisitors_fixed);
            }
            if (__superior.maxconcurrentvisitors_variable != null) {
                this.maxconcurrentvisitors_variable(__superior.maxconcurrentvisitors_variable);
            }
            if (__superior.maxvisitorqueuesize != null) {
                this.maxvisitorqueuesize(__superior.maxvisitorqueuesize);
            }
            if (__superior.visitor_memory_usage_limit != null) {
                this.visitor_memory_usage_limit(__superior.visitor_memory_usage_limit);
            }
            return this;
        }

        public Builder visitorthreads(int __value) {
            this.visitorthreads = __value;
            return this;
        }

        private Builder visitorthreads(String __value) {
            return this.visitorthreads(Integer.valueOf(__value));
        }

        public Builder disconnectedvisitortimeout(int __value) {
            this.disconnectedvisitortimeout = __value;
            return this;
        }

        private Builder disconnectedvisitortimeout(String __value) {
            return this.disconnectedvisitortimeout(Integer.valueOf(__value));
        }

        public Builder ignorenonexistingvisitortimelimit(int __value) {
            this.ignorenonexistingvisitortimelimit = __value;
            return this;
        }

        private Builder ignorenonexistingvisitortimelimit(String __value) {
            return this.ignorenonexistingvisitortimelimit(Integer.valueOf(__value));
        }

        public Builder defaultparalleliterators(int __value) {
            this.defaultparalleliterators = __value;
            return this;
        }

        private Builder defaultparalleliterators(String __value) {
            return this.defaultparalleliterators(Integer.valueOf(__value));
        }

        public Builder iterators_per_bucket(int __value) {
            this.iterators_per_bucket = __value;
            return this;
        }

        private Builder iterators_per_bucket(String __value) {
            return this.iterators_per_bucket(Integer.valueOf(__value));
        }

        public Builder defaultpendingmessages(int __value) {
            this.defaultpendingmessages = __value;
            return this;
        }

        private Builder defaultpendingmessages(String __value) {
            return this.defaultpendingmessages(Integer.valueOf(__value));
        }

        public Builder defaultdocblocksize(int __value) {
            this.defaultdocblocksize = __value;
            return this;
        }

        private Builder defaultdocblocksize(String __value) {
            return this.defaultdocblocksize(Integer.valueOf(__value));
        }

        public Builder defaultdocblocktimeout(int __value) {
            this.defaultdocblocktimeout = __value;
            return this;
        }

        private Builder defaultdocblocktimeout(String __value) {
            return this.defaultdocblocktimeout(Integer.valueOf(__value));
        }

        public Builder defaultinfotimeout(int __value) {
            this.defaultinfotimeout = __value;
            return this;
        }

        private Builder defaultinfotimeout(String __value) {
            return this.defaultinfotimeout(Integer.valueOf(__value));
        }

        public Builder maxconcurrentvisitors(int __value) {
            this.maxconcurrentvisitors = __value;
            return this;
        }

        private Builder maxconcurrentvisitors(String __value) {
            return this.maxconcurrentvisitors(Integer.valueOf(__value));
        }

        public Builder maxconcurrentvisitors_fixed(int __value) {
            this.maxconcurrentvisitors_fixed = __value;
            return this;
        }

        private Builder maxconcurrentvisitors_fixed(String __value) {
            return this.maxconcurrentvisitors_fixed(Integer.valueOf(__value));
        }

        public Builder maxconcurrentvisitors_variable(int __value) {
            this.maxconcurrentvisitors_variable = __value;
            return this;
        }

        private Builder maxconcurrentvisitors_variable(String __value) {
            return this.maxconcurrentvisitors_variable(Integer.valueOf(__value));
        }

        public Builder maxvisitorqueuesize(int __value) {
            this.maxvisitorqueuesize = __value;
            return this;
        }

        private Builder maxvisitorqueuesize(String __value) {
            return this.maxvisitorqueuesize(Integer.valueOf(__value));
        }

        public Builder visitor_memory_usage_limit(int __value) {
            this.visitor_memory_usage_limit = __value;
            return this;
        }

        private Builder visitor_memory_usage_limit(String __value) {
            return this.visitor_memory_usage_limit(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return StorVisitorConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return StorVisitorConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return StorVisitorConfig.CONFIG_DEF_NAMESPACE;
        }

        public StorVisitorConfig build() {
            return new StorVisitorConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

