/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content.core;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.Node;
import java.util.HashSet;
import java.util.Set;

public final class StorBucketdbConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "3a9a7fae16561ec23b8df819e4a3a46e";
    public static final String CONFIG_DEF_NAME = "stor-bucketdb";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content.core", "bucketinfobatchsize int default=128 restart", "chunklevel int default=1 restart"};
    private final IntegerNode bucketinfobatchsize;
    private final IntegerNode chunklevel;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public StorBucketdbConfig(Builder builder) {
        this(builder, true);
    }

    private StorBucketdbConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for stor-bucketdb must be initialized: " + builder.__uninitialized);
        }
        this.bucketinfobatchsize = builder.bucketinfobatchsize == null ? new IntegerNode(128) : new IntegerNode(builder.bucketinfobatchsize.intValue());
        this.chunklevel = builder.chunklevel == null ? new IntegerNode(1) : new IntegerNode(builder.chunklevel.intValue());
    }

    public int bucketinfobatchsize() {
        return this.bucketinfobatchsize.value();
    }

    public int chunklevel() {
        return this.chunklevel.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(StorBucketdbConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.bucketinfobatchsize, (Node)newConfig.bucketinfobatchsize, "bucketinfobatchsize", "Number of elements to retrieve in one bucket info chunk");
        changes.compare((Node)this.chunklevel, (Node)newConfig.chunklevel, "chunklevel", "Chunk level. Set what level of the path which defines one chunk.\n(See doxygen info in bucketmanager.h for more info)");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer bucketinfobatchsize = null;
        private Integer chunklevel = null;

        public Builder() {
        }

        public Builder(StorBucketdbConfig config) {
            this.bucketinfobatchsize(config.bucketinfobatchsize());
            this.chunklevel(config.chunklevel());
        }

        private Builder override(Builder __superior) {
            if (__superior.bucketinfobatchsize != null) {
                this.bucketinfobatchsize(__superior.bucketinfobatchsize);
            }
            if (__superior.chunklevel != null) {
                this.chunklevel(__superior.chunklevel);
            }
            return this;
        }

        public Builder bucketinfobatchsize(int __value) {
            this.bucketinfobatchsize = __value;
            return this;
        }

        private Builder bucketinfobatchsize(String __value) {
            return this.bucketinfobatchsize(Integer.valueOf(__value));
        }

        public Builder chunklevel(int __value) {
            this.chunklevel = __value;
            return this;
        }

        private Builder chunklevel(String __value) {
            return this.chunklevel(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return StorBucketdbConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return StorBucketdbConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return StorBucketdbConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

