/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content.core;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.Node;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashSet;
import java.util.Set;

public final class StorCommunicationmanagerConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "4f84cca7fc71849eb4647804a8231576";
    public static final String CONFIG_DEF_NAME = "stor-communicationmanager";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content.core";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content.core", "mbusport int default=-1 restart", "rpcport int default=6000 restart", "mbus_distributor_node_max_pending_count int default=5000", "mbus_content_node_max_pending_count int default=0", "mbus_distributor_node_max_pending_size int default=0", "mbus_content_node_max_pending_size int default=0", "mbus.compress.limit int default=1024", "mbus.compress.level int default=3", "mbus.compress.type enum {NONE, LZ4, ZSTD} default=LZ4", "mbus.rpctargetcache.ttl double default = 600"};
    private final IntegerNode mbusport;
    private final IntegerNode rpcport;
    private final IntegerNode mbus_distributor_node_max_pending_count;
    private final IntegerNode mbus_content_node_max_pending_count;
    private final IntegerNode mbus_distributor_node_max_pending_size;
    private final IntegerNode mbus_content_node_max_pending_size;
    private final Mbus mbus;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public StorCommunicationmanagerConfig(Builder builder) {
        this(builder, true);
    }

    private StorCommunicationmanagerConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for stor-communicationmanager must be initialized: " + builder.__uninitialized);
        }
        this.mbusport = builder.mbusport == null ? new IntegerNode(-1) : new IntegerNode(builder.mbusport.intValue());
        this.rpcport = builder.rpcport == null ? new IntegerNode(6000) : new IntegerNode(builder.rpcport.intValue());
        this.mbus_distributor_node_max_pending_count = builder.mbus_distributor_node_max_pending_count == null ? new IntegerNode(5000) : new IntegerNode(builder.mbus_distributor_node_max_pending_count.intValue());
        this.mbus_content_node_max_pending_count = builder.mbus_content_node_max_pending_count == null ? new IntegerNode(0) : new IntegerNode(builder.mbus_content_node_max_pending_count.intValue());
        this.mbus_distributor_node_max_pending_size = builder.mbus_distributor_node_max_pending_size == null ? new IntegerNode(0) : new IntegerNode(builder.mbus_distributor_node_max_pending_size.intValue());
        this.mbus_content_node_max_pending_size = builder.mbus_content_node_max_pending_size == null ? new IntegerNode(0) : new IntegerNode(builder.mbus_content_node_max_pending_size.intValue());
        this.mbus = new Mbus(builder.mbus, throwIfUninitialized);
    }

    public int mbusport() {
        return this.mbusport.value();
    }

    public int rpcport() {
        return this.rpcport.value();
    }

    public int mbus_distributor_node_max_pending_count() {
        return this.mbus_distributor_node_max_pending_count.value();
    }

    public int mbus_content_node_max_pending_count() {
        return this.mbus_content_node_max_pending_count.value();
    }

    public int mbus_distributor_node_max_pending_size() {
        return this.mbus_distributor_node_max_pending_size.value();
    }

    public int mbus_content_node_max_pending_size() {
        return this.mbus_content_node_max_pending_size.value();
    }

    public Mbus mbus() {
        return this.mbus;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(StorCommunicationmanagerConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.mbusport, (Node)newConfig.mbusport, "mbusport", CONFIG_DEF_VERSION);
        changes.compare((Node)this.rpcport, (Node)newConfig.rpcport, "rpcport", CONFIG_DEF_VERSION);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Mbus
    extends InnerNode {
        private final Compress compress;
        private final Rpctargetcache rpctargetcache;

        public Mbus(Builder builder) {
            this(builder, true);
        }

        private Mbus(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for stor-communicationmanager.mbus must be initialized: " + builder.__uninitialized);
            }
            this.compress = new Compress(builder.compress, throwIfUninitialized);
            this.rpctargetcache = new Rpctargetcache(builder.rpctargetcache, throwIfUninitialized);
        }

        public Compress compress() {
            return this.compress;
        }

        public Rpctargetcache rpctargetcache() {
            return this.rpctargetcache;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Mbus newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("mbus");
            return changes;
        }

        public static final class Rpctargetcache
        extends InnerNode {
            private final DoubleNode ttl;

            public Rpctargetcache(Builder builder) {
                this(builder, true);
            }

            private Rpctargetcache(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for stor-communicationmanager.mbus.rpctargetcache must be initialized: " + builder.__uninitialized);
                }
                this.ttl = builder.ttl == null ? new DoubleNode(600.0) : new DoubleNode(builder.ttl.doubleValue());
            }

            public double ttl() {
                return this.ttl.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Rpctargetcache newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("rpctargetcache");
                return changes;
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Double ttl = null;

                public Builder() {
                }

                public Builder(Rpctargetcache config) {
                    this.ttl(config.ttl());
                }

                private Builder override(Builder __superior) {
                    if (__superior.ttl != null) {
                        this.ttl(__superior.ttl);
                    }
                    return this;
                }

                public Builder ttl(double __value) {
                    this.ttl = __value;
                    return this;
                }

                private Builder ttl(String __value) {
                    return this.ttl(Double.valueOf(__value));
                }
            }
        }

        public static final class Compress
        extends InnerNode {
            private final IntegerNode limit;
            private final IntegerNode level;
            private final Type type;

            public Compress(Builder builder) {
                this(builder, true);
            }

            private Compress(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for stor-communicationmanager.mbus.compress must be initialized: " + builder.__uninitialized);
                }
                this.limit = builder.limit == null ? new IntegerNode(1024) : new IntegerNode(builder.limit.intValue());
                this.level = builder.level == null ? new IntegerNode(3) : new IntegerNode(builder.level.intValue());
                this.type = builder.type == null ? new Type(Type.LZ4) : new Type(builder.type);
            }

            public int limit() {
                return this.limit.value();
            }

            public int level() {
                return this.level.value();
            }

            public Type.Enum type() {
                return (Type.Enum)((Object)this.type.value());
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Compress newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("compress");
                return changes;
            }

            public static final class Type
            extends EnumNode<Enum> {
                public static final Enum NONE = Enum.NONE;
                public static final Enum LZ4 = Enum.LZ4;
                public static final Enum ZSTD = Enum.ZSTD;

                public Type() {
                    this.value = null;
                }

                public Type(Enum enumValue) {
                    super(enumValue != null);
                    this.value = enumValue;
                }

                protected boolean doSetValue(@NonNull String name) {
                    try {
                        this.value = Enum.valueOf(name);
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }

                public static enum Enum {
                    NONE,
                    LZ4,
                    ZSTD;

                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Integer limit = null;
                private Integer level = null;
                private Type.Enum type = null;

                public Builder() {
                }

                public Builder(Compress config) {
                    this.limit(config.limit());
                    this.level(config.level());
                    this.type(config.type());
                }

                private Builder override(Builder __superior) {
                    if (__superior.limit != null) {
                        this.limit(__superior.limit);
                    }
                    if (__superior.level != null) {
                        this.level(__superior.level);
                    }
                    if (__superior.type != null) {
                        this.type(__superior.type);
                    }
                    return this;
                }

                public Builder limit(int __value) {
                    this.limit = __value;
                    return this;
                }

                private Builder limit(String __value) {
                    return this.limit(Integer.valueOf(__value));
                }

                public Builder level(int __value) {
                    this.level = __value;
                    return this;
                }

                private Builder level(String __value) {
                    return this.level(Integer.valueOf(__value));
                }

                public Builder type(Type.Enum __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.type = __value;
                    return this;
                }

                private Builder type(String __value) {
                    return this.type(Type.Enum.valueOf(__value));
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public Compress.Builder compress = new Compress.Builder();
            public Rpctargetcache.Builder rpctargetcache = new Rpctargetcache.Builder();

            public Builder() {
            }

            public Builder(Mbus config) {
                this.compress(new Compress.Builder(config.compress()));
                this.rpctargetcache(new Rpctargetcache.Builder(config.rpctargetcache()));
            }

            private Builder override(Builder __superior) {
                this.compress(this.compress.override(__superior.compress));
                this.rpctargetcache(this.rpctargetcache.override(__superior.rpctargetcache));
                return this;
            }

            public Builder compress(Compress.Builder __builder) {
                this.compress = __builder;
                return this;
            }

            public Builder rpctargetcache(Rpctargetcache.Builder __builder) {
                this.rpctargetcache = __builder;
                return this;
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer mbusport = null;
        private Integer rpcport = null;
        private Integer mbus_distributor_node_max_pending_count = null;
        private Integer mbus_content_node_max_pending_count = null;
        private Integer mbus_distributor_node_max_pending_size = null;
        private Integer mbus_content_node_max_pending_size = null;
        public Mbus.Builder mbus = new Mbus.Builder();

        public Builder() {
        }

        public Builder(StorCommunicationmanagerConfig config) {
            this.mbusport(config.mbusport());
            this.rpcport(config.rpcport());
            this.mbus_distributor_node_max_pending_count(config.mbus_distributor_node_max_pending_count());
            this.mbus_content_node_max_pending_count(config.mbus_content_node_max_pending_count());
            this.mbus_distributor_node_max_pending_size(config.mbus_distributor_node_max_pending_size());
            this.mbus_content_node_max_pending_size(config.mbus_content_node_max_pending_size());
            this.mbus(new Mbus.Builder(config.mbus()));
        }

        private Builder override(Builder __superior) {
            if (__superior.mbusport != null) {
                this.mbusport(__superior.mbusport);
            }
            if (__superior.rpcport != null) {
                this.rpcport(__superior.rpcport);
            }
            if (__superior.mbus_distributor_node_max_pending_count != null) {
                this.mbus_distributor_node_max_pending_count(__superior.mbus_distributor_node_max_pending_count);
            }
            if (__superior.mbus_content_node_max_pending_count != null) {
                this.mbus_content_node_max_pending_count(__superior.mbus_content_node_max_pending_count);
            }
            if (__superior.mbus_distributor_node_max_pending_size != null) {
                this.mbus_distributor_node_max_pending_size(__superior.mbus_distributor_node_max_pending_size);
            }
            if (__superior.mbus_content_node_max_pending_size != null) {
                this.mbus_content_node_max_pending_size(__superior.mbus_content_node_max_pending_size);
            }
            this.mbus(this.mbus.override(__superior.mbus));
            return this;
        }

        public Builder mbusport(int __value) {
            this.mbusport = __value;
            return this;
        }

        private Builder mbusport(String __value) {
            return this.mbusport(Integer.valueOf(__value));
        }

        public Builder rpcport(int __value) {
            this.rpcport = __value;
            return this;
        }

        private Builder rpcport(String __value) {
            return this.rpcport(Integer.valueOf(__value));
        }

        public Builder mbus_distributor_node_max_pending_count(int __value) {
            this.mbus_distributor_node_max_pending_count = __value;
            return this;
        }

        private Builder mbus_distributor_node_max_pending_count(String __value) {
            return this.mbus_distributor_node_max_pending_count(Integer.valueOf(__value));
        }

        public Builder mbus_content_node_max_pending_count(int __value) {
            this.mbus_content_node_max_pending_count = __value;
            return this;
        }

        private Builder mbus_content_node_max_pending_count(String __value) {
            return this.mbus_content_node_max_pending_count(Integer.valueOf(__value));
        }

        public Builder mbus_distributor_node_max_pending_size(int __value) {
            this.mbus_distributor_node_max_pending_size = __value;
            return this;
        }

        private Builder mbus_distributor_node_max_pending_size(String __value) {
            return this.mbus_distributor_node_max_pending_size(Integer.valueOf(__value));
        }

        public Builder mbus_content_node_max_pending_size(int __value) {
            this.mbus_content_node_max_pending_size = __value;
            return this;
        }

        private Builder mbus_content_node_max_pending_size(String __value) {
            return this.mbus_content_node_max_pending_size(Integer.valueOf(__value));
        }

        public Builder mbus(Mbus.Builder __builder) {
            this.mbus = __builder;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return StorCommunicationmanagerConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return StorCommunicationmanagerConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return StorCommunicationmanagerConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

