/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.application.container.impl;

import com.google.common.collect.Lists;
import com.yahoo.container.standalone.StandaloneContainerApplication;
import com.yahoo.jdisc.application.OsgiFramework;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;

public final class ClassLoaderOsgiFramework
implements OsgiFramework {
    private BundleContextImpl bundleContextImpl = new BundleContextImpl();
    private SystemBundleImpl systemBundleImpl = new SystemBundleImpl();
    private BundleWiringImpl bundleWiringImpl = new BundleWiringImpl();
    private List<URL> bundleLocations = new ArrayList<URL>();
    private List<Bundle> bundleList = Lists.newArrayList((Object[])new Bundle[]{this.systemBundleImpl});
    private ClassLoader classLoader = null;
    private AtomicInteger nextBundleId = new AtomicInteger(1);

    public List<Bundle> installBundle(String bundleLocation) {
        if (bundleLocation != null && !bundleLocation.isEmpty()) {
            try {
                URL url = new URL(bundleLocation);
                this.bundleLocations.add(url);
                this.bundleList.add(new JarBundleImpl(url));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.bundles();
    }

    private ClassLoader getClassLoader() {
        if (this.bundleLocations.isEmpty()) {
            return this.getClass().getClassLoader();
        }
        if (this.classLoader == null) {
            this.classLoader = new URLClassLoader(this.bundleLocations.toArray(new URL[0]), this.getClass().getClassLoader());
        }
        return this.classLoader;
    }

    public void startBundles(List<Bundle> bundles, boolean privileged) {
    }

    public void refreshPackages() {
    }

    public BundleContext bundleContext() {
        return this.bundleContextImpl;
    }

    public List<Bundle> bundles() {
        return this.bundleList;
    }

    public List<Bundle> getBundles(Bundle requestingBundle) {
        return this.bundleList;
    }

    public void allowDuplicateBundles(Collection<Bundle> bundles) {
    }

    public void start() {
    }

    public void stop() {
    }

    private class BundleContextImpl
    implements BundleContext {
        private BundleContextImpl() {
        }

        public String getProperty(String key) {
            return null;
        }

        public Bundle getBundle() {
            return ClassLoaderOsgiFramework.this.systemBundleImpl;
        }

        public Bundle installBundle(String location, InputStream input) {
            throw new UnsupportedOperationException();
        }

        public Bundle installBundle(String location) {
            throw new UnsupportedOperationException();
        }

        public Bundle getBundle(long id) {
            return ClassLoaderOsgiFramework.this.systemBundleImpl;
        }

        public Bundle[] getBundles() {
            return new Bundle[]{ClassLoaderOsgiFramework.this.systemBundleImpl};
        }

        public Bundle getBundle(String location) {
            return ClassLoaderOsgiFramework.this.systemBundleImpl;
        }

        public void addServiceListener(ServiceListener listener, String filter) {
        }

        public void addServiceListener(ServiceListener listener) {
        }

        public void removeServiceListener(ServiceListener listener) {
        }

        public void addBundleListener(BundleListener listener) {
        }

        public void removeBundleListener(BundleListener listener) {
        }

        public void addFrameworkListener(FrameworkListener listener) {
        }

        public void removeFrameworkListener(FrameworkListener listener) {
        }

        public ServiceRegistration<?> registerService(String[] classes, Object service, Dictionary<String, ?> properties) {
            throw new UnsupportedOperationException();
        }

        public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<String, ?> properties) {
            return null;
        }

        public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
            throw new UnsupportedOperationException();
        }

        public ServiceReference<?>[] getServiceReferences(String clazz, String filter) {
            throw new UnsupportedOperationException();
        }

        public ServiceReference<?>[] getAllServiceReferences(String clazz, String filter) {
            throw new UnsupportedOperationException();
        }

        public ServiceReference<?> getServiceReference(String clazz) {
            throw new UnsupportedOperationException();
        }

        public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
            throw new UnsupportedOperationException();
        }

        public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) {
            return new ArrayList<ServiceReference<S>>();
        }

        public <S> S getService(ServiceReference<S> reference) {
            throw new UnsupportedOperationException();
        }

        public boolean ungetService(ServiceReference<?> reference) {
            throw new UnsupportedOperationException();
        }

        public File getDataFile(String filename) {
            throw new UnsupportedOperationException();
        }

        public Filter createFilter(String filter) {
            throw new UnsupportedOperationException();
        }

        public <S> ServiceRegistration<S> registerService(Class<S> aClass, ServiceFactory<S> serviceFactory, Dictionary<String, ?> dictionary) {
            throw new UnsupportedOperationException();
        }

        public <S> ServiceObjects<S> getServiceObjects(ServiceReference<S> serviceReference) {
            throw new UnsupportedOperationException();
        }
    }

    private class SystemBundleImpl
    extends BundleImpl {
        private SystemBundleImpl() {
        }

        public long getBundleId() {
            return 0L;
        }

        public Version getVersion() {
            return Version.emptyVersion;
        }

        public Dictionary<String, String> getHeaders() {
            Hashtable<String, String> ret = new Hashtable<String, String>();
            ret.put("X-JDisc-Application", StandaloneContainerApplication.class.getName());
            return ret;
        }
    }

    private class BundleWiringImpl
    implements BundleWiring {
        private BundleWiringImpl() {
        }

        public List<URL> findEntries(String p1, String p2, int p3) {
            throw new UnsupportedOperationException();
        }

        public List<Wire> getRequiredResourceWires(String p1) {
            throw new UnsupportedOperationException();
        }

        public List<Capability> getResourceCapabilities(String p1) {
            throw new UnsupportedOperationException();
        }

        public boolean isCurrent() {
            throw new UnsupportedOperationException();
        }

        public List<BundleWire> getRequiredWires(String p1) {
            throw new UnsupportedOperationException();
        }

        public List<BundleCapability> getCapabilities(String p1) {
            throw new UnsupportedOperationException();
        }

        public List<Wire> getProvidedResourceWires(String p1) {
            throw new UnsupportedOperationException();
        }

        public List<BundleWire> getProvidedWires(String p1) {
            throw new UnsupportedOperationException();
        }

        public BundleRevision getRevision() {
            throw new UnsupportedOperationException();
        }

        public List<Requirement> getResourceRequirements(String p1) {
            throw new UnsupportedOperationException();
        }

        public boolean isInUse() {
            throw new UnsupportedOperationException();
        }

        public Collection<String> listResources(String p1, String p2, int p3) {
            throw new UnsupportedOperationException();
        }

        public ClassLoader getClassLoader() {
            return ClassLoaderOsgiFramework.this.getClassLoader();
        }

        public List<BundleRequirement> getRequirements(String p1) {
            throw new UnsupportedOperationException();
        }

        public BundleRevision getResource() {
            throw new UnsupportedOperationException();
        }

        public Bundle getBundle() {
            throw new UnsupportedOperationException();
        }
    }

    private class JarBundleImpl
    extends BundleImpl {
        private final long bundleId;
        private final Dictionary<String, String> headers;

        JarBundleImpl(URL location) throws IOException {
            this.bundleId = ClassLoaderOsgiFramework.this.nextBundleId.getAndIncrement();
            this.headers = this.retrieveHeaders(location);
        }

        public long getBundleId() {
            return this.bundleId;
        }

        public Dictionary<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        public String getSymbolicName() {
            return this.headers.get("Bundle-SymbolicName");
        }

        public Version getVersion() {
            return Version.parseVersion((String)this.headers.get("Bundle-Version"));
        }

        private Dictionary<String, String> retrieveHeaders(URL location) throws IOException {
            try (JarFile jarFile = new JarFile(location.getFile());){
                Attributes attributes = jarFile.getManifest().getMainAttributes();
                Hashtable<String, String> ret = new Hashtable<String, String>();
                attributes.forEach((k, v) -> ret.put(k.toString(), v.toString()));
                Hashtable<String, String> hashtable = ret;
                return hashtable;
            }
        }
    }

    private class BundleRevisionImpl
    implements BundleRevision {
        private BundleRevisionImpl() {
        }

        public String getSymbolicName() {
            return this.getClass().getName();
        }

        public List<BundleRequirement> getDeclaredRequirements(String p1) {
            throw new UnsupportedOperationException();
        }

        public Version getVersion() {
            return Version.emptyVersion;
        }

        public BundleWiring getWiring() {
            return ClassLoaderOsgiFramework.this.bundleWiringImpl;
        }

        public List<BundleCapability> getDeclaredCapabilities(String p1) {
            throw new UnsupportedOperationException();
        }

        public int getTypes() {
            return 0;
        }

        public Bundle getBundle() {
            throw new UnsupportedOperationException();
        }

        public List<Capability> getCapabilities(String p1) {
            throw new UnsupportedOperationException();
        }

        public List<Requirement> getRequirements(String p1) {
            throw new UnsupportedOperationException();
        }
    }

    private abstract class BundleImpl
    implements Bundle {
        private BundleImpl() {
        }

        public int getState() {
            return 32;
        }

        public void start(int options) {
        }

        public void start() {
        }

        public void stop(int options) {
        }

        public void stop() {
        }

        public void update(InputStream input) {
        }

        public void update() {
        }

        public void uninstall() {
        }

        public Dictionary<String, String> getHeaders(String locale) {
            return this.getHeaders();
        }

        public String getSymbolicName() {
            return ClassLoaderOsgiFramework.this.getClass().getName();
        }

        public String getLocation() {
            return this.getSymbolicName();
        }

        public ServiceReference<?>[] getRegisteredServices() {
            return new ServiceReference[0];
        }

        public ServiceReference<?>[] getServicesInUse() {
            return this.getRegisteredServices();
        }

        public boolean hasPermission(Object permission) {
            return true;
        }

        public URL getResource(String name) {
            return ClassLoaderOsgiFramework.this.getClassLoader().getResource(name);
        }

        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return ClassLoaderOsgiFramework.this.getClassLoader().loadClass(name);
        }

        public Enumeration<URL> getResources(String name) throws IOException {
            return ClassLoaderOsgiFramework.this.getClassLoader().getResources(name);
        }

        public Enumeration<String> getEntryPaths(String path) {
            throw new UnsupportedOperationException();
        }

        public URL getEntry(String path) {
            throw new UnsupportedOperationException();
        }

        public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
            throw new UnsupportedOperationException();
        }

        public long getLastModified() {
            return 1L;
        }

        public BundleContext getBundleContext() {
            throw new UnsupportedOperationException();
        }

        public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
            return Collections.emptyMap();
        }

        public <T> T adapt(Class<T> clazz) {
            if (clazz.equals(BundleRevision.class)) {
                return (T)new BundleRevisionImpl();
            }
            if (clazz.equals(BundleWiring.class)) {
                return (T)new BundleWiringImpl();
            }
            return null;
        }

        public File getDataFile(String filename) {
            return null;
        }

        public int compareTo(Bundle o) {
            return Long.compare(this.getBundleId(), o.getBundleId());
        }
    }
}

