/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.standalone;

import com.yahoo.vespa.model.container.configserver.option.ConfigOptions;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class ConfigEnvironmentVariables
implements ConfigOptions {
    public Optional<Integer> rpcPort() {
        return Optional.ofNullable(System.getenv("VESPA_CONFIGSERVER_RPC_PORT")).or(() -> ConfigEnvironmentVariables.getRawInstallVariable("services.port_configserver_rpc")).map(Integer::parseInt);
    }

    public Optional<Boolean> multiTenant() {
        return Optional.ofNullable(System.getenv("VESPA_CONFIGSERVER_MULTITENANT")).or(() -> ConfigEnvironmentVariables.getInstallVariable("multitenant")).map(Boolean::parseBoolean);
    }

    public ConfigOptions.ConfigServer[] allConfigServers() {
        return Optional.ofNullable(System.getenv("VESPA_CONFIGSERVERS")).or(() -> ConfigEnvironmentVariables.getRawInstallVariable("services.addr_configserver")).map(ConfigEnvironmentVariables::toConfigServers).orElseGet(() -> new ConfigOptions.ConfigServer[0]);
    }

    public int[] configServerZookeeperIds() {
        return Optional.ofNullable(System.getenv("VESPA_CONFIGSERVER_ZOOKEEPER_IDS")).map(ConfigEnvironmentVariables::multiValueParameterStream).orElseGet(Stream::empty).mapToInt(Integer::valueOf).toArray();
    }

    public Optional<Long> zookeeperBarrierTimeout() {
        return Optional.ofNullable(System.getenv("VESPA_CONFIGSERVER_ZOOKEEPER_BARRIER_TIMEOUT")).map(Long::parseLong).or(() -> ConfigEnvironmentVariables.getInstallVariable("zookeeper_barrier_timeout", Long::parseLong));
    }

    public Integer zookeeperJuteMaxBuffer() {
        return Optional.ofNullable(System.getenv("VESPA_CONFIGSERVER_ZOOKEEPER_JUTE_MAX_BUFFER")).map(Integer::parseInt).orElse(0x6400000);
    }

    public Optional<Long> sessionLifeTimeSecs() {
        return ConfigEnvironmentVariables.getInstallVariable("session_lifetime", Long::parseLong);
    }

    public String[] configModelPluginDirs() {
        return ConfigEnvironmentVariables.getRawInstallVariable("cloudconfig_server.config_model_plugin_dirs").map(ConfigEnvironmentVariables::toConfigModelsPluginDir).orElseGet(() -> new String[0]);
    }

    public Optional<Integer> zookeeperClientPort() {
        return ConfigEnvironmentVariables.getInstallVariable("zookeeper_clientPort", Integer::parseInt);
    }

    public Optional<Integer> zookeeperQuorumPort() {
        return ConfigEnvironmentVariables.getInstallVariable("zookeeper_quorumPort", Integer::parseInt);
    }

    public Optional<Integer> zookeeperElectionPort() {
        return ConfigEnvironmentVariables.getInstallVariable("zookeeper_electionPort", Integer::parseInt);
    }

    public Optional<String> environment() {
        return Optional.ofNullable(System.getenv("VESPA_ENVIRONMENT")).or(() -> ConfigEnvironmentVariables.getInstallVariable("environment"));
    }

    public Optional<String> region() {
        return Optional.ofNullable(System.getenv("VESPA_REGION")).or(() -> ConfigEnvironmentVariables.getInstallVariable("region"));
    }

    public Optional<String> system() {
        return Optional.ofNullable(System.getenv("VESPA_SYSTEM")).or(() -> ConfigEnvironmentVariables.getInstallVariable("system"));
    }

    public Optional<String> cloud() {
        return Optional.ofNullable(System.getenv("VESPA_CLOUD"));
    }

    public Optional<Boolean> useVespaVersionInRequest() {
        return ConfigEnvironmentVariables.getInstallVariable("use_vespa_version_in_request", Boolean::parseBoolean);
    }

    public Optional<Boolean> hostedVespa() {
        return Optional.ofNullable(System.getenv("VESPA_CONFIGSERVER_HOSTED")).or(() -> ConfigEnvironmentVariables.getInstallVariable("hosted_vespa")).map(Boolean::parseBoolean);
    }

    public Optional<String> loadBalancerAddress() {
        return ConfigEnvironmentVariables.getInstallVariable("load_balancer_address");
    }

    public Optional<String> athenzDnsSuffix() {
        return ConfigEnvironmentVariables.getInstallVariable("athenz_dns_suffix");
    }

    public Optional<String> ztsUrl() {
        return ConfigEnvironmentVariables.getInstallVariable("zts_url");
    }

    public String zooKeeperSnapshotMethod() {
        String vespaZookeeperSnapshotMethod = System.getenv("VESPA_ZOOKEEPER_SNAPSHOT_METHOD");
        return vespaZookeeperSnapshotMethod == null ? "" : vespaZookeeperSnapshotMethod;
    }

    static ConfigOptions.ConfigServer[] toConfigServers(String configserversString) {
        return (ConfigOptions.ConfigServer[])ConfigEnvironmentVariables.multiValueParameterStream(configserversString).map(ConfigEnvironmentVariables::toConfigServer).toArray(ConfigOptions.ConfigServer[]::new);
    }

    static ConfigOptions.ConfigServer toConfigServer(String configserverString) {
        try {
            String[] hostPortTuple = configserverString.split(":");
            if (configserverString.contains(":")) {
                return new ConfigOptions.ConfigServer(hostPortTuple[0], Optional.of(Integer.parseInt(hostPortTuple[1])));
            }
            return new ConfigOptions.ConfigServer(configserverString, Optional.empty());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid config server " + configserverString, e);
        }
    }

    static String[] toConfigModelsPluginDir(String configModelsPluginDirString) {
        return (String[])ConfigEnvironmentVariables.multiValueParameterStream(configModelsPluginDirString).toArray(String[]::new);
    }

    private static Optional<String> getInstallVariable(String name) {
        return ConfigEnvironmentVariables.getInstallVariable(name, Function.identity());
    }

    private static <T> Optional<T> getInstallVariable(String name, Function<String, T> converter) {
        return ConfigEnvironmentVariables.getRawInstallVariable("cloudconfig_server." + name).map(converter);
    }

    private static Optional<String> getRawInstallVariable(String name) {
        return Optional.ofNullable(Optional.ofNullable(System.getenv(name.replace(".", "__"))).orElseGet(() -> System.getProperty(name)));
    }

    private static Stream<String> multiValueParameterStream(String param) {
        return Arrays.stream(param.split("[, ]")).filter(value -> !value.isEmpty());
    }
}

