/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.standalone;

import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.net.HostName;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class LocalFileDb
implements FileAcquirer,
FileRegistry {
    private static final Constructor<FileReference> fileReferenceConstructor = LocalFileDb.createFileReferenceConstructor();
    private final Map<FileReference, File> fileReferenceToFile = new HashMap<FileReference, File>();
    private final Path appPath;

    public LocalFileDb(Path appPath) {
        this.appPath = appPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File waitFor(FileReference reference, long l, TimeUnit timeUnit) {
        LocalFileDb localFileDb = this;
        synchronized (localFileDb) {
            File file = this.fileReferenceToFile.get(reference);
            if (file == null) {
                throw new RuntimeException("Invalid file reference " + reference);
            }
            return file;
        }
    }

    public void shutdown() {
    }

    public FileReference addFile(String relativePath) {
        File file = this.appPath.resolve(relativePath).toFile();
        if (!file.exists()) {
            throw new RuntimeException("The file does not exist: " + file.getPath());
        }
        FileReference fileReference = null;
        try {
            fileReference = fileReferenceConstructor.newInstance("LocalFileDb:" + relativePath);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create new FileReference", e);
        }
        this.fileReferenceToFile.put(fileReference, file);
        return fileReference;
    }

    public List<FileRegistry.Entry> export() {
        return this.fileReferenceToFile.entrySet().stream().map(entry -> new FileRegistry.Entry(((File)entry.getValue()).getPath(), (FileReference)entry.getKey())).collect(Collectors.toList());
    }

    public FileReference addUri(String uri) {
        throw new RuntimeException("addUri(String uri) is not implemented here.");
    }

    public String fileSourceHost() {
        return HostName.getLocalhost();
    }

    public Set<String> allRelativePaths() {
        return this.fileReferenceToFile.values().stream().map(File::getPath).collect(Collectors.toSet());
    }

    private static Constructor<FileReference> createFileReferenceConstructor() {
        try {
            Constructor<FileReference> method = FileReference.class.getDeclaredConstructor(String.class);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

