/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.standalone;

import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.config.subscription.SubscriberClosedException;
import com.yahoo.container.di.config.Subscriber;
import com.yahoo.container.di.config.SubscriberFactory;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.model.VespaModel;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StandaloneSubscriberFactory
implements SubscriberFactory {
    private final VespaModel root;

    public StandaloneSubscriberFactory(VespaModel root) {
        this.root = root;
    }

    public Subscriber getSubscriber(Set<? extends ConfigKey<?>> configKeys, String name) {
        return new StandaloneSubscriber(configKeys);
    }

    public void reloadActiveSubscribers(long generation) {
        throw new RuntimeException("unsupported");
    }

    private static ConfigInstance.Builder newBuilderInstance(ConfigKey<ConfigInstance> key) {
        try {
            return StandaloneSubscriberFactory.builderClass(key).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("ConfigInstance builder cannot be instantiated", e);
        }
    }

    private static Class<ConfigInstance.Builder> builderClass(ConfigKey<ConfigInstance> key) {
        Class configClass = key.getConfigClass();
        if (configClass != null) {
            Class<?>[] nestedClasses;
            for (Class<ConfigInstance.Builder> clazz : nestedClasses = configClass.getClasses()) {
                if (!clazz.getName().equals(key.getConfigClass().getName() + "$Builder")) continue;
                return clazz;
            }
        }
        throw new RuntimeException("Builder class for " + (configClass == null ? null : configClass.getName()) + " could not be located");
    }

    private static ConfigInstance newConfigInstance(ConfigBuilder builder) {
        try {
            return StandaloneSubscriberFactory.configClass(builder).getConstructor(builder.getClass()).newInstance(builder);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("ConfigInstance cannot be instantiated", e);
        }
    }

    private static Class<ConfigInstance> configClass(ConfigBuilder builder) {
        return builder.getClass().getEnclosingClass();
    }

    private class StandaloneSubscriber
    implements Subscriber {
        private final Set<ConfigKey<ConfigInstance>> configKeys;
        private long generation = -1L;
        private volatile boolean shutdown = false;

        StandaloneSubscriber(Set<ConfigKey<ConfigInstance>> configKeys) {
            this.configKeys = configKeys;
        }

        public boolean configChanged() {
            return this.generation == 0L;
        }

        public void close() {
            this.shutdown = true;
        }

        public Map<ConfigKey<ConfigInstance>, ConfigInstance> config() {
            HashMap<ConfigKey<ConfigInstance>, ConfigInstance> ret = new HashMap<ConfigKey<ConfigInstance>, ConfigInstance>();
            for (ConfigKey<ConfigInstance> key : this.configKeys) {
                ConfigInstance.Builder builder = StandaloneSubscriberFactory.this.root.getConfig(StandaloneSubscriberFactory.newBuilderInstance(key), key.getConfigId());
                if (builder == null) {
                    throw new RuntimeException("Invalid config id " + key.getConfigId());
                }
                ret.put(key, StandaloneSubscriberFactory.newConfigInstance((ConfigBuilder)builder));
            }
            return ret;
        }

        public long waitNextGeneration(boolean isInitializing) {
            ++this.generation;
            if (this.generation != 0L) {
                try {
                    while (!this.shutdown && !Thread.interrupted()) {
                        Thread.sleep(100L);
                    }
                    if (this.shutdown) {
                        throw new SubscriberClosedException();
                    }
                }
                catch (InterruptedException e) {
                    throw new ConfigInterruptedException((Throwable)e);
                }
            }
            return this.generation;
        }

        public long generation() {
            return this.generation;
        }
    }
}

