/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.standalone;

import com.yahoo.vespa.model.container.configserver.option.CloudConfigOptions;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class CloudConfigInstallVariables
implements CloudConfigOptions {
    public Optional<Integer> rpcPort() {
        return Optional.ofNullable(System.getenv("VESPA_CONFIGSERVER_RPC_PORT")).or(() -> CloudConfigInstallVariables.getRawInstallVariable("services.port_configserver_rpc")).map(Integer::parseInt);
    }

    public Optional<Boolean> multiTenant() {
        return Optional.ofNullable(System.getenv("VESPA_CONFIGSERVER_MULTITENANT")).or(() -> CloudConfigInstallVariables.getInstallVariable("multitenant")).map(Boolean::parseBoolean);
    }

    public CloudConfigOptions.ConfigServer[] allConfigServers() {
        return Optional.ofNullable(System.getenv("VESPA_CONFIGSERVERS")).or(() -> CloudConfigInstallVariables.getRawInstallVariable("services.addr_configserver")).map(CloudConfigInstallVariables::toConfigServers).orElseGet(() -> new CloudConfigOptions.ConfigServer[0]);
    }

    public int[] configServerZookeeperIds() {
        return Optional.ofNullable(System.getenv("VESPA_CONFIGSERVER_ZOOKEEPER_IDS")).map(CloudConfigInstallVariables::multiValueParameterStream).orElseGet(Stream::empty).mapToInt(Integer::valueOf).toArray();
    }

    public Optional<Long> zookeeperBarrierTimeout() {
        return CloudConfigInstallVariables.getInstallVariable("zookeeper_barrier_timeout", Long::parseLong);
    }

    public Optional<Long> sessionLifeTimeSecs() {
        return CloudConfigInstallVariables.getInstallVariable("session_lifetime", Long::parseLong);
    }

    public String[] configModelPluginDirs() {
        return CloudConfigInstallVariables.getRawInstallVariable("cloudconfig_server.config_model_plugin_dirs").map(CloudConfigInstallVariables::toConfigModelsPluginDir).orElseGet(() -> new String[0]);
    }

    public Optional<Integer> zookeeperClientPort() {
        return CloudConfigInstallVariables.getInstallVariable("zookeeper_clientPort", Integer::parseInt);
    }

    public Optional<Integer> zookeeperQuorumPort() {
        return CloudConfigInstallVariables.getInstallVariable("zookeeper_quorumPort", Integer::parseInt);
    }

    public Optional<Integer> zookeeperElectionPort() {
        return CloudConfigInstallVariables.getInstallVariable("zookeeper_electionPort", Integer::parseInt);
    }

    public Optional<String> environment() {
        return Optional.ofNullable(System.getenv("VESPA_ENVIRONMENT")).or(() -> CloudConfigInstallVariables.getInstallVariable("environment"));
    }

    public Optional<String> region() {
        return Optional.ofNullable(System.getenv("VESPA_REGION")).or(() -> CloudConfigInstallVariables.getInstallVariable("region"));
    }

    public Optional<String> system() {
        return Optional.ofNullable(System.getenv("VESPA_SYSTEM")).or(() -> CloudConfigInstallVariables.getInstallVariable("system"));
    }

    public Optional<String> cloud() {
        return Optional.ofNullable(System.getenv("VESPA_CLOUD"));
    }

    public Optional<Boolean> useVespaVersionInRequest() {
        return CloudConfigInstallVariables.getInstallVariable("use_vespa_version_in_request", Boolean::parseBoolean);
    }

    public Optional<Boolean> hostedVespa() {
        return Optional.ofNullable(System.getenv("VESPA_CONFIGSERVER_HOSTED")).or(() -> CloudConfigInstallVariables.getInstallVariable("hosted_vespa")).map(Boolean::parseBoolean);
    }

    public Optional<String> loadBalancerAddress() {
        return CloudConfigInstallVariables.getInstallVariable("load_balancer_address");
    }

    public Optional<String> athenzDnsSuffix() {
        return CloudConfigInstallVariables.getInstallVariable("athenz_dns_suffix");
    }

    public Optional<String> ztsUrl() {
        return CloudConfigInstallVariables.getInstallVariable("zts_url");
    }

    static CloudConfigOptions.ConfigServer[] toConfigServers(String configserversString) {
        return (CloudConfigOptions.ConfigServer[])CloudConfigInstallVariables.multiValueParameterStream(configserversString).map(CloudConfigInstallVariables::toConfigServer).toArray(CloudConfigOptions.ConfigServer[]::new);
    }

    static CloudConfigOptions.ConfigServer toConfigServer(String configserverString) {
        try {
            String[] hostPortTuple = configserverString.split(":");
            if (configserverString.contains(":")) {
                return new CloudConfigOptions.ConfigServer(hostPortTuple[0], Optional.of(Integer.parseInt(hostPortTuple[1])));
            }
            return new CloudConfigOptions.ConfigServer(configserverString, Optional.empty());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid config server " + configserverString, e);
        }
    }

    static String[] toConfigModelsPluginDir(String configModelsPluginDirString) {
        return (String[])CloudConfigInstallVariables.multiValueParameterStream(configModelsPluginDirString).toArray(String[]::new);
    }

    private static Optional<String> getInstallVariable(String name) {
        return CloudConfigInstallVariables.getInstallVariable(name, Function.identity());
    }

    private static <T> Optional<T> getInstallVariable(String name, Function<String, T> converter) {
        return CloudConfigInstallVariables.getRawInstallVariable("cloudconfig_server." + name).map(converter);
    }

    private static Optional<String> getRawInstallVariable(String name) {
        return Optional.ofNullable(Optional.ofNullable(System.getenv(name.replace(".", "__"))).orElseGet(() -> System.getProperty(name)));
    }

    private static Stream<String> multiValueParameterStream(String param) {
        return Arrays.stream(param.split("[, ]")).filter(value -> !value.isEmpty());
    }
}

