/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.standalone;

import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.jpountz.lz4.LZ4FrameOutputStream;

public class LocalFileDb
implements FileAcquirer,
FileRegistry {
    private final Map<FileReference, File> fileReferenceToFile = new HashMap<FileReference, File>();
    private final Path appPath;

    public LocalFileDb(Path appPath) {
        this.appPath = appPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File waitFor(FileReference reference, long l, TimeUnit timeUnit) {
        LocalFileDb localFileDb = this;
        synchronized (localFileDb) {
            File file = this.fileReferenceToFile.get(reference);
            if (file == null) {
                throw new RuntimeException("Invalid file reference " + reference);
            }
            return file;
        }
    }

    public void shutdown() {
    }

    public FileReference addFile(String relativePath) {
        File file = this.appPath.resolve(relativePath).toFile();
        if (!file.exists()) {
            throw new RuntimeException("The file does not exist: " + file.getPath());
        }
        FileReference fileReference = new FileReference("LocalFileDb:" + relativePath);
        this.fileReferenceToFile.put(fileReference, file);
        return fileReference;
    }

    public List<FileRegistry.Entry> export() {
        return this.fileReferenceToFile.entrySet().stream().map(entry -> new FileRegistry.Entry(((File)entry.getValue()).getPath(), (FileReference)entry.getKey())).collect(Collectors.toList());
    }

    public FileReference addUri(String uri) {
        throw new RuntimeException("addUri(String uri) is not implemented here.");
    }

    public FileReference addBlob(String name, ByteBuffer blob) {
        this.writeBlob(blob, name);
        File file = this.appPath.resolve(name).toFile();
        FileReference fileReference = new FileReference("LocalFileDb:" + name);
        this.fileReferenceToFile.put(fileReference, file);
        return fileReference;
    }

    private void writeBlob(ByteBuffer blob, String relativePath) {
        try (FileOutputStream fos = new FileOutputStream(new File(this.appPath.toFile(), relativePath));){
            if (relativePath.endsWith(".lz4")) {
                LZ4FrameOutputStream lz4 = new LZ4FrameOutputStream((OutputStream)fos);
                lz4.write(blob.array(), blob.arrayOffset(), blob.remaining());
                lz4.close();
            } else {
                fos.write(blob.array(), blob.arrayOffset(), blob.remaining());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed writing temp file", e);
        }
    }
}

