/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.standalone;

import com.yahoo.vespa.model.container.configserver.option.CloudConfigOptions;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class CloudConfigInstallVariables
implements CloudConfigOptions {
    public Optional<Integer> rpcPort() {
        return CloudConfigInstallVariables.getInstallVariable("port_configserver_rpc", "services", Integer::parseInt);
    }

    public Optional<Boolean> multiTenant() {
        return CloudConfigInstallVariables.getInstallVariable("multitenant", Boolean::parseBoolean);
    }

    public CloudConfigOptions.ConfigServer[] allConfigServers() {
        return Optional.ofNullable(System.getenv("VESPA_CONFIGSERVERS")).map(Optional::of).orElseGet(() -> CloudConfigInstallVariables.getRawInstallVariable("services.addr_configserver")).map(CloudConfigInstallVariables::toConfigServers).orElseGet(() -> new CloudConfigOptions.ConfigServer[0]);
    }

    public Optional<Long> zookeeperBarrierTimeout() {
        return CloudConfigInstallVariables.getInstallVariable("zookeeper_barrier_timeout", Long::parseLong);
    }

    public Optional<Long> sessionLifeTimeSecs() {
        return CloudConfigInstallVariables.getInstallVariable("session_lifetime", Long::parseLong);
    }

    public String[] configModelPluginDirs() {
        return CloudConfigInstallVariables.getRawInstallVariable("cloudconfig_server.config_model_plugin_dirs").map(CloudConfigInstallVariables::toConfigModelsPluginDir).orElseGet(() -> new String[0]);
    }

    public Optional<Integer> zookeeperClientPort() {
        return CloudConfigInstallVariables.getInstallVariable("zookeeper_clientPort", Integer::parseInt);
    }

    public Optional<Integer> zookeeperQuorumPort() {
        return CloudConfigInstallVariables.getInstallVariable("zookeeper_quoromPort", Integer::parseInt);
    }

    public Optional<Integer> zookeeperElectionPort() {
        return CloudConfigInstallVariables.getInstallVariable("zookeeper_electionPort", Integer::parseInt);
    }

    public Optional<String> payloadCompressionType() {
        return CloudConfigInstallVariables.getInstallVariable("payload_compression_type", Function.identity());
    }

    public Optional<String> environment() {
        return CloudConfigInstallVariables.getInstallVariable("environment");
    }

    public Optional<String> region() {
        return CloudConfigInstallVariables.getInstallVariable("region");
    }

    public Optional<String> system() {
        return CloudConfigInstallVariables.getInstallVariable("system");
    }

    public Optional<String> defaultFlavor() {
        return CloudConfigInstallVariables.getInstallVariable("default_flavor");
    }

    public Optional<String> defaultAdminFlavor() {
        return CloudConfigInstallVariables.getInstallVariable("default_admin_flavor");
    }

    public Optional<String> defaultContainerFlavor() {
        return CloudConfigInstallVariables.getInstallVariable("default_container_flavor");
    }

    public Optional<String> defaultContentFlavor() {
        return CloudConfigInstallVariables.getInstallVariable("default_content_flavor");
    }

    public Optional<Boolean> useVespaVersionInRequest() {
        return CloudConfigInstallVariables.getInstallVariable("use_vespa_version_in_request", Boolean::parseBoolean);
    }

    public Optional<Boolean> hostedVespa() {
        return CloudConfigInstallVariables.getInstallVariable("hosted_vespa", Boolean::parseBoolean);
    }

    public Optional<Integer> numParallelTenantLoaders() {
        return CloudConfigInstallVariables.getInstallVariable("num_parallel_tenant_loaders", Integer::parseInt);
    }

    public Optional<String> loadBalancerAddress() {
        return CloudConfigInstallVariables.getInstallVariable("load_balancer_address");
    }

    static CloudConfigOptions.ConfigServer[] toConfigServers(String configserversString) {
        return (CloudConfigOptions.ConfigServer[])CloudConfigInstallVariables.multiValueParameterStream(configserversString).map(CloudConfigInstallVariables::toConfigServer).toArray(CloudConfigOptions.ConfigServer[]::new);
    }

    static CloudConfigOptions.ConfigServer toConfigServer(String configserverString) {
        try {
            String[] hostPortTuple = configserverString.split(":");
            if (configserverString.contains(":")) {
                return new CloudConfigOptions.ConfigServer(hostPortTuple[0], Optional.of(Integer.parseInt(hostPortTuple[1])));
            }
            return new CloudConfigOptions.ConfigServer(configserverString, Optional.empty());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid config server " + configserverString, e);
        }
    }

    static String[] toConfigModelsPluginDir(String configModelsPluginDirString) {
        return (String[])CloudConfigInstallVariables.multiValueParameterStream(configModelsPluginDirString).toArray(String[]::new);
    }

    private static Optional<String> getInstallVariable(String name) {
        return CloudConfigInstallVariables.getInstallVariable(name, Function.identity());
    }

    private static <T> Optional<T> getInstallVariable(String name, Function<String, T> converter) {
        return CloudConfigInstallVariables.getInstallVariable(name, "cloudconfig_server", converter);
    }

    private static <T> Optional<T> getInstallVariable(String name, String installPackage, Function<String, T> converter) {
        return CloudConfigInstallVariables.getRawInstallVariable(installPackage + "." + name).map(converter);
    }

    private static Optional<String> getRawInstallVariable(String name) {
        return Optional.ofNullable(Optional.ofNullable(System.getenv(name.replace(".", "__"))).orElseGet(() -> System.getProperty(name)));
    }

    private static Stream<String> multiValueParameterStream(String param) {
        return Arrays.stream(param.split("[, ]")).filter(value -> !value.isEmpty());
    }
}

