/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.standalone;

import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.yahoo.collections.CollectionUtil;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.application.api.RuleConfigDeriver;
import com.yahoo.config.model.ApplicationConfigProducerRoot;
import com.yahoo.config.model.ConfigModelRepo;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.config.model.application.provider.FilesApplicationPackage;
import com.yahoo.config.model.application.provider.StaticConfigDefinitionRepo;
import com.yahoo.config.model.builder.xml.ConfigModelId;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.standalone.CloudConfigYinstVariables;
import com.yahoo.container.standalone.Environment$;
import com.yahoo.container.standalone.StandaloneContainerApplication$DeprecationSuppressor$;
import com.yahoo.io.IOUtils;
import com.yahoo.text.XML;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerModel;
import com.yahoo.vespa.model.container.configserver.option.CloudConfigOptions;
import com.yahoo.vespa.model.container.xml.ConfigServerContainerModelBuilder;
import com.yahoo.vespa.model.container.xml.ContainerModelBuilder;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.w3c.dom.Element;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;

public final class StandaloneContainerApplication$ {
    public static final StandaloneContainerApplication$ MODULE$;
    private final String packageName;
    private final String applicationLocationYinstVariable;
    private final String deploymentProfileYinstVariable;
    private final Named applicationPathName;
    private final String disableNetworkingAnnotation;
    private final Named configModelRepoName;
    private final StaticConfigDefinitionRepo configDefinitionRepo;
    private final String defaultTmpBaseDir;
    private final String tmpDirName;

    static {
        new StandaloneContainerApplication$();
    }

    public String packageName() {
        return this.packageName;
    }

    public String applicationLocationYinstVariable() {
        return this.applicationLocationYinstVariable;
    }

    public String deploymentProfileYinstVariable() {
        return this.deploymentProfileYinstVariable;
    }

    public Named applicationPathName() {
        return this.applicationPathName;
    }

    public String disableNetworkingAnnotation() {
        return this.disableNetworkingAnnotation;
    }

    public Named configModelRepoName() {
        return this.configModelRepoName;
    }

    public StaticConfigDefinitionRepo configDefinitionRepo() {
        return this.configDefinitionRepo;
    }

    public String defaultTmpBaseDir() {
        return this.defaultTmpBaseDir;
    }

    public String tmpDirName() {
        return this.tmpDirName;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T com$yahoo$container$standalone$StandaloneContainerApplication$$withTempDir(Function1<File, T> f) {
        Object object;
        File tmpDir = this.createTempDir();
        try {
            object = f.apply((Object)tmpDir);
        }
        catch (Throwable throwable) {
            void var2_2;
            IOUtils.recursiveDeleteDir((File)var2_2);
            throw throwable;
        }
        IOUtils.recursiveDeleteDir((File)tmpDir);
        return (T)object;
    }

    private File createTempDir() {
        Path basePath = this.getBaseDir$1();
        Path tmpDir = Files.createTempDirectory(basePath, this.tmpDirName(), new FileAttribute[0]);
        return tmpDir.toFile();
    }

    private void validateApplication(ApplicationPackage applicationPackage) {
        try {
            applicationPackage.validateXML();
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
    }

    public ContainerModelBuilder newContainerModelBuilder(ContainerModelBuilder.Networking networkingOption) {
        Option<String> option;
        block4: {
            ContainerModelBuilder containerModelBuilder;
            block3: {
                Some some;
                String string;
                block2: {
                    option = Environment$.MODULE$.optionalYinstVariable(this.deploymentProfileYinstVariable());
                    if (!None$.MODULE$.equals(option)) break block2;
                    containerModelBuilder = new ContainerModelBuilder(true, networkingOption);
                    break block3;
                }
                if (!(option instanceof Some) || !"configserver".equals(string = (String)(some = (Some)option).x())) break block4;
                containerModelBuilder = new ConfigServerContainerModelBuilder((CloudConfigOptions)new CloudConfigYinstVariables());
            }
            return containerModelBuilder;
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid deployment profile '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{option})));
    }

    public Tuple2<VespaModel, Container> createContainerModel(Path applicationPath, FileRegistry fileRegistry, File preprocessedApplicationDir, ContainerModelBuilder.Networking networkingOption, ConfigModelRepo configModelRepo) {
        BaseDeployLogger logger = new BaseDeployLogger();
        FilesApplicationPackage rawApplicationPackage = new FilesApplicationPackage.Builder(applicationPath.toFile()).includeSourceFiles(true).preprocessedDir(preprocessedApplicationDir).build();
        ApplicationPackage applicationPackage = rawApplicationPackage.preprocess(Zone.defaultZone(), new RuleConfigDeriver(){

            public void derive(String ruleBaseDir, String outputDir) {
            }
        }, (DeployLogger)logger);
        this.validateApplication(applicationPackage);
        DeployState deployState = new DeployState.Builder().applicationPackage(applicationPackage).fileRegistry(fileRegistry).deployLogger((DeployLogger)logger).configDefinitionRepo((ConfigDefinitionRepo)this.configDefinitionRepo()).build();
        VespaModel root = VespaModel.createIncomplete((DeployState)deployState);
        ApplicationConfigProducerRoot vespaRoot = new ApplicationConfigProducerRoot((AbstractConfigProducer)root, "vespa", deployState.getDocumentModel(), deployState.getProperties().vespaVersion(), deployState.getProperties().applicationId());
        Element spec = this.containerRootElement(applicationPackage);
        ContainerModel containerModel = (ContainerModel)this.newContainerModelBuilder(networkingOption).build(deployState, configModelRepo, (AbstractConfigProducer)vespaRoot, spec);
        containerModel.getCluster().prepare();
        StandaloneContainerApplication$DeprecationSuppressor$.MODULE$.initializeContainerModel(containerModel, configModelRepo);
        Container container = (Container)CollectionUtil.first((Collection)containerModel.getCluster().getContainers());
        container.setRpcServerEnabled(false);
        ContainerModelBuilder.Networking networking = networkingOption;
        ContainerModelBuilder.Networking networking2 = ContainerModelBuilder.Networking.enable;
        container.setHttpServerEnabled(!(networking != null ? !networking.equals(networking2) : networking2 != null));
        this.initializeContainer(container, spec);
        root.freezeModelTopology();
        return new Tuple2((Object)root, (Object)container);
    }

    public ConfigModelRepo createContainerModel$default$5() {
        return new ConfigModelRepo();
    }

    public void initializeContainer(Container container, Element spec) {
        HostResource host = container.getRoot().getHostSystem().getHost("default_singlenode_container");
        container.setBasePort(VespaDomBuilder.getXmlWantedPort((Element)spec));
        container.setHostResource(host);
        container.initService();
    }

    public Element getJDiscInServices(Element element) {
        Buffer jDiscElements = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ContainerModelBuilder.configModelIds).asScala()).flatMap((Function1)new Serializable(element){
            private final Element element$1;

            public final Buffer<Element> apply(ConfigModelId name) {
                return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(XML.getChildren((Element)this.element$1, (String)name.getName())).asScala();
            }
            {
                this.element$1 = element$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        List list = jDiscElements.toList();
        Some some = List$.MODULE$.unapplySeq((Seq)list);
        if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0) {
            Element e;
            Element element2 = e = (Element)((LinearSeqOptimized)some.get()).apply(0);
            return element2;
        }
        if (Nil$.MODULE$.equals(list)) {
            throw new RuntimeException("No jdisc element found under services.");
        }
        if (list != null) {
            List list2 = list;
            throw new RuntimeException(new StringBuilder().append((Object)"Found multiple JDisc elements: ").append((Object)this.nameAndId$1(list2).mkString(", ")).toString());
        }
        throw new MatchError((Object)list);
    }

    public Element containerRootElement(ApplicationPackage applicationPackage) {
        Element element = XmlHelper.getDocument((Reader)applicationPackage.getServices()).getDocumentElement();
        String nodeName = element.getNodeName();
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ContainerModelBuilder.configModelIds).asScala()).map((Function1)new Serializable(){

            public final String apply(ConfigModelId x$2) {
                return x$2.getName();
            }
        }, Buffer$.MODULE$.canBuildFrom())).contains((Object)nodeName) ? element : this.getJDiscInServices(element);
    }

    public Path path(String s) {
        return FileSystems.getDefault().getPath(s, new String[0]);
    }

    private final Path getBaseDir$1() {
        String tmpBaseDir = new File(this.defaultTmpBaseDir()).exists() ? this.defaultTmpBaseDir() : System.getProperty("java.io.tmpdir");
        return Paths.get(tmpBaseDir, new String[0]);
    }

    private final List nameAndId$1(List elements) {
        return (List)elements.map((Function1)new Serializable(){

            public final String apply(Element e) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " id='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getNodeName(), e.getAttribute("id")}));
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private StandaloneContainerApplication$() {
        MODULE$ = this;
        this.packageName = "standalone_jdisc_container";
        this.applicationLocationYinstVariable = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".app_location"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.packageName()}));
        this.deploymentProfileYinstVariable = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".deployment_profile"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.packageName()}));
        this.applicationPathName = Names.named((String)this.applicationLocationYinstVariable());
        this.disableNetworkingAnnotation = "JDisc.disableNetworking";
        this.configModelRepoName = Names.named((String)"ConfigModelRepo");
        this.configDefinitionRepo = new StaticConfigDefinitionRepo();
        this.defaultTmpBaseDir = Defaults.getDefaults().underVespaHome("tmp");
        this.tmpDirName = "standalone_container";
    }
}

