/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.standalone;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.yahoo.container.standalone.StandaloneContainerApplication;
import com.yahoo.jdisc.application.ContainerActivator;
import com.yahoo.jdisc.application.ContainerBuilder;
import com.yahoo.jdisc.application.DeactivatedContainer;
import com.yahoo.jdisc.application.OsgiFramework;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.vespa.model.ConfigProducer;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import com.yahoo.vespa.model.container.http.Http;
import com.yahoo.vespa.model.container.http.JettyHttpServer;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.FileChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class StandaloneContainerActivator
implements BundleActivator {
    public void start(BundleContext bundleContext) throws Exception {
        Container container = this.getContainer(new Module[0]);
        List<ConnectorConfig> connectorConfigs = this.getConnectorConfigs(container);
        Stream<Path> keyStorePaths = this.getKeyStorePaths(connectorConfigs);
        Map<Path, FileChannel> fileChannels = this.openFiles(keyStorePaths);
        this.registerKeyStoreFileChannels(bundleContext, fileChannels);
        for (ConnectorConfig config2 : connectorConfigs) {
            ServerSocketChannel socketChannel = this.bindChannel(config2);
            this.registerChannels(bundleContext, config2.listenPort(), socketChannel);
        }
    }

    private void registerKeyStoreFileChannels(BundleContext bundleContext, Map<Path, FileChannel> fileChannels) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("role", "com.yahoo.container.standalone.StandaloneContainerActivator.KeyStoreFileChannels");
        bundleContext.registerService(Map.class, Collections.unmodifiableMap(fileChannels), properties);
    }

    private Map<Path, FileChannel> openFiles(Stream<Path> keyStorePaths) {
        return keyStorePaths.collect(Collectors.toMap(Function.identity(), StandaloneContainerActivator::getFileChannel));
    }

    private static FileChannel getFileChannel(Path path) {
        try {
            FileInputStream inputStream = new FileInputStream(path.toFile());
            return inputStream.getChannel();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed opening path " + path, e);
        }
    }

    private Stream<Path> getKeyStorePaths(List<ConnectorConfig> connectorConfigs) {
        return connectorConfigs.stream().map(ConnectorConfig::ssl).flatMap(StandaloneContainerActivator::getKeyStorePaths);
    }

    private static Stream<Path> getKeyStorePaths(ConnectorConfig.Ssl ssl) {
        Stream<String> paths = Stream.of(ssl.keyStorePath(), ssl.pemKeyStore().certificatePath(), ssl.pemKeyStore().keyPath());
        return paths.filter(path -> !path.isEmpty()).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    void registerChannels(BundleContext bundleContext, int listenPort, ServerSocketChannel boundChannel) {
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        properties.put("port", listenPort);
        bundleContext.registerService(ServerSocketChannel.class, (Object)boundChannel, properties);
    }

    ServerSocketChannel bindChannel(ConnectorConfig channelInfo) throws IOException {
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        InetSocketAddress bindAddress = new InetSocketAddress(channelInfo.listenPort());
        serverChannel.socket().bind(bindAddress, channelInfo.acceptQueueSize());
        return serverChannel;
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }

    Container getContainer(Module ... modules) {
        ActivatorModule activatorModule = new ActivatorModule();
        ArrayList<Module> allModules = new ArrayList<Module>();
        allModules.addAll(Arrays.asList(modules));
        allModules.add(activatorModule);
        StandaloneContainerApplication app = new StandaloneContainerApplication(Guice.createInjector((Module[])new Module[]{Modules.combine(allModules)}));
        return app.container();
    }

    List<ConnectorConfig> getConnectorConfigs(Container container) {
        Http http = container.getHttp();
        return http == null ? StandaloneContainerActivator.getConnectorConfigs(container.getDefaultHttpServer()) : StandaloneContainerActivator.getConnectorConfigs(http.getHttpServer());
    }

    private static List<ConnectorConfig> getConnectorConfigs(JettyHttpServer jettyHttpServer) {
        if (jettyHttpServer == null) {
            return Collections.emptyList();
        }
        return jettyHttpServer.getConnectorFactories().stream().map(StandaloneContainerActivator::getConnectorConfig).collect(Collectors.toList());
    }

    private static ConnectorConfig getConnectorConfig(ConnectorFactory connectorFactory) {
        return (ConnectorConfig)VespaModel.getConfig(ConnectorConfig.class, (ConfigProducer)connectorFactory);
    }

    public static class DummyOsgiFramework
    implements OsgiFramework {
        public List<Bundle> installBundle(String bundleLocation) {
            throw new UnsupportedOperationException();
        }

        public void startBundles(List<Bundle> bundles, boolean privileged) {
            throw new UnsupportedOperationException();
        }

        public void refreshPackages() {
            throw new UnsupportedOperationException();
        }

        public BundleContext bundleContext() {
            return null;
        }

        public List<Bundle> bundles() {
            return Collections.emptyList();
        }

        public void start() {
        }

        public void stop() {
        }
    }

    private static class DummyActivatorForStandaloneContainerApp
    implements ContainerActivator {
        private DummyActivatorForStandaloneContainerApp() {
        }

        public ContainerBuilder newContainerBuilder() {
            return new ContainerBuilder(new ArrayList());
        }

        public DeactivatedContainer activateContainer(ContainerBuilder builder) {
            return new DeactivatedContainer(){

                public Object appContext() {
                    return new Object();
                }

                public void notifyTermination(Runnable task) {
                }
            };
        }
    }

    private static class ActivatorModule
    implements Module {
        private ActivatorModule() {
        }

        public void configure(Binder binder) {
            binder.bind(OsgiFramework.class).toInstance((Object)new DummyOsgiFramework());
            binder.bind(ContainerActivator.class).toInstance((Object)new DummyActivatorForStandaloneContainerApp());
        }
    }
}

