/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import java.nio.ByteBuffer;
import java.util.Base64;

public record SealedSharedKey(int keyId, byte[] enc, byte[] ciphertext) {
    public static final int CURRENT_TOKEN_VERSION = 1;
    private static final int MAX_ENC_CONTEXT_LENGTH = Short.MAX_VALUE;

    public String toTokenString() {
        if (this.keyId >= 0x1000000) {
            throw new IllegalArgumentException("Key id is too large to be encoded");
        }
        if (this.enc.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Encryption context is too large to be encoded");
        }
        ByteBuffer encoded = ByteBuffer.allocate(6 + this.enc.length + this.ciphertext.length);
        encoded.putInt(0x1000000 | this.keyId);
        encoded.putShort((short)this.enc.length);
        encoded.put(this.enc);
        encoded.put(this.ciphertext);
        encoded.flip();
        byte[] encBytes = new byte[encoded.remaining()];
        encoded.get(encBytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(encBytes);
    }

    public static SealedSharedKey fromTokenString(String tokenString) {
        byte[] rawTokenBytes = Base64.getUrlDecoder().decode(tokenString);
        if (rawTokenBytes.length < 4) {
            throw new IllegalArgumentException("Decoded token too small to contain a header");
        }
        ByteBuffer decoded = ByteBuffer.wrap(rawTokenBytes);
        int versionAndKeyId = decoded.getInt();
        int version = versionAndKeyId >>> 24;
        if (version != 1) {
            throw new IllegalArgumentException("Token had unexpected version. Expected %d, was %d".formatted(1, version));
        }
        short encLen = decoded.getShort();
        if (encLen <= 0) {
            throw new IllegalArgumentException("Token encryption context does not have a valid length");
        }
        byte[] enc = new byte[encLen];
        decoded.get(enc);
        byte[] ciphertext = new byte[decoded.remaining()];
        decoded.get(ciphertext);
        int keyId = versionAndKeyId & 0xFFFFFF;
        return new SealedSharedKey(keyId, enc, ciphertext);
    }
}

