/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.util.Optional;

public enum KeyAlgorithm {
    RSA("RSA", null),
    EC("EC", new ECGenParameterSpec("prime256v1")),
    XDH("XDH", new ECGenParameterSpec("X25519"));

    final String algorithmName;
    private final AlgorithmParameterSpec spec;

    private KeyAlgorithm(String algorithmName, AlgorithmParameterSpec spec) {
        this.algorithmName = algorithmName;
        this.spec = spec;
    }

    String getAlgorithmName() {
        return this.algorithmName;
    }

    Optional<AlgorithmParameterSpec> getSpec() {
        return Optional.ofNullable(this.spec);
    }

    public static KeyAlgorithm from(String name) {
        for (KeyAlgorithm algorithm : KeyAlgorithm.values()) {
            if (name.equals(algorithm.getAlgorithmName())) {
                return algorithm;
            }
            if (algorithm != XDH || !name.equals("X25519")) continue;
            return algorithm;
        }
        throw new IllegalArgumentException("Unknown key algorithm '" + name + "'");
    }
}

