/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls.policy;

import com.yahoo.security.tls.policy.Capability;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class CapabilitySet {
    private static final CapabilitySet ALL_CAPABILITIES = new CapabilitySet(EnumSet.allOf(Capability.class));
    private static final CapabilitySet NO_CAPABILITIES = new CapabilitySet(EnumSet.noneOf(Capability.class));
    private final EnumSet<Capability> caps;

    private CapabilitySet(EnumSet<Capability> caps) {
        this.caps = caps;
    }

    public static CapabilitySet fromNames(Collection<String> names) {
        EnumSet<Capability> caps = EnumSet.noneOf(Capability.class);
        for (String name : names) {
            Predefined predefined = Predefined.fromName(name).orElse(null);
            if (predefined != null) {
                caps.addAll(predefined.caps);
                continue;
            }
            caps.add(Capability.fromName(name));
        }
        return new CapabilitySet(caps);
    }

    public static CapabilitySet from(EnumSet<Capability> caps) {
        return new CapabilitySet(EnumSet.copyOf(caps));
    }

    public static CapabilitySet from(Collection<Capability> caps) {
        return new CapabilitySet(EnumSet.copyOf(caps));
    }

    public static CapabilitySet from(Capability ... caps) {
        return new CapabilitySet(EnumSet.copyOf(List.of(caps)));
    }

    public static CapabilitySet all() {
        return ALL_CAPABILITIES;
    }

    public static CapabilitySet none() {
        return NO_CAPABILITIES;
    }

    public boolean hasAllCapabilities() {
        return this.caps.equals(CapabilitySet.ALL_CAPABILITIES.caps);
    }

    public SortedSet<String> toCapabilityNames() {
        return this.caps.stream().map(Capability::asString).collect(Collectors.toCollection(TreeSet::new));
    }

    public String toString() {
        return "CapabilitySet{caps=" + this.caps + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapabilitySet that = (CapabilitySet)o;
        return Objects.equals(this.caps, that.caps);
    }

    public int hashCode() {
        return Objects.hash(this.caps);
    }

    public static enum Predefined {
        CONTENT_NODE("vespa.content_node", Capability.CONTENT__STORAGE_API, Capability.CONTENT__DOCUMENT_API, Capability.SLOBROK__API),
        CONTAINER_NODE("vespa.container_node", Capability.CONTENT__DOCUMENT_API, Capability.CONTENT__SEARCH_API, Capability.SLOBROK__API),
        TELEMETRY("vespa.telemetry", Capability.CONTENT__STATUS_PAGES, Capability.CONTENT__METRICS_API),
        CLUSTER_CONTROLLER_NODE("vespa.cluster_controller_node", Capability.CONTENT__CLUSTER_CONTROLLER__INTERNAL_STATE_API, Capability.SLOBROK__API),
        CONFIG_SERVER("vespa.config_server", new Capability[0]);

        private final String name;
        private final EnumSet<Capability> caps;

        private Predefined(String name, Capability ... caps) {
            this.name = name;
            this.caps = caps.length == 0 ? EnumSet.noneOf(Capability.class) : EnumSet.copyOf(List.of(caps));
        }

        public static Optional<Predefined> fromName(String name) {
            return Arrays.stream(Predefined.values()).filter(p -> p.name.equals(name)).findAny();
        }
    }
}

