/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.token;

import com.yahoo.security.ArrayUtils;
import java.util.Arrays;

public record TokenDomain(byte[] fingerprintContext, byte[] checkHashContext) {
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenDomain that = (TokenDomain)o;
        return Arrays.equals(this.fingerprintContext, that.fingerprintContext) && Arrays.equals(this.checkHashContext, that.checkHashContext);
    }

    @Override
    public int hashCode() {
        int result = Arrays.hashCode(this.fingerprintContext);
        result = 31 * result + Arrays.hashCode(this.checkHashContext);
        return result;
    }

    @Override
    public String toString() {
        return "'%s'/'%s'".formatted(ArrayUtils.fromUtf8Bytes(this.fingerprintContext), ArrayUtils.fromUtf8Bytes(this.checkHashContext));
    }

    public static TokenDomain of(String fingerprintContext, String checkHashContext) {
        return new TokenDomain(ArrayUtils.toUtf8Bytes(fingerprintContext), ArrayUtils.toUtf8Bytes(checkHashContext));
    }
}

