/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security;

import com.yahoo.security.Base62;
import com.yahoo.security.KeyId;
import java.nio.ByteBuffer;

public record SealedSharedKey(int version, KeyId keyId, byte[] enc, byte[] ciphertext) {
    public static final int CURRENT_TOKEN_VERSION = 2;
    public static final int MAX_ENC_CONTEXT_LENGTH = 255;
    public static final int MAX_TOKEN_STRING_LENGTH = 512;

    public SealedSharedKey {
        if (enc.length > 255) {
            throw new IllegalArgumentException("Encryption context is too large to be encoded (max is %d, got %d)".formatted(255, enc.length));
        }
    }

    public String toTokenString() {
        return Base62.codec().encode(this.toSerializedBytes());
    }

    byte[] toSerializedBytes() {
        byte[] keyIdBytes = this.keyId.asBytes();
        ByteBuffer encoded = ByteBuffer.allocate(2 + keyIdBytes.length + 1 + this.enc.length + this.ciphertext.length);
        encoded.put((byte)this.version);
        encoded.put((byte)keyIdBytes.length);
        encoded.put(keyIdBytes);
        encoded.put((byte)this.enc.length);
        encoded.put(this.enc);
        encoded.put(this.ciphertext);
        encoded.flip();
        byte[] encBytes = new byte[encoded.remaining()];
        encoded.get(encBytes);
        return encBytes;
    }

    public static SealedSharedKey fromTokenString(String tokenString) {
        SealedSharedKey.verifyInputTokenStringNotTooLarge(tokenString);
        byte[] rawTokenBytes = Base62.codec().decode(tokenString);
        return SealedSharedKey.fromSerializedBytes(rawTokenBytes);
    }

    static SealedSharedKey fromSerializedBytes(byte[] rawTokenBytes) {
        if (rawTokenBytes.length < 1) {
            throw new IllegalArgumentException("Decoded token too small to contain a version");
        }
        ByteBuffer decoded = ByteBuffer.wrap(rawTokenBytes);
        int version = Byte.toUnsignedInt(decoded.get());
        if (version < 1 || version > 2) {
            throw new IllegalArgumentException("Token had unexpected version. Expected value in [1, %d], was %d".formatted(2, version));
        }
        int keyIdLen = Byte.toUnsignedInt(decoded.get());
        byte[] keyIdBytes = new byte[keyIdLen];
        decoded.get(keyIdBytes);
        int encLen = Byte.toUnsignedInt(decoded.get());
        byte[] enc = new byte[encLen];
        decoded.get(enc);
        byte[] ciphertext = new byte[decoded.remaining()];
        decoded.get(ciphertext);
        return new SealedSharedKey(version, KeyId.ofBytes(keyIdBytes), enc, ciphertext);
    }

    public int tokenVersion() {
        return this.version;
    }

    private static void verifyInputTokenStringNotTooLarge(String tokenString) {
        if (tokenString.length() > 512) {
            throw new IllegalArgumentException("Token string is too long to possibly be a valid token");
        }
    }
}

