/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.security.KeyStoreBuilder;
import com.yahoo.security.KeyStoreType;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.SslContextBuilder;
import com.yahoo.security.X509CertificateUtils;
import com.yahoo.security.tls.AuthorizationMode;
import com.yahoo.security.tls.DefaultTlsContext;
import com.yahoo.security.tls.HostnameVerification;
import com.yahoo.security.tls.MutableX509KeyManager;
import com.yahoo.security.tls.MutableX509TrustManager;
import com.yahoo.security.tls.PeerAuthentication;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.TransportSecurityOptions;
import com.yahoo.security.tls.authz.PeerAuthorizerTrustManager;
import com.yahoo.security.tls.policy.AuthorizedPeers;
import com.yahoo.security.tls.policy.PeerPolicy;
import com.yahoo.vespa.jdk8compat.Files;
import com.yahoo.vespa.jdk8compat.Set;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.security.KeyStore;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class ConfigFileBasedTlsContext
implements TlsContext {
    private static final Duration UPDATE_PERIOD = Duration.ofHours(1L);
    private static final Logger log = Logger.getLogger(ConfigFileBasedTlsContext.class.getName());
    private final TlsContext tlsContext;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ReloaderThreadFactory());

    public ConfigFileBasedTlsContext(Path tlsOptionsConfigFile, AuthorizationMode mode) {
        this(tlsOptionsConfigFile, mode, PeerAuthentication.NEED);
    }

    public ConfigFileBasedTlsContext(Path tlsOptionsConfigFile, AuthorizationMode mode, PeerAuthentication peerAuthentication) {
        TransportSecurityOptions options = TransportSecurityOptions.fromJsonFile(tlsOptionsConfigFile);
        MutableX509TrustManager trustManager = new MutableX509TrustManager();
        MutableX509KeyManager keyManager = new MutableX509KeyManager();
        ConfigFileBasedTlsContext.reloadTrustManager(options, trustManager);
        ConfigFileBasedTlsContext.reloadKeyManager(options, keyManager);
        this.tlsContext = ConfigFileBasedTlsContext.createDefaultTlsContext(options, mode, trustManager, keyManager, peerAuthentication);
        this.scheduler.scheduleAtFixedRate(new CryptoMaterialReloader(tlsOptionsConfigFile, this.scheduler, trustManager, keyManager), UPDATE_PERIOD.getSeconds(), UPDATE_PERIOD.getSeconds(), TimeUnit.SECONDS);
    }

    private static void reloadTrustManager(TransportSecurityOptions options, MutableX509TrustManager trustManager) {
        if (options.getCaCertificatesFile().isPresent()) {
            trustManager.updateTruststore(ConfigFileBasedTlsContext.loadTruststore(options.getCaCertificatesFile().get()));
        } else {
            trustManager.useDefaultTruststore();
        }
    }

    private static void reloadKeyManager(TransportSecurityOptions options, MutableX509KeyManager keyManager) {
        if (options.getPrivateKeyFile().isPresent() && options.getCertificatesFile().isPresent()) {
            keyManager.updateKeystore(ConfigFileBasedTlsContext.loadKeystore(options.getPrivateKeyFile().get(), options.getCertificatesFile().get()), new char[0]);
        } else {
            keyManager.useDefaultKeystore();
        }
    }

    private static KeyStore loadTruststore(Path caCertificateFile) {
        try {
            return KeyStoreBuilder.withType(KeyStoreType.PKCS12).withCertificateEntries("cert", X509CertificateUtils.certificateListFromPem(Files.readString(caCertificateFile))).build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static KeyStore loadKeystore(Path privateKeyFile, Path certificatesFile) {
        try {
            return KeyStoreBuilder.withType(KeyStoreType.PKCS12).withKeyEntry("default", KeyUtils.fromPemEncodedPrivateKey(Files.readString(privateKeyFile)), X509CertificateUtils.certificateListFromPem(Files.readString(certificatesFile))).build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static DefaultTlsContext createDefaultTlsContext(TransportSecurityOptions options, AuthorizationMode mode, MutableX509TrustManager mutableTrustManager, MutableX509KeyManager mutableKeyManager, PeerAuthentication peerAuthentication) {
        HostnameVerification hostnameVerification = options.isHostnameValidationDisabled() ? HostnameVerification.DISABLED : HostnameVerification.ENABLED;
        PeerAuthorizerTrustManager authorizerTrustManager = options.getAuthorizedPeers().map(authorizedPeers -> new PeerAuthorizerTrustManager((AuthorizedPeers)authorizedPeers, mode, hostnameVerification, mutableTrustManager)).orElseGet(() -> new PeerAuthorizerTrustManager(new AuthorizedPeers(Set.of(new PeerPolicy[0])), AuthorizationMode.DISABLE, hostnameVerification, mutableTrustManager));
        SSLContext sslContext = new SslContextBuilder().withKeyManager(mutableKeyManager).withTrustManager(authorizerTrustManager).build();
        List<String> acceptedCiphers = options.getAcceptedCiphers();
        HashSet<String> ciphers = acceptedCiphers.isEmpty() ? TlsContext.ALLOWED_CIPHER_SUITES : new HashSet<String>(acceptedCiphers);
        List<String> acceptedProtocols = options.getAcceptedProtocols();
        HashSet<String> protocols = acceptedProtocols.isEmpty() ? TlsContext.ALLOWED_PROTOCOLS : new HashSet<String>(acceptedProtocols);
        return new DefaultTlsContext(sslContext, ciphers, protocols, peerAuthentication);
    }

    @Override
    public SSLContext context() {
        return this.tlsContext.context();
    }

    @Override
    public SSLParameters parameters() {
        return this.tlsContext.parameters();
    }

    @Override
    public SSLEngine createSslEngine() {
        return this.tlsContext.createSslEngine();
    }

    @Override
    public SSLEngine createSslEngine(String peerHost, int peerPort) {
        return this.tlsContext.createSslEngine(peerHost, peerPort);
    }

    @Override
    public void close() {
        try {
            this.scheduler.shutdownNow();
            if (!this.scheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Unable to shutdown executor before timeout");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ReloaderThreadFactory
    implements ThreadFactory {
        private ReloaderThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "tls-context-reloader");
            thread.setDaemon(true);
            return thread;
        }
    }

    private static class CryptoMaterialReloader
    implements Runnable {
        final Path tlsOptionsConfigFile;
        final ScheduledExecutorService scheduler;
        final MutableX509TrustManager trustManager;
        final MutableX509KeyManager keyManager;

        CryptoMaterialReloader(Path tlsOptionsConfigFile, ScheduledExecutorService scheduler, MutableX509TrustManager trustManager, MutableX509KeyManager keyManager) {
            this.tlsOptionsConfigFile = tlsOptionsConfigFile;
            this.scheduler = scheduler;
            this.trustManager = trustManager;
            this.keyManager = keyManager;
        }

        @Override
        public void run() {
            try {
                if (this.trustManager == null && this.keyManager == null) {
                    this.scheduler.shutdown();
                    return;
                }
                TransportSecurityOptions options = TransportSecurityOptions.fromJsonFile(this.tlsOptionsConfigFile);
                if (this.trustManager != null) {
                    ConfigFileBasedTlsContext.reloadTrustManager(options, this.trustManager);
                }
                if (this.keyManager != null) {
                    ConfigFileBasedTlsContext.reloadKeyManager(options, this.keyManager);
                }
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, String.format("Failed to reload crypto material (path='%s'): %s", this.tlsOptionsConfigFile, t.getMessage()), t);
            }
        }
    }
}

