/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.security.tls.json.TransportSecurityOptionsJsonSerializer;
import com.yahoo.security.tls.policy.AuthorizedPeers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

public class TransportSecurityOptions {
    private final Path privateKeyFile;
    private final Path certificatesFile;
    private final Path caCertificatesFile;
    private final AuthorizedPeers authorizedPeers;

    private TransportSecurityOptions(Builder builder) {
        this.privateKeyFile = builder.privateKeyFile;
        this.certificatesFile = builder.certificatesFile;
        this.caCertificatesFile = builder.caCertificatesFile;
        this.authorizedPeers = builder.authorizedPeers;
    }

    public Optional<Path> getPrivateKeyFile() {
        return Optional.ofNullable(this.privateKeyFile);
    }

    public Optional<Path> getCertificatesFile() {
        return Optional.ofNullable(this.certificatesFile);
    }

    public Optional<Path> getCaCertificatesFile() {
        return Optional.ofNullable(this.caCertificatesFile);
    }

    public Optional<AuthorizedPeers> getAuthorizedPeers() {
        return Optional.ofNullable(this.authorizedPeers);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TransportSecurityOptions fromJsonFile(Path file) {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            TransportSecurityOptions transportSecurityOptions = new TransportSecurityOptionsJsonSerializer().deserialize(in);
            return transportSecurityOptions;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static TransportSecurityOptions fromJson(String json) {
        return new TransportSecurityOptionsJsonSerializer().deserialize(new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)));
    }

    public String toJson() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new TransportSecurityOptionsJsonSerializer().serialize(out, this);
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }

    public void toJsonFile(Path file) {
        try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
            new TransportSecurityOptionsJsonSerializer().serialize(out, this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return "TransportSecurityOptions{privateKeyFile=" + this.privateKeyFile + ", certificatesFile=" + this.certificatesFile + ", caCertificatesFile=" + this.caCertificatesFile + ", authorizedPeers=" + this.authorizedPeers + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportSecurityOptions that = (TransportSecurityOptions)o;
        return Objects.equals(this.privateKeyFile, that.privateKeyFile) && Objects.equals(this.certificatesFile, that.certificatesFile) && Objects.equals(this.caCertificatesFile, that.caCertificatesFile) && Objects.equals(this.authorizedPeers, that.authorizedPeers);
    }

    public int hashCode() {
        return Objects.hash(this.privateKeyFile, this.certificatesFile, this.caCertificatesFile, this.authorizedPeers);
    }

    public static class Builder {
        private Path privateKeyFile;
        private Path certificatesFile;
        private Path caCertificatesFile;
        private AuthorizedPeers authorizedPeers;

        public Builder withCertificates(Path certificatesFile, Path privateKeyFile) {
            this.certificatesFile = certificatesFile;
            this.privateKeyFile = privateKeyFile;
            return this;
        }

        public Builder withCaCertificates(Path caCertificatesFile) {
            this.caCertificatesFile = caCertificatesFile;
            return this;
        }

        public Builder withAuthorizedPeers(AuthorizedPeers authorizedPeers) {
            this.authorizedPeers = authorizedPeers;
            return this;
        }

        public TransportSecurityOptions build() {
            return new TransportSecurityOptions(this);
        }
    }
}

