/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.yahoo.security.tls.AuthorizationMode;
import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TransportSecurityOptions;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public class TransportSecurityUtils {
    public static final String CONFIG_FILE_ENVIRONMENT_VARIABLE = "VESPA_TLS_CONFIG_FILE";
    public static final String INSECURE_MIXED_MODE_ENVIRONMENT_VARIABLE = "VESPA_TLS_INSECURE_MIXED_MODE";
    public static final String INSECURE_AUTHORIZATION_MODE_ENVIRONMENT_VARIABLE = "VESPA_TLS_INSECURE_AUTHORIZATION_MODE";

    private TransportSecurityUtils() {
    }

    public static boolean isTransportSecurityEnabled() {
        return TransportSecurityUtils.getConfigFile().isPresent();
    }

    public static boolean isInsecureMixedModeEnabled() {
        return TransportSecurityUtils.getInsecureMixedMode().isPresent();
    }

    public static Optional<MixedMode> getInsecureMixedMode() {
        if (!TransportSecurityUtils.isTransportSecurityEnabled()) {
            return Optional.empty();
        }
        return TransportSecurityUtils.getEnvironmentVariable(INSECURE_MIXED_MODE_ENVIRONMENT_VARIABLE).map(MixedMode::fromConfigValue);
    }

    public static Optional<AuthorizationMode> getInsecureAuthorizationMode() {
        if (!TransportSecurityUtils.isInsecureMixedModeEnabled()) {
            return Optional.empty();
        }
        return TransportSecurityUtils.getEnvironmentVariable(INSECURE_AUTHORIZATION_MODE_ENVIRONMENT_VARIABLE).map(AuthorizationMode::fromConfigValue);
    }

    public static Optional<Path> getConfigFile() {
        return TransportSecurityUtils.getEnvironmentVariable(CONFIG_FILE_ENVIRONMENT_VARIABLE).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public static Optional<TransportSecurityOptions> getOptions() {
        return TransportSecurityUtils.getConfigFile().map(TransportSecurityOptions::fromJsonFile);
    }

    private static Optional<String> getEnvironmentVariable(String environmentVariable) {
        return Optional.ofNullable(System.getenv(environmentVariable)).filter(var -> !var.isEmpty());
    }
}

