/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.yahoo.api.annotations.Beta;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleCompatibleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.Function;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;

@Beta
public class TensorValue
extends Value {
    private final Tensor value;

    public TensorValue(Tensor value) {
        this.value = value;
    }

    @Override
    public TensorType type() {
        return this.value.type();
    }

    @Override
    public double asDouble() {
        if (this.hasDouble()) {
            return this.value.get(TensorAddress.of((long[])new long[0]));
        }
        throw new UnsupportedOperationException("Requires a double value, but " + this.value + " cannot be used as a double");
    }

    @Override
    public boolean hasDouble() {
        return this.value.type().dimensions().isEmpty() && !this.value.isEmpty();
    }

    @Override
    public boolean asBoolean() {
        if (this.hasDouble()) {
            return this.asDouble() != 0.0;
        }
        throw new UnsupportedOperationException("Tensor does not have a value that can be converted to a boolean");
    }

    @Override
    public Value negate() {
        return new TensorValue(this.value.map(value -> -value));
    }

    @Override
    public Value not() {
        return new TensorValue(this.value.map(value -> value == 0.0 ? 1.0 : 0.0));
    }

    @Override
    public Value or(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.join(((TensorValue)argument).value, (a, b) -> a != 0.0 || b != 0.0 ? 1.0 : 0.0));
        }
        return new TensorValue(this.value.map(value -> value != 0.0 || argument.asBoolean() ? 1.0 : 0.0));
    }

    @Override
    public Value and(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.join(((TensorValue)argument).value, (a, b) -> a != 0.0 && b != 0.0 ? 1.0 : 0.0));
        }
        return new TensorValue(this.value.map(value -> value != 0.0 && argument.asBoolean() ? 1.0 : 0.0));
    }

    @Override
    public Value largerOrEqual(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.largerOrEqual(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value >= argument.asDouble() ? 1.0 : 0.0));
    }

    @Override
    public Value larger(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.larger(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value > argument.asDouble() ? 1.0 : 0.0));
    }

    @Override
    public Value smallerOrEqual(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.smallerOrEqual(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value <= argument.asDouble() ? 1.0 : 0.0));
    }

    @Override
    public Value smaller(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.smaller(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value < argument.asDouble() ? 1.0 : 0.0));
    }

    @Override
    public Value approxEqual(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.approxEqual(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> DoubleCompatibleValue.approxEqual(value, argument.asDouble()) ? 1.0 : 0.0));
    }

    @Override
    public Value notEqual(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.notEqual(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value != argument.asDouble() ? 1.0 : 0.0));
    }

    @Override
    public Value equal(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.equal(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value == argument.asDouble() ? 1.0 : 0.0));
    }

    @Override
    public Value add(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.add(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value + argument.asDouble()));
    }

    @Override
    public Value subtract(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.subtract(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value - argument.asDouble()));
    }

    @Override
    public Value multiply(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.multiply(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value * argument.asDouble()));
    }

    @Override
    public Value divide(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.divide(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value / argument.asDouble()));
    }

    @Override
    public Value modulo(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.fmod(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value % argument.asDouble()));
    }

    @Override
    public Value power(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.pow(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> Math.pow(value, argument.asDouble())));
    }

    @Override
    public Tensor asTensor() {
        return this.value;
    }

    @Override
    public Value function(Function function, Value arg) {
        if (arg instanceof TensorValue) {
            return new TensorValue(this.functionOnTensor(function, arg.asTensor()));
        }
        return new TensorValue(this.value.map(value -> function.evaluate(value, arg.asDouble())));
    }

    private Tensor functionOnTensor(Function function, Tensor argument) {
        return switch (function) {
            case Function.min -> this.value.min(argument);
            case Function.max -> this.value.max(argument);
            case Function.atan2 -> this.value.atan2(argument);
            case Function.pow -> this.value.pow(argument);
            case Function.fmod -> this.value.fmod(argument);
            case Function.ldexp -> this.value.ldexp(argument);
            case Function.bit -> this.value.bit(argument);
            case Function.hamming -> this.value.hamming(argument);
            default -> throw new UnsupportedOperationException("Cannot combine two tensors using " + function);
        };
    }

    @Override
    public Value asMutable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TensorValue other = (TensorValue)o;
        return this.value.equals((Object)other.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

