/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation;

import com.yahoo.data.disclosure.DataSink;
import com.yahoo.data.disclosure.DataSource;
import com.yahoo.searchlib.aggregation.AggregationResult;
import com.yahoo.searchlib.expression.FloatResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;

public class QuantileAggregationResult
extends AggregationResult {
    public static final int classId = QuantileAggregationResult.registerClass((int)16563, QuantileAggregationResult.class, QuantileAggregationResult::new);
    private List<Double> quantiles;
    private KllDoublesSketch sketch;
    private byte extension;

    public QuantileAggregationResult() {
        this.quantiles = List.of();
        this.sketch = KllDoublesSketch.newHeapInstance();
    }

    public QuantileAggregationResult(List<Double> quantiles) {
        QuantileAggregationResult.validate(quantiles);
        this.quantiles = quantiles;
        this.sketch = KllDoublesSketch.newHeapInstance();
    }

    private static void validate(List<Double> in) {
        Objects.requireNonNull(in);
        if (in.isEmpty()) {
            throw new IllegalArgumentException("quantiles must be non-empty");
        }
        for (Double q : in) {
            if (q != null && !Double.isNaN(q) && !Double.isInfinite(q) && !(q < 0.0) && !(q > 1.0)) continue;
            throw new IllegalArgumentException("quantile must be finite and in [0,1]: " + q);
        }
    }

    public List<Double> getQuantiles() {
        return this.quantiles;
    }

    public QuantileResult getQuantileResults() {
        QuantileResult.Builder builder = new QuantileResult.Builder();
        for (Double quantile : this.quantiles) {
            builder.add(quantile, this.sketch.getQuantile(quantile.doubleValue()));
        }
        return builder.build();
    }

    public QuantileAggregationResult setQuantiles(List<Double> quantiles) {
        QuantileAggregationResult.validate(quantiles);
        this.quantiles = quantiles;
        return this;
    }

    public QuantileAggregationResult updateSketch(double value) {
        this.sketch.update(value);
        return this;
    }

    @Override
    public ResultNode getRank() {
        return new FloatResultNode(0.0);
    }

    @Override
    protected void onMerge(AggregationResult result) {
        this.sketch.merge((KllSketch)((QuantileAggregationResult)result).sketch);
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putInt(null, this.quantiles.size());
        for (Double quantile : this.quantiles) {
            buf.putDouble(null, quantile.doubleValue());
        }
        buf.putByte(null, this.extension);
        byte[] bytes = this.sketch.toByteArray();
        buf.putInt(null, bytes.length);
        buf.put(null, bytes);
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        this.quantiles = new ArrayList<Double>();
        int length = buf.getInt(null);
        for (int i = 0; i < length; ++i) {
            this.quantiles.add(buf.getDouble(null));
        }
        this.extension = buf.getByte(null);
        length = buf.getInt(null);
        byte[] bytes = buf.getBytes(null, length);
        this.sketch = KllDoublesSketch.heapify((Memory)Memory.wrap((byte[])bytes));
    }

    @Override
    protected boolean equalsAggregation(AggregationResult obj) {
        return this.quantiles.equals(((QuantileAggregationResult)obj).quantiles) && Arrays.equals(this.sketch.toByteArray(), ((QuantileAggregationResult)obj).sketch.toByteArray());
    }

    @Override
    public QuantileAggregationResult clone() {
        QuantileAggregationResult obj = (QuantileAggregationResult)super.clone();
        obj.quantiles = new ArrayList<Double>();
        obj.quantiles.addAll(this.quantiles);
        obj.sketch = KllDoublesSketch.heapify((Memory)Memory.wrap((byte[])this.sketch.toByteArray()));
        return obj;
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("quantiles", this.quantiles);
        for (QuantileResult.Entry result : this.getQuantileResults().entries) {
            visitor.visit("quantile(" + result.quantile + ")", (Object)result.value);
        }
        visitor.visit("extension", (Object)this.extension);
    }

    public record QuantileResult(List<Entry> entries) implements DataSource
    {
        public void emit(DataSink sink) {
            sink.startArray();
            for (Entry entry : this.entries) {
                sink.startObject();
                sink.fieldName("quantile");
                sink.doubleValue(entry.quantile);
                sink.fieldName("value");
                sink.doubleValue(entry.value);
                sink.endObject();
            }
            sink.endArray();
        }

        public record Entry(double quantile, double value) {
        }

        public static class Builder {
            private final List<Entry> entries = new ArrayList<Entry>();

            public Builder add(double quantile, double value) {
                this.entries.add(new Entry(quantile, value));
                return this;
            }

            public QuantileResult build() {
                return new QuantileResult(List.copyOf(this.entries));
            }
        }
    }
}

