/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.FloatResultNode;
import com.yahoo.searchlib.expression.IntegerResultNode;
import com.yahoo.searchlib.expression.RawResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.searchlib.expression.StringResultNode;
import java.util.HashMap;
import java.util.Map;

public class ArithmeticTypeConversion {
    private static final Map<Integer, Map<Integer, Integer>> types = new HashMap<Integer, Map<Integer, Integer>>();

    private static void add(int a, int b, int c) {
        Map<Integer, Integer> entry = types.containsKey(a) ? types.get(a) : new HashMap<Integer, Integer>();
        entry.put(b, c);
        types.put(a, entry);
    }

    public static ResultNode getType(ResultNode arg) {
        return (ResultNode)ResultNode.createFromId((int)ArithmeticTypeConversion.getBaseType(arg));
    }

    public static ResultNode getType(ResultNode arg1, ResultNode arg2) {
        return (ResultNode)ResultNode.createFromId((int)types.get(ArithmeticTypeConversion.getBaseType(arg1)).get(ArithmeticTypeConversion.getBaseType(arg2)));
    }

    public static int getBaseType(ResultNode arg) {
        if (arg instanceof IntegerResultNode) {
            return IntegerResultNode.classId;
        }
        if (arg instanceof FloatResultNode) {
            return FloatResultNode.classId;
        }
        if (arg instanceof StringResultNode) {
            return StringResultNode.classId;
        }
        if (arg instanceof RawResultNode) {
            return RawResultNode.classId;
        }
        return ResultNode.classId;
    }

    static {
        ArithmeticTypeConversion.add(IntegerResultNode.classId, IntegerResultNode.classId, IntegerResultNode.classId);
        ArithmeticTypeConversion.add(IntegerResultNode.classId, FloatResultNode.classId, FloatResultNode.classId);
        ArithmeticTypeConversion.add(IntegerResultNode.classId, StringResultNode.classId, IntegerResultNode.classId);
        ArithmeticTypeConversion.add(IntegerResultNode.classId, RawResultNode.classId, IntegerResultNode.classId);
        ArithmeticTypeConversion.add(FloatResultNode.classId, IntegerResultNode.classId, FloatResultNode.classId);
        ArithmeticTypeConversion.add(FloatResultNode.classId, FloatResultNode.classId, FloatResultNode.classId);
        ArithmeticTypeConversion.add(FloatResultNode.classId, StringResultNode.classId, FloatResultNode.classId);
        ArithmeticTypeConversion.add(FloatResultNode.classId, RawResultNode.classId, FloatResultNode.classId);
        ArithmeticTypeConversion.add(StringResultNode.classId, IntegerResultNode.classId, IntegerResultNode.classId);
        ArithmeticTypeConversion.add(StringResultNode.classId, FloatResultNode.classId, FloatResultNode.classId);
        ArithmeticTypeConversion.add(StringResultNode.classId, StringResultNode.classId, StringResultNode.classId);
        ArithmeticTypeConversion.add(StringResultNode.classId, RawResultNode.classId, StringResultNode.classId);
        ArithmeticTypeConversion.add(RawResultNode.classId, IntegerResultNode.classId, IntegerResultNode.classId);
        ArithmeticTypeConversion.add(RawResultNode.classId, FloatResultNode.classId, FloatResultNode.classId);
        ArithmeticTypeConversion.add(RawResultNode.classId, StringResultNode.classId, StringResultNode.classId);
        ArithmeticTypeConversion.add(RawResultNode.classId, RawResultNode.classId, RawResultNode.classId);
    }
}

