/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.parser;

import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.TensorFunctionNode;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.ScalarFunction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CellMapHelper {
    private final Common meta;
    private final List<String> labels;

    public CellMapHelper(TensorType type, List<String> dimensionOrder) {
        this.meta = new Common(type, dimensionOrder);
        this.labels = new ArrayList<String>();
    }

    private CellMapHelper(Common meta, List<String> labels) {
        this.meta = meta;
        this.labels = labels;
    }

    public Map<TensorAddress, ScalarFunction<Reference>> map() {
        return this.meta.receivingMap();
    }

    public CellMapHelper bind(String label) {
        if (this.labels.size() >= this.meta.mappedDims().size()) {
            throw new IllegalArgumentException("At " + this.address() + ": Got label '" + label + "' but all mapped dimensions already have labels");
        }
        ArrayList<String> next = new ArrayList<String>(this.labels);
        next.add(label);
        return new CellMapHelper(this.meta, next);
    }

    private String address() {
        StringBuilder addr = new StringBuilder();
        if (this.labels.size() == 1) {
            addr.append("'");
            addr.append(this.labels.get(0));
            addr.append("'");
        } else {
            addr.append("{");
            for (int idx = 0; idx < this.labels.size(); ++idx) {
                if (idx > 0) {
                    addr.append(", ");
                }
                addr.append(this.meta.mappedDims().get(idx));
                addr.append(":'");
                addr.append(this.labels.get(idx));
                addr.append("'");
            }
            addr.append("}");
        }
        return addr.toString();
    }

    public void handleScalar(ExpressionNode node) {
        if (this.labels.size() < this.meta.mappedDims().size()) {
            throw new IllegalArgumentException("At " + this.address() + ": Missing label for dimension '" + this.meta.mappedDims().get(this.labels.size()) + "'");
        }
        if (this.meta.type().hasIndexedDimensions()) {
            throw new IllegalArgumentException("At " + this.address() + ": Need an array of values");
        }
        TensorAddress.Builder addr = new TensorAddress.Builder(this.meta.type());
        for (int idx = 0; idx < this.labels.size(); ++idx) {
            addr.add(this.meta.mappedDims().get(idx), this.labels.get(idx));
        }
        this.meta.receivingMap().put(addr.build(), TensorFunctionNode.wrapScalar(node));
    }

    public void handleDenseSubspace(List<ExpressionNode> nodes) {
        if (this.labels.size() < this.meta.mappedDims().size()) {
            throw new IllegalArgumentException("At " + this.address() + ": Missing label for dimension '" + this.meta.mappedDims().get(this.labels.size()) + "'");
        }
        if (!this.meta.type().hasIndexedDimensions()) {
            throw new IllegalArgumentException("At " + this.address() + ": Need a single value");
        }
        TensorType denseSubtype = this.meta.type().indexedSubtype();
        IndexedTensor.Indexes indexes = IndexedTensor.Indexes.of((TensorType)denseSubtype, this.meta.indexedDims());
        if (indexes.size() != (long)nodes.size()) {
            throw new IllegalArgumentException("At " + this.address() + ": Need " + indexes.size() + " values to fill a dense subspace of " + String.valueOf(this.meta.type()) + " but got " + nodes.size());
        }
        TensorAddress.Builder addr = new TensorAddress.Builder(this.meta.type());
        for (int idx = 0; idx < this.labels.size(); ++idx) {
            addr.add(this.meta.mappedDims().get(idx), this.labels.get(idx));
        }
        for (ExpressionNode node : nodes) {
            indexes.next();
            int indexedDimensionsIndex = 0;
            for (TensorType.Dimension dimension : this.meta.type().dimensions()) {
                if (!dimension.isIndexed()) continue;
                addr.add(dimension.name(), indexes.indexesForReading()[indexedDimensionsIndex++]);
            }
            this.meta.receivingMap().put(addr.build(), TensorFunctionNode.wrapScalar(node));
        }
    }

    private record Common(Map<TensorAddress, ScalarFunction<Reference>> receivingMap, TensorType type, List<String> mappedDims, List<String> indexedDims) {
        Common(TensorType type, List<String> dimensionOrder) {
            this(new LinkedHashMap<TensorAddress, ScalarFunction<Reference>>(), type, new ArrayList<String>(), new ArrayList<String>());
            for (String name : dimensionOrder) {
                TensorType.Dimension dim = (TensorType.Dimension)type.dimension(name).orElseThrow(() -> new IllegalStateException("bad dimension name: " + name));
                if (dim.isMapped()) {
                    this.mappedDims.add(name);
                    continue;
                }
                this.indexedDims.add(name);
            }
        }
    }
}

