/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.yahoo.lang.MutableInteger;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.ContextIndex;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.stream.CustomCollectors;
import java.util.BitSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractArrayContext
extends Context
implements Cloneable,
ContextIndex {
    private final boolean ignoreUnknownValues;
    private final String rankingExpressionName;
    private IndexedBindings indexedBindings;

    protected AbstractArrayContext(RankingExpression expression) {
        this(expression, false, defaultMissingValue);
    }

    protected AbstractArrayContext(RankingExpression expression, boolean ignoreUnknownValues) {
        this(expression, ignoreUnknownValues, defaultMissingValue);
    }

    protected AbstractArrayContext(RankingExpression expression, boolean ignoreUnknownValues, Value missingValue) {
        this.missingValue = missingValue.freeze();
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.rankingExpressionName = expression.getName();
        this.indexedBindings = new IndexedBindings(expression, this.missingValue);
    }

    protected final Map<String, Integer> nameToIndex() {
        return this.indexedBindings.nameToIndex();
    }

    protected final double[] doubleValues() {
        return this.indexedBindings.doubleValues();
    }

    protected final boolean ignoreUnknownValues() {
        return this.ignoreUnknownValues;
    }

    @Override
    public Set<String> names() {
        return this.indexedBindings.names();
    }

    @Override
    public final int getIndex(String name) {
        return this.indexedBindings.nameToIndex.get(name);
    }

    @Override
    public int size() {
        return this.indexedBindings.size();
    }

    @Override
    public double getDouble(int index) {
        return this.indexedBindings.getDouble(index);
    }

    final boolean isMissing(int index) {
        return this.indexedBindings.isMissing(index);
    }

    final void clearMissing(int index) {
        this.indexedBindings.clearMissing(index);
    }

    public String toString() {
        return "fast lookup context for ranking expression '" + this.rankingExpressionName + "' [" + this.size() + " variables]";
    }

    public AbstractArrayContext clone() {
        try {
            AbstractArrayContext clone = (AbstractArrayContext)super.clone();
            clone.indexedBindings = this.indexedBindings.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Programming error");
        }
    }

    private static class IndexedBindings
    implements Cloneable {
        private final Map<String, Integer> nameToIndex;
        private double[] doubleValues;
        private BitSet setValues;
        private final double missingValue;

        public IndexedBindings(RankingExpression expression, Value missingValue) {
            LinkedHashSet<String> bindTargets = new LinkedHashSet<String>();
            this.extractBindTargets(expression.getRoot(), bindTargets);
            this.missingValue = missingValue.asDouble();
            this.setValues = new BitSet(bindTargets.size());
            this.doubleValues = new double[bindTargets.size()];
            for (int i = 0; i < bindTargets.size(); ++i) {
                this.doubleValues[i] = this.missingValue;
            }
            MutableInteger index = new MutableInteger(0);
            this.nameToIndex = (Map)bindTargets.stream().collect(CustomCollectors.toLinkedMap(name -> name, name -> index.next()));
        }

        private void extractBindTargets(ExpressionNode node, Set<String> bindTargets) {
            if (node instanceof ReferenceNode) {
                if (((ReferenceNode)node).getArguments().expressions().size() > 0) {
                    throw new UnsupportedOperationException("Can not bind " + String.valueOf(node) + ": Array lookup is not supported with features having arguments)");
                }
                bindTargets.add(node.toString());
            } else if (node instanceof CompositeNode) {
                CompositeNode cNode = (CompositeNode)node;
                for (ExpressionNode child : cNode.children()) {
                    this.extractBindTargets(child, bindTargets);
                }
            }
        }

        public Map<String, Integer> nameToIndex() {
            return this.nameToIndex;
        }

        public double[] doubleValues() {
            return this.doubleValues;
        }

        public Set<String> names() {
            return this.nameToIndex.keySet();
        }

        public int getIndex(String name) {
            return this.nameToIndex.get(name);
        }

        public int size() {
            return this.doubleValues.length;
        }

        public double getDouble(int index) {
            return this.doubleValues[index];
        }

        public boolean isMissing(int index) {
            return !this.setValues.get(index);
        }

        public void clearMissing(int index) {
            this.setValues.set(index);
        }

        public IndexedBindings clone() {
            try {
                IndexedBindings clone = (IndexedBindings)super.clone();
                clone.setValues = new BitSet(this.nameToIndex.size());
                clone.doubleValues = new double[this.nameToIndex.size()];
                for (int i = 0; i < this.nameToIndex.size(); ++i) {
                    clone.doubleValues[i] = this.missingValue;
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Programming error");
            }
        }
    }
}

