/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.FilterExpressionNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class MultiArgPredicateNode
extends FilterExpressionNode {
    public static final int classId = MultiArgPredicateNode.registerClass((int)16559, MultiArgPredicateNode.class);
    private List<FilterExpressionNode> args = new ArrayList<FilterExpressionNode>();

    public MultiArgPredicateNode() {
    }

    public MultiArgPredicateNode(List<FilterExpressionNode> args) {
        this.args = args;
    }

    public final MultiArgPredicateNode addArg(FilterExpressionNode arg) {
        Objects.requireNonNull(arg, "Can not add null arg");
        this.args.add(arg);
        return this;
    }

    public FilterExpressionNode getArg(int i) {
        return this.args.get(i);
    }

    public int getNumArgs() {
        return this.args.size();
    }

    public List<FilterExpressionNode> getArgs() {
        return this.args;
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        int numArgs = this.args.size();
        buf.putInt(null, numArgs);
        for (FilterExpressionNode node : this.args) {
            MultiArgPredicateNode.serializeOptional((Serializer)buf, (Identifiable)node);
        }
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        this.args.clear();
        int numArgs = buf.getInt(null);
        for (int i = 0; i < numArgs; ++i) {
            FilterExpressionNode node = (FilterExpressionNode)MultiArgPredicateNode.deserializeOptional((Deserializer)buf);
            this.args.add(node);
        }
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("args", this.args);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MultiArgPredicateNode rhs = (MultiArgPredicateNode)((Object)o);
        return this.args.equals(rhs.args);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.args);
    }
}

