/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.gbdt;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

abstract class XmlHelper {
    XmlHelper() {
    }

    public static Element parseXml(String xml) throws ParserConfigurationException, IOException, SAXException {
        return XmlHelper.parseXmlStream(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }

    public static Element parseXmlFile(String fileName) throws ParserConfigurationException, IOException, SAXException {
        return XmlHelper.parseXmlStream(new FileInputStream(fileName));
    }

    public static Element parseXmlStream(InputStream in) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = XmlHelper.createDocumentBuilderFactory().newDocumentBuilder();
        Document doc = builder.parse(in);
        return doc.getDocumentElement();
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return factory;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Failed to initialize XML parser", e);
        }
    }

    public static String getAttributeText(Node node, String name) {
        Node valueNode = node.getAttributes().getNamedItem(name);
        if (valueNode == null) {
            throw new IllegalArgumentException("Missing '" + name + "' attribute in element '" + node.getNodeName() + "'.");
        }
        String valueText = valueNode.getTextContent();
        if (valueText == null || valueText.isEmpty()) {
            throw new IllegalArgumentException("Attribute '" + name + "' in element '" + node.getNodeName() + "' is empty.");
        }
        return valueText;
    }

    public static String getAttributeTextOrNull(Node node, String name) {
        Node valueNode = node.getAttributes().getNamedItem(name);
        if (valueNode == null) {
            return null;
        }
        return valueNode.getTextContent();
    }

    public static Optional<String> getOptionalAttributeText(Node node, String name) {
        Node valueNode = node.getAttributes().getNamedItem(name);
        if (valueNode == null) {
            return Optional.empty();
        }
        return Optional.of(valueNode.getTextContent());
    }

    public static Element getSingleElement(Node node, String name) {
        List<Element> children = XmlHelper.getChildElements(node, name);
        if (children.isEmpty()) {
            if (name != null) {
                throw new IllegalArgumentException("Node '" + node.getNodeName() + "' has no '" + name + "' children.");
            }
            throw new IllegalArgumentException("Node '" + node.getNodeName() + "' has no children.");
        }
        if (children.size() != 1) {
            if (name != null) {
                throw new IllegalArgumentException("Expected 1 '" + name + "' child, got " + children.size() + ".");
            }
            throw new IllegalArgumentException("Expected 1 child, got " + children.size() + ".");
        }
        return children.get(0);
    }

    public static List<Element> getChildElements(Node node, String name) {
        NodeList children = node.getChildNodes();
        LinkedList<Element> lst = new LinkedList<Element>();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element) || name != null && !child.getNodeName().equalsIgnoreCase(name)) continue;
            lst.add((Element)child);
        }
        return lst;
    }
}

