/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import java.io.Serializable;
import java.util.List;

public final class Arguments
implements Serializable {
    public static final Arguments EMPTY = new Arguments();
    private final List<ExpressionNode> expressions;

    public Arguments() {
        this(List.of());
    }

    public Arguments(ExpressionNode singleArgument) {
        this(List.of(singleArgument));
    }

    public Arguments(List<? extends ExpressionNode> expressions) {
        if (expressions == null) {
            this.expressions = List.of();
            return;
        }
        this.expressions = List.copyOf(expressions);
    }

    public List<ExpressionNode> expressions() {
        return this.expressions;
    }

    public int size() {
        return this.expressions.size();
    }

    public Value[] evaluate(Context context) {
        Value[] values = new Value[this.expressions.size()];
        for (int i = 0; i < this.expressions.size(); ++i) {
            values[i] = this.expressions.get(i).evaluate(context);
        }
        return values;
    }

    public Value evaluate(int i, Context context) {
        return this.expressions.get(i).evaluate(context);
    }

    public void setAreFeatureArguments(boolean featureArguments) {
        for (ExpressionNode argument : this.expressions) {
            if (!(argument instanceof ReferenceNode)) continue;
            ReferenceNode simple = (ReferenceNode)argument;
            simple.setIsFeatureArgument(true);
        }
    }

    public boolean isEmpty() {
        return this.expressions.isEmpty();
    }

    public int hashCode() {
        return this.expressions.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        return other instanceof Arguments && this.expressions.equals(((Arguments)other).expressions);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("(");
        for (ExpressionNode argument : this.expressions) {
            b.append(argument).append(",");
        }
        b.setLength(b.length() - 1);
        if (b.length() > 0) {
            b.append(")");
        }
        return b.toString();
    }
}

