/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.BooleanNode;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.searchlib.rankingexpression.rule.TruthOperator;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import java.util.Deque;
import java.util.List;
import java.util.Objects;

public class ComparisonNode
extends BooleanNode {
    private final TruthOperator operator;
    private final List<ExpressionNode> conditions;

    public ComparisonNode(ExpressionNode leftCondition, TruthOperator operator, ExpressionNode rightCondition) {
        this.conditions = List.of(leftCondition, rightCondition);
        this.operator = operator;
    }

    @Override
    public List<ExpressionNode> children() {
        return this.conditions;
    }

    public TruthOperator getOperator() {
        return this.operator;
    }

    public ExpressionNode getLeftCondition() {
        return this.conditions.get(0);
    }

    public ExpressionNode getRightCondition() {
        return this.conditions.get(1);
    }

    @Override
    public StringBuilder toString(StringBuilder string, SerializationContext context, Deque<String> path, CompositeNode parent) {
        this.getLeftCondition().toString(string, context, path, this).append(' ').append(this.operator).append(' ');
        return this.getRightCondition().toString(string, context, path, this);
    }

    @Override
    public TensorType type(TypeContext<Reference> context) {
        return TensorType.empty;
    }

    @Override
    public Value evaluate(Context context) {
        Value leftValue = this.getLeftCondition().evaluate(context);
        Value rightValue = this.getRightCondition().evaluate(context);
        return leftValue.compare(this.operator, rightValue);
    }

    @Override
    public ComparisonNode setChildren(List<ExpressionNode> children) {
        if (children.size() != 2) {
            throw new IllegalArgumentException("A comparison test must have 2 children");
        }
        return new ComparisonNode(children.get(0), this.operator, children.get(1));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.operator, this.conditions);
    }
}

