/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.ExpressionNode;
import com.yahoo.searchlib.expression.FilterExpressionNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.util.Objects;
import java.util.Optional;

public class RegexPredicateNode
extends FilterExpressionNode {
    public static final int classId = RegexPredicateNode.registerClass((int)16556, RegexPredicateNode.class, RegexPredicateNode::new);
    private String pattern;
    private ExpressionNode expression;

    public RegexPredicateNode() {
    }

    public RegexPredicateNode(String pattern, ExpressionNode expression) {
        this.pattern = Objects.requireNonNull(pattern, "pattern cannot be null");
        this.expression = expression;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Optional<ExpressionNode> getExpression() {
        return Optional.ofNullable(this.expression);
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    public RegexPredicateNode clone() {
        return new RegexPredicateNode(this.pattern, this.expression != null ? this.expression.clone() : null);
    }

    @Override
    protected void onSerialize(Serializer buf) {
        this.putUtf8(buf, this.pattern);
        RegexPredicateNode.serializeOptional((Serializer)buf, (Identifiable)this.expression);
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        this.pattern = this.getUtf8(buf);
        this.expression = (ExpressionNode)RegexPredicateNode.deserializeOptional((Deserializer)buf);
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("pattern", (Object)this.pattern);
        visitor.visit("expression", (Object)this.expression);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RegexPredicateNode that = (RegexPredicateNode)((Object)o);
        return Objects.equals(this.pattern, that.pattern) && Objects.equals(this.expression, that.expression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pattern, this.expression);
    }
}

