/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.ranking.features;

import com.yahoo.searchlib.rankingexpression.Reference;
import java.util.Optional;

public class FeatureNames {
    public static Reference asConstantFeature(String constantName) {
        return Reference.simple("constant", FeatureNames.quoteIfNecessary(constantName));
    }

    public static Reference asAttributeFeature(String attributeName) {
        return Reference.simple("attribute", attributeName);
    }

    public static Reference asQueryFeature(String propertyName) {
        return Reference.simple("query", FeatureNames.quoteIfNecessary(propertyName));
    }

    public static boolean isSimpleFeature(Reference reference) {
        if (!reference.isSimple()) {
            return false;
        }
        if (reference.output() != null) {
            return false;
        }
        String name = reference.name();
        return name.equals("attribute") || name.equals("constant") || name.equals("query");
    }

    public static boolean isConstantFeature(Reference reference) {
        if (!FeatureNames.isSimpleFeature(reference)) {
            return false;
        }
        return reference.name().equals("constant");
    }

    public static boolean isQueryFeature(Reference reference) {
        if (!FeatureNames.isSimpleFeature(reference)) {
            return false;
        }
        return reference.name().equals("query");
    }

    public static boolean isAttributeFeature(Reference reference) {
        if (!FeatureNames.isSimpleFeature(reference)) {
            return false;
        }
        return reference.name().equals("attribute");
    }

    public static Optional<String> argumentOf(String feature) {
        Optional<Reference> reference = Reference.simple(feature);
        if (reference.isEmpty()) {
            return Optional.empty();
        }
        if (!(reference.get().name().equals("attribute") || reference.get().name().equals("constant") || reference.get().name().equals("query"))) {
            return Optional.empty();
        }
        return Optional.of(reference.get().arguments().expressions().get(0).toString());
    }

    static boolean needsQuoting(String s) {
        if (s.isEmpty()) {
            return true;
        }
        if (!FeatureNames.isValidFirst(s.charAt(0))) {
            return true;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (FeatureNames.isValidAny(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static String quoteIfNecessary(String s) {
        if (FeatureNames.needsQuoting(s)) {
            return "\"" + s + "\"";
        }
        return s;
    }

    private static boolean isValidFirst(char c) {
        return c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    private static boolean isValidAny(char c) {
        return c == '-' || FeatureNames.isValidFirst(c);
    }
}

