/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FunctionReferenceContext {
    private final Map<String, ExpressionFunction> functions;
    private final Map<String, String> bindings = new HashMap<String, String>();

    public FunctionReferenceContext() {
        this(List.of());
    }

    public FunctionReferenceContext(Collection<ExpressionFunction> functions) {
        this(FunctionReferenceContext.toMap(functions), Map.of());
    }

    public FunctionReferenceContext(Collection<ExpressionFunction> functions, Map<String, String> bindings) {
        this(FunctionReferenceContext.toMap(functions), bindings);
    }

    public FunctionReferenceContext(Map<String, ExpressionFunction> functions) {
        this(functions, null);
    }

    public FunctionReferenceContext(Map<String, ExpressionFunction> functions, Map<String, String> bindings) {
        this.functions = Map.copyOf(functions);
        if (bindings != null) {
            this.bindings.putAll(bindings);
        }
    }

    private static Map<String, ExpressionFunction> toMap(Collection<ExpressionFunction> list) {
        HashMap<String, ExpressionFunction> mapBuilder = new HashMap<String, ExpressionFunction>();
        for (ExpressionFunction function : list) {
            mapBuilder.put(function.getName(), function);
        }
        return Map.copyOf(mapBuilder);
    }

    public ExpressionFunction getFunction(String name) {
        return this.functions.get(name);
    }

    protected Map<String, ExpressionFunction> getFunctions() {
        return this.functions;
    }

    public String getBinding(String name) {
        return this.bindings.get(name);
    }

    public FunctionReferenceContext withBindings(Map<String, String> bindings) {
        return new FunctionReferenceContext(this.functions, bindings);
    }

    public FunctionReferenceContext withoutBindings() {
        return new FunctionReferenceContext(this.functions);
    }
}

