/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import java.io.Serializable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TruthOperator implements Serializable
{
    SMALLER("<"){

        @Override
        public boolean evaluate(double x, double y) {
            return x < y;
        }
    }
    ,
    SMALLEREQUAL("<="){

        @Override
        public boolean evaluate(double x, double y) {
            return x <= y;
        }
    }
    ,
    EQUAL("=="){

        @Override
        public boolean evaluate(double x, double y) {
            return x == y;
        }
    }
    ,
    APPROX_EQUAL("~="){

        @Override
        public boolean evaluate(double x, double y) {
            return TruthOperator.approxEqual(x, y);
        }
    }
    ,
    LARGER(">"){

        @Override
        public boolean evaluate(double x, double y) {
            return x > y;
        }
    }
    ,
    LARGEREQUAL(">="){

        @Override
        public boolean evaluate(double x, double y) {
            return x >= y;
        }
    }
    ,
    NOTEQUAL("!="){

        @Override
        public boolean evaluate(double x, double y) {
            return x != y;
        }
    };

    private final String operatorString;

    private TruthOperator(String operatorString) {
        this.operatorString = operatorString;
    }

    public abstract boolean evaluate(double var1, double var3);

    public String toString() {
        return this.operatorString;
    }

    public static TruthOperator fromString(String string) {
        for (TruthOperator operator : TruthOperator.values()) {
            if (!operator.toString().equals(string)) continue;
            return operator;
        }
        throw new IllegalArgumentException("Illegal truth operator '" + string + "'");
    }

    private static boolean approxEqual(double x, double y) {
        if (y < -1.0 || y > 1.0) {
            x = Math.nextAfter(x / y, 1.0);
            y = 1.0;
        } else {
            x = Math.nextAfter(x, y);
        }
        return x == y;
    }
}

