/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation;

import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import java.util.Arrays;

public final class RawData
implements Cloneable,
Comparable<RawData> {
    private byte[] data;

    public RawData() {
        this.data = new byte[0];
    }

    public RawData(byte[] data) {
        this.setData(data);
    }

    public void serialize(Serializer buf) {
        buf.putInt(null, this.data.length);
        buf.put(null, this.data);
    }

    public void deserialize(Deserializer buf) {
        int len = buf.getInt(null);
        this.data = buf.getBytes(null, len);
    }

    public byte[] getData() {
        return this.data;
    }

    public RawData setData(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Data can not be null.");
        }
        this.data = data;
        return this;
    }

    @Override
    public int compareTo(RawData rhs) {
        return RawData.compare(this.data, rhs.data);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RawData)) {
            return false;
        }
        RawData rhs = (RawData)obj;
        return Arrays.equals(this.data, rhs.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public String toString() {
        return "RawData(data = " + Arrays.toString(this.data) + ")";
    }

    public Object clone() {
        return new RawData(Arrays.copyOf(this.data, this.data.length));
    }

    public static int compare(byte[] lhs, byte[] rhs) {
        int cmp = 0;
        int len = Math.min(lhs.length, rhs.length);
        for (int i = 0; i < len && cmp == 0; ++i) {
            int a = lhs[i] & 0xFF;
            int b = rhs[i] & 0xFF;
            cmp = a - b;
        }
        if (cmp == 0) {
            cmp = lhs.length - rhs.length;
        }
        return cmp;
    }
}

