/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation.hll;

import com.yahoo.searchlib.aggregation.hll.Sketch;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import java.util.HashSet;

public class SparseSketch
extends Sketch<SparseSketch> {
    public static final int classId = SparseSketch.registerClass((int)16555, SparseSketch.class, SparseSketch::new);
    private final HashSet<Integer> values = new HashSet();

    @Override
    public void merge(SparseSketch other) {
        this.values.addAll(other.values);
    }

    @Override
    public void aggregate(Iterable<Integer> hashValues) {
        for (int hash : hashValues) {
            this.aggregate(hash);
        }
    }

    @Override
    public void aggregate(int hash) {
        this.values.add(hash);
    }

    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putInt(null, this.values.size());
        for (int value : this.values) {
            buf.putInt(null, value);
        }
    }

    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        this.values.clear();
        int nElements = buf.getInt(null);
        for (int i = 0; i < nElements; ++i) {
            this.values.add(buf.getInt(null));
        }
    }

    protected int onGetClassId() {
        return classId;
    }

    public HashSet<Integer> data() {
        return this.values;
    }

    public int size() {
        return this.values.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SparseSketch sketch = (SparseSketch)((Object)o);
        return this.values.equals(sketch.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return "SparseSketch{values=" + this.values + "}";
    }
}

