/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.yahoo.tensor.functions.ScalarFunctions;
import java.io.Serializable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Function implements Serializable
{
    abs{

        @Override
        public double evaluate(double x, double y) {
            return Math.abs(x);
        }
    }
    ,
    acos{

        @Override
        public double evaluate(double x, double y) {
            return Math.acos(x);
        }
    }
    ,
    asin{

        @Override
        public double evaluate(double x, double y) {
            return Math.asin(x);
        }
    }
    ,
    atan{

        @Override
        public double evaluate(double x, double y) {
            return Math.atan(x);
        }
    }
    ,
    ceil{

        @Override
        public double evaluate(double x, double y) {
            return Math.ceil(x);
        }
    }
    ,
    cos{

        @Override
        public double evaluate(double x, double y) {
            return Math.cos(x);
        }
    }
    ,
    cosh{

        @Override
        public double evaluate(double x, double y) {
            return Math.cosh(x);
        }
    }
    ,
    elu{

        @Override
        public double evaluate(double x, double y) {
            return x < 0.0 ? Math.exp(x) - 1.0 : x;
        }
    }
    ,
    exp{

        @Override
        public double evaluate(double x, double y) {
            return Math.exp(x);
        }
    }
    ,
    fabs{

        @Override
        public double evaluate(double x, double y) {
            return Math.abs(x);
        }
    }
    ,
    floor{

        @Override
        public double evaluate(double x, double y) {
            return Math.floor(x);
        }
    }
    ,
    isNan{

        @Override
        public double evaluate(double x, double y) {
            return Double.isNaN(x) ? 1.0 : 0.0;
        }
    }
    ,
    log{

        @Override
        public double evaluate(double x, double y) {
            return Math.log(x);
        }
    }
    ,
    log10{

        @Override
        public double evaluate(double x, double y) {
            return Math.log10(x);
        }
    }
    ,
    relu{

        @Override
        public double evaluate(double x, double y) {
            return Math.max(x, 0.0);
        }
    }
    ,
    round{

        @Override
        public double evaluate(double x, double y) {
            return Math.round(x);
        }
    }
    ,
    sigmoid{

        @Override
        public double evaluate(double x, double y) {
            return 1.0 / (1.0 + Math.exp(-1.0 * x));
        }
    }
    ,
    sign{

        @Override
        public double evaluate(double x, double y) {
            return x >= 0.0 ? 1.0 : -1.0;
        }
    }
    ,
    sin{

        @Override
        public double evaluate(double x, double y) {
            return Math.sin(x);
        }
    }
    ,
    sinh{

        @Override
        public double evaluate(double x, double y) {
            return Math.sinh(x);
        }
    }
    ,
    square{

        @Override
        public double evaluate(double x, double y) {
            return x * x;
        }
    }
    ,
    sqrt{

        @Override
        public double evaluate(double x, double y) {
            return Math.sqrt(x);
        }
    }
    ,
    tan{

        @Override
        public double evaluate(double x, double y) {
            return Math.tan(x);
        }
    }
    ,
    tanh{

        @Override
        public double evaluate(double x, double y) {
            return Math.tanh(x);
        }
    }
    ,
    erf{

        @Override
        public double evaluate(double x, double y) {
            return ScalarFunctions.Erf.erf((double)x);
        }
    }
    ,
    atan2(2){

        @Override
        public double evaluate(double x, double y) {
            return Math.atan2(x, y);
        }
    }
    ,
    fmod(2){

        @Override
        public double evaluate(double x, double y) {
            return x % y;
        }
    }
    ,
    ldexp(2){

        @Override
        public double evaluate(double x, double y) {
            return x * Math.pow(2.0, (int)y);
        }
    }
    ,
    max(2){

        @Override
        public double evaluate(double x, double y) {
            return Math.max(x, y);
        }
    }
    ,
    min(2){

        @Override
        public double evaluate(double x, double y) {
            return Math.min(x, y);
        }
    }
    ,
    pow(2){

        @Override
        public double evaluate(double x, double y) {
            return Math.pow(x, y);
        }
    }
    ,
    bit(2){

        @Override
        public double evaluate(double x, double y) {
            return (int)y < 8 && (int)y >= 0 && ((int)x & 1 << (int)y) != 0 ? 1.0 : 0.0;
        }
    }
    ,
    hamming(2){

        @Override
        public double evaluate(double x, double y) {
            return ScalarFunctions.Hamming.hamming((double)x, (double)y);
        }
    };

    private final int arity;

    private Function() {
        this(1);
    }

    private Function(int arity) {
        this.arity = arity;
    }

    public abstract double evaluate(double var1, double var3);

    public int arity() {
        return this.arity;
    }
}

