/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation.hll;

import com.google.common.base.Preconditions;
import com.yahoo.searchlib.aggregation.hll.Sketch;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import java.util.Arrays;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class NormalSketch
extends Sketch<NormalSketch> {
    public static final int classId = NormalSketch.registerClass((int)16554, NormalSketch.class, NormalSketch::new);
    private final byte[] data;
    private final int bucketMask;
    private static final LZ4Factory lz4Factory = LZ4Factory.safeInstance();

    public NormalSketch() {
        this(10);
    }

    public NormalSketch(int precision) {
        this.data = new byte[1 << precision];
        this.bucketMask = (1 << precision) - 1;
    }

    @Override
    public void merge(NormalSketch other) {
        Preconditions.checkArgument((this.data.length == other.data.length ? 1 : 0) != 0, (String)"Trying to merge sketch with one of different size. Expected %s, actual %s", (int)this.data.length, (int)other.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (byte)Math.max(this.data[i], other.data[i]);
        }
    }

    @Override
    public void aggregate(Iterable<Integer> hashValues) {
        for (int hash : hashValues) {
            this.aggregate(hash);
        }
    }

    @Override
    public void aggregate(int hash) {
        byte existingValue = this.data[hash & this.bucketMask];
        int newValue = Integer.numberOfLeadingZeros(hash | this.bucketMask) + 1;
        this.data[hash & this.bucketMask] = (byte)Math.max(newValue, existingValue);
    }

    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putInt(null, this.data.length);
        try {
            LZ4Compressor c = lz4Factory.highCompressor();
            byte[] compressedData = new byte[this.data.length];
            int compressedSize = c.compress(this.data, compressedData);
            NormalSketch.serializeDataArray(compressedData, compressedSize, buf);
        }
        catch (LZ4Exception e) {
            NormalSketch.serializeDataArray(this.data, this.data.length, buf);
        }
    }

    private static void serializeDataArray(byte[] source, int length, Serializer buf) {
        buf.putInt(null, length);
        for (int i = 0; i < length; ++i) {
            buf.putByte(null, source[i]);
        }
    }

    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        int length = buf.getInt(null);
        int compressedLength = buf.getInt(null);
        Preconditions.checkState((length == this.data.length ? 1 : 0) != 0, (String)"Size of serialized sketch does not match expected value. Expected %s, actual %s.", (int)this.data.length, (int)length);
        if (length == compressedLength) {
            NormalSketch.deserializeDataArray(this.data, length, buf);
        } else {
            LZ4FastDecompressor c = lz4Factory.fastDecompressor();
            byte[] compressedData = buf.getBytes(null, compressedLength);
            c.decompress(compressedData, this.data);
        }
    }

    private static void deserializeDataArray(byte[] destination, int length, Deserializer buf) {
        for (int i = 0; i < length; ++i) {
            destination[i] = buf.getByte(null);
        }
    }

    public byte[] data() {
        return this.data;
    }

    public int size() {
        return this.data.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NormalSketch sketch = (NormalSketch)((Object)o);
        return Arrays.equals(this.data, sketch.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    protected int onGetClassId() {
        return classId;
    }

    public String toString() {
        return "NormalSketch{data=" + Arrays.toString(this.data) + "}";
    }
}

