/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.yahoo.searchlib.rankingexpression.evaluation.BooleanValue;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.Function;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;

public abstract class DoubleCompatibleValue
extends Value {
    @Override
    public TensorType type() {
        return TensorType.empty;
    }

    @Override
    public boolean hasDouble() {
        return true;
    }

    @Override
    public Tensor asTensor() {
        return this.doubleAsTensor(this.asDouble());
    }

    @Override
    public Value negate() {
        return new DoubleValue(-this.asDouble());
    }

    @Override
    public Value not() {
        return new BooleanValue(!this.asBoolean());
    }

    @Override
    public Value or(Value value) {
        if (value instanceof TensorValue) {
            TensorValue tensor = (TensorValue)value;
            return tensor.or(this);
        }
        return new BooleanValue(this.asBoolean() || value.asBoolean());
    }

    @Override
    public Value and(Value value) {
        if (value instanceof TensorValue) {
            TensorValue tensor = (TensorValue)value;
            return tensor.and(this);
        }
        return new BooleanValue(this.asBoolean() && value.asBoolean());
    }

    @Override
    public Value largerOrEqual(Value value) {
        if (value instanceof TensorValue) {
            TensorValue tensor = (TensorValue)value;
            return tensor.largerOrEqual(this);
        }
        return new BooleanValue(this.asDouble() >= value.asDouble());
    }

    @Override
    public Value larger(Value value) {
        if (value instanceof TensorValue) {
            TensorValue tensor = (TensorValue)value;
            return tensor.larger(this);
        }
        return new BooleanValue(this.asDouble() > value.asDouble());
    }

    @Override
    public Value smallerOrEqual(Value value) {
        if (value instanceof TensorValue) {
            TensorValue tensor = (TensorValue)value;
            return tensor.smallerOrEqual(this);
        }
        return new BooleanValue(this.asDouble() <= value.asDouble());
    }

    @Override
    public Value smaller(Value value) {
        if (value instanceof TensorValue) {
            TensorValue tensor = (TensorValue)value;
            return tensor.smaller(this);
        }
        return new BooleanValue(this.asDouble() < value.asDouble());
    }

    @Override
    public Value approxEqual(Value value) {
        if (value instanceof TensorValue) {
            TensorValue tensor = (TensorValue)value;
            return tensor.approxEqual(this);
        }
        return new BooleanValue(DoubleCompatibleValue.approxEqual(this.asDouble(), value.asDouble()));
    }

    @Override
    public Value notEqual(Value value) {
        if (value instanceof TensorValue) {
            TensorValue tensor = (TensorValue)value;
            return tensor.notEqual(this);
        }
        return new BooleanValue(this.asDouble() != value.asDouble());
    }

    @Override
    public Value equal(Value value) {
        if (value instanceof TensorValue) {
            TensorValue tensor = (TensorValue)value;
            return tensor.equal(this);
        }
        return new BooleanValue(this.asDouble() == value.asDouble());
    }

    @Override
    public Value add(Value value) {
        if (value instanceof TensorValue) {
            TensorValue tensor = (TensorValue)value;
            return tensor.add(this);
        }
        return new DoubleValue(this.asDouble() + value.asDouble());
    }

    @Override
    public Value subtract(Value value) {
        if (value instanceof TensorValue) {
            TensorValue tensor = (TensorValue)value;
            return tensor.subtract(this);
        }
        return new DoubleValue(this.asDouble() - value.asDouble());
    }

    @Override
    public Value multiply(Value value) {
        if (value instanceof TensorValue) {
            TensorValue tensor = (TensorValue)value;
            return tensor.multiply(this);
        }
        return new DoubleValue(this.asDouble() * value.asDouble());
    }

    @Override
    public Value divide(Value value) {
        if (value instanceof TensorValue) {
            TensorValue tensor = (TensorValue)value;
            return tensor.divide(this);
        }
        return new DoubleValue(this.asDouble() / value.asDouble());
    }

    @Override
    public Value modulo(Value value) {
        if (value instanceof TensorValue) {
            TensorValue tensor = (TensorValue)value;
            return tensor.modulo(this);
        }
        return new DoubleValue(this.asDouble() % value.asDouble());
    }

    @Override
    public Value power(Value value) {
        if (value instanceof TensorValue) {
            TensorValue tensor = (TensorValue)value;
            return tensor.power(this);
        }
        return new DoubleValue(Function.pow.evaluate(this.asDouble(), value.asDouble()));
    }

    @Override
    public Value function(Function function, Value value) {
        if (value instanceof TensorValue) {
            TensorValue tensor = (TensorValue)value;
            return tensor.function(function, this);
        }
        return new DoubleValue(function.evaluate(this.asDouble(), value.asDouble()));
    }

    static boolean approxEqual(double x, double y) {
        if (y < -1.0 || y > 1.0) {
            x = Math.nextAfter(x / y, 1.0);
            y = 1.0;
        } else {
            x = Math.nextAfter(x, y);
        }
        return x == y;
    }
}

